/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.PlatformHelper;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalBase
extends JSEntityDataHolder {
    private final Map<LivingEntity, Integer> blacklist = new HashMap<LivingEntity, Integer>();

    public JSAnimalBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(TravelersPathType.DAMAGE_FIRE, -1.0f);
        this.moveController = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
        this.f_21365_ = new JSLookControl(this);
        this.f_19811_ = true;
        this.createModuleHolder();
        if (this.modules != null) {
            this.modules.init();
        }
        if (TravelersMain.isDebugging()) {
            JSConstants.LOG.warn("Added {} to the world.", (Object)this.getAnimal().getAnimalAttributes().getAnimalName());
        }
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6162_() {
        if (this.getModules() == null) {
            return true;
        }
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    public boolean isStalking() {
        return !this.isDead() && (Boolean)this.f_19804_.m_135370_(stalking) != false;
    }

    public void onGrowthStageChange(AnimalGrowthStage newStage) {
        if (this.m_9236_().f_46443_) {
            return;
        }
    }

    public void m_147240_(double strength, double x, double z) {
        if (this.isDead()) {
            return;
        }
        super.m_147240_(strength, x, z);
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.m_142535_(fallDistance, multiplier, source);
        }
        return false;
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.m_5639_(fallDistance, damageMultiplier);
        }
        return 0;
    }

    public double m_20188_() {
        return super.m_20188_();
    }

    protected void createModuleHolder() {
        this.modules = new JSModuleHolder(this);
    }

    public JSAnimal<?> getAnimal() {
        return (JSAnimal)super.getAnimal();
    }

    public float getRenderScale() {
        return this.getModules().getGrowthStageModule().getSize();
    }

    @NotNull
    protected AABB m_142242_() {
        TravelersAnimal animal1 = this.getAnimal();
        if (animal1 == null || !this.m_9236_().m_46749_(this.m_20183_())) {
            return this.m_6972_(this.m_20089_()).m_20393_(this.m_20182_());
        }
        return this.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)animal1);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (this.getModules() != null && this.getModules().getGrowthStageModule().getDimensions() != null) {
            return this.getModules().getGrowthStageModule().getDimensions();
        }
        return super.m_6972_(pose);
    }

    @Nullable
    public ItemStack m_142340_() {
        ItemStack stack = ((Item)this.getAnimal().getItems().getSpawnEgg().get()).m_7968_();
        JSGeneUtil.writeToStack(stack, this.getModules().getGeneticModule().getGeneData());
        return stack;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == this.m_269291_().m_269318_()) {
            this.setLeaping(false);
        }
        this.curInjuredTicks = 4;
        boolean wasHurt = super.m_6469_(source, amount);
        if (amount > 0.0f) {
            if (source.m_276093_(DamageTypes.f_268613_)) {
                return false;
            }
            this.handleCorpseHit(source, wasHurt, amount);
            this.getModules().getMetabolismModule().interrupt(10);
        }
        for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.onHitBy(this, this.m_21188_(), source, amount);
        }
        return wasHurt;
    }

    private void handleCorpseHit(@NotNull DamageSource source, boolean wasHurt, float amount) {
        if (!this.isDead()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        TravelersAnimalAttributes animalAttributes = this.getAnimal().getAnimalAttributes();
        if (!(source.m_7640_() instanceof ServerPlayer || source.m_7639_() instanceof ServerPlayer || source.m_276093_(DamageTypes.f_268464_))) {
            return;
        }
        if (!(wasHurt && animalAttributes.getItemProperties().isHasDrops() && animalAttributes.getMiscProperties().isShouldCorpseDropItems())) {
            return;
        }
        float maxHealth = (float)this.getScaledMaxHealth();
        int totalExpectedDrops = (int)Math.max(1.0f, maxHealth / 8.0f);
        int dropsToSpawn = Math.max(1, totalExpectedDrops - this.corpseDropCount);
        if (dropsToSpawn > this.corpseDropCount) {
            if (this.corpseDropCount == 0) {
                Supplier<Item> item = this.getAnimal().getItems().getFossil_remains();
                if (animalAttributes.getItemProperties().isHasFossil() && item != null) {
                    this.m_19983_(new ItemStack((ItemLike)item.get(), 1));
                } else if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                    this.m_19983_(new ItemStack((ItemLike)item.get(), 1));
                }
            }
            int i = 0;
            while ((float)i < amount) {
                if (this.f_19796_.m_188501_() < 0.2f && this.corpseDropCount != 0) {
                    item = this.getAnimal().getItems().getFossil_remains();
                    if (animalAttributes.getItemProperties().isHasFossil() && item != null) {
                        this.m_19983_(new ItemStack((ItemLike)item.get(), 1));
                    } else if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                        this.m_19983_(new ItemStack((ItemLike)item.get(), 1));
                    }
                } else {
                    item = this.getAnimal().getItems().getRawMeat();
                    if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                        this.m_19983_(new ItemStack((ItemLike)item.get(), 1));
                    }
                }
                ++this.corpseDropCount;
                if (this.corpseDropCount >= dropsToSpawn) break;
                ++i;
            }
        }
    }

    protected void m_6153_() {
        if (this.isDead() || this.shouldDieInstantly()) {
            if (this.shouldDieInstantly() && this.getAnimal().getAnimalAttributes().getItemProperties().isHasDrops()) {
                if (this.getAnimal().getAnimalAttributes().getItemProperties().isHasMeat() && this.f_19796_.m_188501_() < 0.6f) {
                    this.m_19983_(new ItemStack((ItemLike)this.getAnimal().getItems().getRawMeat().get(), this.f_19796_.m_188503_(4) + 1));
                }
                if (this.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct() && this.f_19796_.m_188501_() < 0.6f) {
                    this.m_19983_(new ItemStack((ItemLike)this.getAnimal().getItems().getFossil_remains().get(), this.f_19796_.m_188503_(4) + 1));
                }
            }
            if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
        this.m_146912_();
        this.setDead(true);
        this.m_21153_((float)this.getScaledMaxHealth());
        this.stopInPlace();
        this.f_21344_.m_26573_();
        this.navigationController.stop();
        this.f_21345_.m_148105_().clear();
    }

    public boolean shouldDieInstantly() {
        return false;
    }

    protected float m_6121_() {
        return this.isDead() || this.m_5803_() || this.isStalking() ? 0.0f : Math.max(1.0f, this.getRenderScale());
    }

    public void m_7334_(Entity entity) {
        double otherPoints;
        double hitboxPoints = this.m_20205_() + this.m_20206_();
        if (hitboxPoints - (otherPoints = (double)(entity.m_20206_() + entity.m_20205_())) < -1.0) {
            return;
        }
        super.m_7334_(entity);
    }

    public void setExtraStat(Attribute stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            this.statMap.put(stat, (Double)this.statMap.get(stat) + i);
        } else {
            this.statMap.put(stat, i);
        }
    }

    public void removeFromStat(Attribute stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            double count = Math.max(0.0, (Double)this.statMap.get(stat) - i);
            if (count > 0.0) {
                this.statMap.put(stat, count);
            } else {
                this.statMap.remove(stat);
            }
        }
    }

    public double m_21133_(@NotNull Attribute attribute) {
        double stats;
        double d = stats = this.statMap != null ? this.statMap.getOrDefault(attribute, 0.0) : 0.0;
        if (this.getModules() == null) {
            return super.m_21133_(attribute);
        }
        if (attribute == Attributes.f_22276_) {
            return this.getScaledMaxHealth() + stats;
        }
        if (attribute == Attributes.f_22282_) {
            double val = super.m_21133_(attribute);
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            return Mth.m_14139_((double)scale, (double)(val / 4.0), (double)val) + stats;
        }
        if (attribute == Attributes.f_22281_ || attribute == Attributes.f_22284_ || attribute == Attributes.f_22285_ || attribute == Attributes.f_22279_) {
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            double max = super.m_21133_(attribute) + stats;
            return Mth.m_14139_((double)scale, (double)(max / 4.0), (double)max);
        }
        return super.m_21133_(attribute) + stats;
    }

    private double getScaledMaxHealth() {
        if (this.getAnimal() == null) {
            return super.m_21133_(Attributes.f_22276_);
        }
        double maxHealth = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMaxHealth();
        float scale = this.getModules().getGrowthStageModule().getPercentage();
        if (scale == 0.0f || scale == 1.0f) {
            return maxHealth;
        }
        return Mth.m_14139_((double)scale, (double)Math.min(5.0, maxHealth / 15.0), (double)maxHealth);
    }

    protected float m_6118_() {
        TravelersPath path;
        if (this.m_20069_()) {
            return super.m_6118_();
        }
        if (this.jumpHeight() > 1.0 && (path = this.getNavigationController().getPath()) != null && !path.isDone() && path.getNextNodeIndex() < path.getNodeCount()) {
            TravelersNode nextNode = path.getNextNode();
            if ((double)nextNode.y > this.m_20186_()) {
                double diff = (double)nextNode.y - this.m_20186_();
                return (float)((double)super.m_6118_() * ((double)1.2f + diff / 3.0));
            }
        }
        return this.m_20069_() ? super.m_6118_() : super.m_6118_() * 2.35f;
    }

    public void m_6135_() {
        float f = this.m_6118_();
        if (!(f <= 1.0E-5f)) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, f, vec3.f_82481_);
            if (this.m_20142_()) {
                float f1 = this.m_146908_() * ((float)Math.PI / 180);
                this.m_246865_(new Vec3((double)(-Mth.m_14031_((float)f1)) * 0.2, 0.0, (double)Mth.m_14089_((float)f1) * 0.2));
            }
            this.f_19812_ = true;
            JSAnimalBase jSAnimalBase = this;
            if (jSAnimalBase instanceof IJSLeapingEntity) {
                IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
                leapingEntity.onLeap();
            }
        }
    }

    public void m_8119_() {
        if (this.getAnimal() != null && this.firstTick) {
            this.m_20011_(this.m_142242_());
            this.firstTick = false;
        } else if (this.isStaticCreature) {
            return;
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.modules.clientTick();
        }
        if (this.curInjuredTicks-- > 0) {
            --this.curInjuredTicks;
        }
        if (this.curAttackTicks > 0) {
            --this.curAttackTicks;
        }
        if (this.curCallingTicks > 0) {
            --this.curCallingTicks;
            if (this.curCallingTicks == 10) {
                this.callSounds();
            }
        }
        if (this.curEatTicks > 0) {
            --this.curEatTicks;
        }
        if (this.curDrinkTicks > 0) {
            --this.curDrinkTicks;
        }
        if (this.curSleepInteruptions > 0) {
            --this.curSleepInteruptions;
        }
        this.modules.tick();
        if (((Boolean)this.f_19804_.m_135370_(refreshData)).booleanValue()) {
            this.f_19804_.m_135381_(refreshData, (Object)false);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            double efficiency = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getWaterEfficiency();
            double accelMultiplier = 1.0 + efficiency * 0.8;
            Vec3 scaledInput = travelVector.m_82542_(accelMultiplier, 1.0, accelMultiplier);
            super.m_7023_(scaledInput);
            return;
        }
        super.m_7023_(travelVector);
    }

    public void m_8107_() {
        LivingEntity target;
        if (this.isStaticCreature && !this.firstTick) {
            return;
        }
        super.m_8107_();
        if (this.m_5448_() != null && (target = this.m_5448_()).m_213877_()) {
            this.m_6710_(null);
        }
        this.modules.aiStep();
    }

    public float getTurnMultiplier() {
        return 5000.0f;
    }

    @Override
    protected void m_8024_() {
        TravelersNode nextPos;
        TravelersPath path;
        if (this.isStaticCreature) {
            return;
        }
        this.getAnimal().animateServer(this, this.moveAnalysis, this.getAnimationModule());
        super.m_8024_();
        if (this.isDead()) {
            return;
        }
        if ((double)this.m_21223_() < this.getScaledMaxHealth() && this.f_19797_ % 20 == 0 && this.f_19796_.m_188501_() > 0.9f) {
            this.m_21153_((float)Math.min(this.getScaledMaxHealth(), (double)(this.m_21223_() + this.regenHealth)));
        }
        this.tickBlacklist(this.m_9236_());
        if (this.m_5803_() || this.isResting()) {
            if (this.m_21188_() != null) {
                this.getModules().getMetabolismModule().interrupt(500);
            }
            if (this.isMoving() && this.curSleepInteruptions > 100) {
                this.getModules().getMetabolismModule().interrupt(500);
            } else {
                this.curSleepInteruptions += 10;
            }
        }
        LivingEntity target = this.m_5448_();
        boolean isClose = false;
        if (target != null && this.m_20270_((Entity)target) < this.m_20205_() * this.m_20205_() * 3.0f) {
            double dx = target.m_20185_() - this.m_20185_();
            double dz = target.m_20189_() - this.m_20189_();
            double dy = target.m_20188_() - this.m_20188_();
            float headYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float headPitch = Mth.m_14036_((float)((float)(-(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232))), (float)-20.0f, (float)20.0f);
            this.m_5616_(headYaw);
            this.m_146926_(headPitch);
            isClose = true;
        }
        if (!isClose && (path = this.getNavigationController().getPath()) != null && this.navigationController.isInProgress() && (nextPos = path.getNextNode()) != null) {
            BlockPos pos = nextPos.asBlockPos();
            double dx = (double)pos.m_123341_() - this.m_20185_();
            double dz = (double)pos.m_123343_() - this.m_20189_();
            float headYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.m_5616_(headYaw);
            this.m_146926_(0.0f);
        }
        if (!this.isMoving() && this.shouldSleep() && !this.m_5803_() && this.canSleep()) {
            this.setSleeping(true);
        }
        if (this.m_5803_() && !this.shouldSleep()) {
            this.setSleeping(false);
        }
        this.modules.serverAiStep();
        if (this.attackDelay > 0) {
            --this.attackDelay;
            if (this.attackDelay == 10) {
                JSAnimalBase base;
                if (this.m_20270_((Entity)this.pendingTarget) > this.getAttackReach() * 3.0f) {
                    return;
                }
                if (this.isDead()) {
                    return;
                }
                this.actuallyAttack(this.pendingTarget);
                LivingEntity livingEntity = this.pendingTarget;
                if (livingEntity instanceof JSAnimalBase && (base = (JSAnimalBase)livingEntity).isDead()) {
                    this.getModules().getMetabolismModule().eatCorpse(base);
                }
            }
            if (this.attackDelay == 0 && this.pendingTarget != null) {
                this.pendingTarget = null;
                this.attackDelay = -1;
            }
        }
        if (this.isLeaping()) {
            Vec3 forward = this.m_20154_().m_82541_().m_82490_(0.02);
            this.m_20256_(this.m_20184_().m_82549_(forward));
        }
    }

    private boolean canSleep() {
        if (this.isDead()) {
            return false;
        }
        if (this.getNavigationController().isInProgress()) {
            return false;
        }
        if (this.modules.getMetabolismModule().isInterrupted()) {
            return false;
        }
        if (!this.m_20096_()) {
            return false;
        }
        return !this.m_20069_();
    }

    protected void actuallyAttack(LivingEntity pendingTarget) {
        SeatEntity e;
        Entity vehicle;
        if (pendingTarget.m_20159_() && (vehicle = pendingTarget.m_20202_()) instanceof SeatEntity && (e = (SeatEntity)vehicle).getJsVehicle() != null) {
            this.m_7327_(e.getJsVehicle());
            return;
        }
        this.m_7327_((Entity)pendingTarget);
    }

    public boolean m_6094_() {
        return !this.isDead();
    }

    public boolean m_142391_() {
        return !this.isStaticCreature;
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.canEatFromPlayer(player, hand)) {
            this.onEatFromPlayer(player, hand, itemstack);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6573_(@NotNull Player player) {
        return this.m_20206_() < 1.0f;
    }

    protected boolean canEatFromPlayer(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        return this.modules.getMetabolismModule().getDiet() != null && this.modules.getMetabolismModule().getDiet().canEatItem(itemstack);
    }

    protected void onEatFromPlayer(Player player, InteractionHand hand, ItemStack stack) {
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        this.modules.saveNbt(compound);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.modules.loadNbt(compound);
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.modules.finalizeSpawn(level, difficulty, reason, spawnData);
        this.m_20011_(this.m_142242_());
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected boolean canRunInWater() {
        return false;
    }

    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSGroundNavigation(this, level);
    }

    public float getHeadRotationSpeed() {
        return 0.5f;
    }

    public boolean isMoving() {
        return this.moveAnalysis.isMoving();
    }

    public boolean isDead() {
        return (Boolean)this.f_19804_.m_135370_(dead);
    }

    public boolean shouldSleep() {
        ActiveTime sleeptime = this.getModules().getGeneticModule().getGeneData().getActiveTime();
        return !sleeptime.isActiveNow(this.m_9236_().m_46468_()) && !this.m_20069_();
    }

    public double getTrackingRange() {
        return this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getTrackingRange();
    }

    public float getAttackReach() {
        float width = Math.max(0.5f, this.m_20205_());
        return width * width * 3.0f;
    }

    public void attack(LivingEntity target) {
        if (this.attackDelay == -1) {
            JSAnimalBase base;
            if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead() && this.isCarnivore()) {
                this.curEatTicks = this.eatAnimLength();
                this.attackDelay = this.eatAnimLength() + 10;
            } else {
                this.curAttackTicks = this.attackAnimLength();
                this.attackDelay = this.attackAnimLength() + 10;
            }
            this.pendingTarget = target;
        }
    }

    private boolean isCarnivore() {
        return this.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietType() == AnimalDietType.CARNIVORE;
    }

    protected int attackAnimLength() {
        return 20;
    }

    protected int eatAnimLength() {
        return 75;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean superHurt = super.m_7327_(entity);
        if (!superHurt) {
            return false;
        }
        this.playAttackSound();
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
                jsGene.doHurtTarget(this, e);
            }
        }
        return true;
    }

    protected void playAttackSound() {
        SoundEvent sound = this.getAttackSound();
        if (sound != null) {
            this.m_5496_(sound, this.m_6121_(), this.m_6100_());
        }
    }

    @Nullable
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getCallSound() {
        return null;
    }

    public void callSounds() {
        SoundEvent sound = this.getCallSound();
        if (sound != null) {
            this.m_5496_(sound, this.m_6121_(), this.m_6100_());
        }
    }

    public float m_6113_() {
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.m_6134_();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.m_146908_();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.curSpeed == 0.0) {
            this.curSpeed = baseSpeed;
        }
        float acceleration = 0.025f * this.getAnimal().getAnimalAttributes().getMetabolismProperties().getAccelerationSpeedMultiplier();
        double speed = this.getCrawling() ? baseSpeed * (double)0.87f : (this.isStalking() ? Mth.m_14139_((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * (double)this.getAnimal().getAnimalAttributes().getMetabolismProperties().getStalkingSpeedMultiplier())) : (this.isRunning() ? Mth.m_14139_((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier())) : (this.m_20069_() ? Mth.m_14139_((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier())) : (this.getNavigationController().isInProgress() ? Mth.m_14139_((double)acceleration, (double)this.curSpeed, (double)baseSpeed) : baseSpeed))));
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public void freezeAnimator() {
        this.freezeAnimator = true;
    }

    public void shakeCamera(float multiplier, boolean groundCheck) {
        if (this.isStaticCreature()) {
            return;
        }
        if (!this.m_9236_().f_46443_ && this.canShake()) {
            if (PlatformHelper.properties.getPlatformName().equalsIgnoreCase("fabric")) {
                return;
            }
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this, (TravelersBasePacket)new TravelersShakeCamera(groundCheck, this.shakeAmount() * multiplier, (int)((float)this.shakeLength() * multiplier), this.shakeDistance(), this.m_20182_().m_252839_()));
        }
    }

    @Override
    public void m_6478_(@NotNull MoverType type, @NotNull Vec3 pos) {
        super.m_6478_(type, pos);
    }

    public boolean canShake() {
        return this.shakeAmount() > 0.0f && (float)this.shakeLength() > 0.0f && this.shakeDistance() > 0.0f;
    }

    public int shakeLength() {
        return 0;
    }

    public float shakeAmount() {
        return 0.0f;
    }

    public float shakeDistance() {
        return 0.0f;
    }

    public boolean hasSolidBelow() {
        AABB aabb = this.m_20191_().m_82386_(0.0, -0.05, 0.0);
        AABB check = aabb.m_82377_(-0.1, 0.0, -0.1);
        return this.hasCollisions(check);
    }

    protected boolean checkForCollide() {
        AABB aabb = this.m_20191_();
        return this.hasCollisions(aabb.m_82377_(0.5, 0.0, 0.5));
    }

    protected boolean hasCollisions(AABB boundingBox) {
        return !this.noBlockCollision((Entity)this, boundingBox);
    }

    protected boolean noBlockCollision(@Nullable Entity entity, AABB box) {
        CollisionContext ctx = entity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)entity);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)(box.f_82291_ + 1.0E-7));
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)(box.f_82292_ + 1.0E-7));
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)(box.f_82293_ + 1.0E-7));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    VoxelShape shape;
                    pos.m_122178_(x, y, z);
                    BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
                    if (state.m_60795_() || (shape = state.m_60742_((BlockGetter)this.m_9236_(), (BlockPos)pos, ctx)).m_83281_() || !shape.m_83215_().m_82386_((double)x, (double)y, (double)z).m_82381_(box)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void tickBlacklist(Level level) {
        int now = (int)level.m_46467_();
        this.blacklist.entrySet().removeIf(e -> (Integer)e.getValue() <= now);
    }

    public void blackListAnimal(LivingEntity target) {
        int expireTick = (int)(target.m_9236_().m_46467_() + 800L);
        this.blacklist.put(target, expireTick);
    }

    public boolean checkBlacklist(LivingEntity mob) {
        if (mob != null && mob.m_20270_((Entity)this) < 16.0f) {
            this.blacklist.remove(mob);
            return false;
        }
        return this.blacklist.containsKey(mob);
    }

    public void onGestationFinished(JSGeneData fatherGeneData) {
        JSAnimalBase cre;
        if (this.getModules().getGeneticModule().isMale()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getAnimal().getAnimalAttributes().getMetabolismProperties().isLiveBirth() && (cre = JSUtils.spawnCreature(this.getAnimal(), this.m_9236_(), this.m_20183_(), JSGeneUtil.combineBreeding(this.m_217043_(), this.getModules().getGeneticModule().getGeneData(), fatherGeneData))) != null) {
            this.getModules().getMetabolismModule().clearBreedingParentData();
        }
    }

    public void onMate(JSAnimalBase other) {
        if (this.getModules().getGeneticModule().isMale()) {
            return;
        }
        this.getModules().getMetabolismModule().maxBreedingCooldown();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel lev = (ServerLevel)level;
            this.getModules().getMetabolismModule().setBreedingParentDNA(other.getModules().getGeneticModule().getGeneData());
            lev.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)this.m_20183_().m_123341_(), (double)((float)this.m_20183_().m_123342_() + this.m_20192_()), (double)this.m_20183_().m_123343_(), 15, 0.5, (double)0.05f, 0.5, 0.2);
        }
    }

    public boolean getEyesClosed() {
        return false;
    }

    public void notifyAboutMe(JSAnimalBase target) {
        if (this.getFleeTarget() == target || this.m_5448_() == target) {
            return;
        }
        if (this.getModules().getMetabolismModule().canTarget(true, true, (Entity)target)) {
            this.m_6710_((LivingEntity)target);
            this.m_21561_(true);
            this.alertHerd((LivingEntity)target);
            this.setFleeTarget(null);
        } else {
            this.setFleeTarget((Entity)target);
            this.m_6710_(null);
        }
    }

    public void alertHerd(LivingEntity threat) {
        JSAnimalBase trueLeader = this.getModules().getHerdModule().getTrueLeader();
        if (trueLeader != null) {
            for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                    follower.m_6710_(threat);
                    follower.m_21561_(true);
                    continue;
                }
                follower.setFleeTarget((Entity)threat);
            }
            trueLeader.m_6710_(threat);
        }
    }
}

