/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersSmoothSwimMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class JSAquaticBase
extends JSAnimalBase {
    private static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.m_135353_(JSAquaticBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public JSAquaticBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.TRAPDOOR, -1.0f);
        this.moveController = new TravelersSmoothSwimMoveControl((SmartAnimalBase)this, this.getAnimal().getAnimalAttributes().getMiscProperties().getMaxHeadXRot(), this.getAnimal().getAnimalAttributes().getMiscProperties().getMaxHeadYRot(), 0.01f, 0.1f, true);
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends JSAquaticBase> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20072_() && this.m_20096_() && this.shouldFlop()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), (double)this.flopHeight(), (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_6853_(false);
            this.f_19812_ = true;
        }
    }

    public float flopHeight() {
        return 0.5f;
    }

    public boolean shouldFlop() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_()) {
            if (!this.m_204029_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            } else {
                this.m_21208_();
            }
        }
        if (this.m_20069_()) {
            this.f_19804_.m_135381_(SWIMMING, (Object)true);
        }
        if (this.m_20069_() || this.f_19800_) {
            TravelersPath path;
            if (this.checkForCollide()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0225, 0.0));
            }
            if ((path = this.getNavigationController().getPath()) != null && !path.isDone()) {
                Vec3 pathPos = path.getNextEntityPos((Entity)this);
                if (this.m_21573_().m_26577_()) {
                    this.m_21573_().m_26573_();
                }
                double y = this.m_20182_().f_82480_;
                double difference = pathPos.f_82480_ - y;
                double distance = Math.abs(difference);
                if (Math.abs(difference) > 0.1) {
                    float uplift = (float)Mth.m_14139_((double)Math.min(1.0, distance / 2.0), (double)(this.getUpLift() * 0.5), (double)(this.getUpLift() * 2.0));
                    if (difference > 0.0) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)uplift, 0.0));
                    } else {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-uplift), 0.0));
                    }
                }
            }
        }
    }

    protected double getUpLift() {
        return 0.0135;
    }

    @Override
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_9236_().f_46443_ && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Override
    protected boolean canRunInWater() {
        return true;
    }

    public boolean m_6063_() {
        return this.isDead();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWIMMING, (Object)false);
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSAquaticNavigation(this, level, this.allowBreaching());
    }

    private boolean allowBreaching() {
        return true;
    }

    protected float m_6108_() {
        return 0.1f;
    }

    public double m_20204_() {
        return this.m_274421_();
    }

    protected void m_21208_() {
        if (this.isDead()) {
            super.m_21208_();
        }
    }

    public boolean m_6069_() {
        return (Boolean)this.f_19804_.m_135370_(SWIMMING);
    }

    @Override
    protected float m_6118_() {
        return this.m_6069_() ? super.m_6118_() : 0.0f;
    }
}

