/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersFlyingMoveControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAvianBase
extends JSAnimalBase {
    public static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DIVING = SynchedEntityData.m_135353_(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> WANTS_TO_LAND = SynchedEntityData.m_135353_(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> FLAPPING = SynchedEntityData.m_135353_(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GLIDING = SynchedEntityData.m_135353_(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private JSFlyingNavigation flyingPathNavigation;
    private JSGroundNavigation groundPathNavigation;
    protected final TravelersFlyingMoveControl flyingMoveControl;
    protected final TravelersMoveControl animalMoveControl = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
    protected float stamina = 1.0f;
    protected float staminaDrainRate = 0.0015f;
    protected float staminaRegenRate = 0.0025f;
    private int takeoffCooldown = 0;
    private int landingCooldown = 0;

    public JSAvianBase(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.flyingMoveControl = new TravelersFlyingMoveControl((SmartAnimalBase)this, this.getAnimal(), this.hoversInPlace());
        this.moveController = this.animalMoveControl;
        this.f_21365_ = new JSLookControl(this);
    }

    public JSFlyingNavigation getFlyingPathNavigation() {
        if (this.flyingPathNavigation == null) {
            this.flyingPathNavigation = new JSFlyingNavigation(this, this.m_9236_());
        }
        return this.flyingPathNavigation;
    }

    public JSGroundNavigation getGroundPathNavigation() {
        if (this.groundPathNavigation == null) {
            this.groundPathNavigation = new JSGroundNavigation(this, this.m_9236_());
        }
        return this.groundPathNavigation;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getGroundPathNavigation();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(DIVING, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_LAND, (Object)true);
        this.f_19804_.m_135372_(FLAPPING, (Object)false);
        this.f_19804_.m_135372_(GLIDING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public boolean wantsToLand() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_LAND);
    }

    public boolean isDiving() {
        return (Boolean)this.f_19804_.m_135370_(DIVING);
    }

    public void setDiving(boolean diving) {
        this.f_19804_.m_135381_(DIVING, (Object)diving);
    }

    @Override
    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.isFlying()) {
            if (this.m_6109_()) {
                if (this.m_20077_()) {
                    this.m_19920_(0.02f, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                } else {
                    float f = 0.95f;
                    float speed = this.m_6113_();
                    this.m_19920_(speed, travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82542_((double)0.91f, (double)f, (double)0.91f));
                }
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public float m_6113_() {
        return this.isFlying() ? (float)this.m_21204_().m_22185_(Attributes.f_22280_) : super.m_6113_();
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (!this.isFlying()) {
            super.m_7840_(y, onGround, state, pos);
        }
    }

    @Override
    public boolean m_6147_() {
        return super.m_6147_() && !this.isFlying();
    }

    @Override
    public void m_6135_() {
        if (!this.isFlying()) {
            super.m_6135_();
        }
    }

    public void m_6862_(boolean jumping) {
        if (!this.isFlying()) {
            super.m_6862_(jumping);
        }
    }

    @NotNull
    public JumpControl m_21569_() {
        return new FlyingJumpControl(this);
    }

    protected boolean hoversInPlace() {
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.takeoffCooldown > 0) {
            --this.takeoffCooldown;
        }
        if (this.landingCooldown > 0) {
            --this.landingCooldown;
        }
        this.handleStamina();
        super.m_8107_();
        this.m_20242_(this.hoversInPlace());
        if (this.isDead() && !this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.075, 0.0));
            return;
        }
        if (this.m_5803_() || this.isResting()) {
            if (!this.m_20096_() && this.isFlying()) {
                this.f_19804_.m_135381_(WANTS_TO_LAND, (Object)true);
            } else if (this.isFlying() && this.m_20096_()) {
                this.setFlying(false);
            }
            return;
        }
        if (this.disableFlyTransitions() || this.getModules().getMetabolismModule().isThirsty()) {
            if (!this.isFlying()) {
                this.setFlying(true);
            }
            return;
        }
        if (this.m_20184_().f_82480_ < -10.0 && !this.isFlying() || this.m_20069_()) {
            this.setFlying(true);
        }
        if (this.isFlying()) {
            this.handleFlying();
            this.tryLanding();
        } else {
            this.tryTakeoff();
        }
    }

    private void handleStamina() {
        if (this.isFlying()) {
            this.stamina = Math.max(0.0f, this.stamina - this.staminaDrainRate);
            if (this.stamina <= 0.0f) {
                this.f_19804_.m_135381_(WANTS_TO_LAND, (Object)true);
            }
        } else if (this.m_20096_() || this.hasSolidBelow()) {
            this.stamina = Math.min(1.0f, this.stamina + this.staminaRegenRate);
        }
    }

    private void handleFlying() {
        boolean goingUpOrFlat;
        Vec3 motion = this.m_20184_();
        boolean bl = this.getNavigationController().isDone() ? motion.f_82480_ > (double)-0.06f : (goingUpOrFlat = motion.f_82480_ >= -0.1);
        if (goingUpOrFlat) {
            this.setFlapping(true);
            this.setGliding(false);
        } else {
            this.setFlapping(false);
            this.setGliding(true);
        }
        if (this.getNavigationController().isDone()) {
            if (motion.f_82480_ < 0.0) {
                Vec3 forward = this.m_20154_().m_82541_().m_82490_((double)this.m_6113_());
                this.m_20256_(forward.m_82520_(0.0, -0.1, 0.0));
            } else if (!this.hoversInPlace()) {
                this.m_20256_(motion.m_82520_(0.0, -0.005, 0.0));
            } else {
                this.m_20256_(new Vec3(motion.f_82479_, 0.01, motion.f_82481_));
            }
        }
        if (!this.wantsToLand() && this.stamina < 0.5f && this.f_19796_.m_188501_() < 0.01f) {
            this.f_19804_.m_135381_(WANTS_TO_LAND, (Object)true);
        }
    }

    public boolean m_142039_() {
        return (Boolean)this.f_19804_.m_135370_(FLAPPING);
    }

    public boolean isGliding() {
        return (Boolean)this.f_19804_.m_135370_(GLIDING);
    }

    private void setFlapping(boolean val) {
        this.f_19804_.m_135381_(FLAPPING, (Object)val);
    }

    private void setGliding(boolean val) {
        this.f_19804_.m_135381_(GLIDING, (Object)val);
    }

    private void tryLanding() {
        if (this.landingCooldown > 0) {
            return;
        }
        if ((this.m_20096_() || this.hasSolidBelow()) && this.wantsToLand()) {
            this.setFlying(false);
            this.landingCooldown = 40;
        }
    }

    private void tryTakeoff() {
        if (this.takeoffCooldown > 0) {
            return;
        }
        if (this.stamina > 0.95f && this.f_19796_.m_188501_() < 0.02f) {
            this.setFlying(true);
            this.takeoffCooldown = 60;
        }
    }

    public void setFlying(boolean flying) {
        if (this.isFlying() == flying) {
            return;
        }
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        this.f_19804_.m_135381_(WANTS_TO_LAND, (Object)(!flying ? 1 : 0));
        if (flying) {
            this.moveController = this.flyingMoveControl;
            if (this.getNavigationController() == this.getGroundPathNavigation()) {
                this.getGroundPathNavigation().stop();
                this.getGroundPathNavigation().setFrozen(false);
            }
            this.navigationController = this.getFlyingPathNavigation();
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.075, 0.0));
            } else {
                Vec3 mv = this.m_20184_();
                this.m_20256_(new Vec3(mv.f_82479_, 0.0, mv.f_82481_));
            }
        } else {
            this.moveController = this.animalMoveControl;
            this.navigationController = this.getGroundPathNavigation();
            this.getFlyingPathNavigation().stop();
            this.m_20256_(Vec3.f_82478_);
            this.takeoffCooldown = 60;
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("js.isFlying", this.isFlying());
        tag.m_128379_("js.isLanding", this.wantsToLand());
        tag.m_128350_("js.stamina", this.stamina);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        boolean flying = tag.m_128471_("js.isFlying");
        this.f_19804_.m_135381_(WANTS_TO_LAND, (Object)tag.m_128471_("js.isLanding"));
        if (tag.m_128441_("js.stamina")) {
            this.stamina = tag.m_128457_("js.stamina");
        }
        this.setFlying(flying);
    }

    public boolean disableFlyTransitions() {
        return false;
    }

    public int getDistanceOfGround() {
        return -1;
    }

    private static class FlyingJumpControl
    extends JumpControl {
        private final JSAvianBase base;

        public FlyingJumpControl(JSAvianBase mob) {
            super((Mob)mob);
            this.base = mob;
        }

        public void m_24901_() {
            this.f_24897_ = true;
        }

        public void m_8124_() {
            if (this.base.isFlying()) {
                if (this.base.f_20899_) {
                    this.base.m_6862_(false);
                    this.f_24897_ = false;
                }
            } else {
                this.base.m_6862_(this.f_24897_);
                this.f_24897_ = false;
            }
        }
    }
}

