/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSEntityDataHolder
extends SmartAnimalBase {
    public static final EntityDataAccessor<Boolean> leaping = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> male = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> refreshData = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> panicking = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> resting = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> sleeping = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> stalking = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> observing = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> dead = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> onGround = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> crawling = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> additionalScale = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> aggression = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> textureVariant = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<CompoundTag> gene_data = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<CompoundTag> growth_data = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<CompoundTag> metabolism_data = SynchedEntityData.m_135353_(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public int curInjuredTicks;
    public int curAttackTicks;
    public int curCallingTicks;
    public int curEatTicks;
    public int curDrinkTicks;
    public int curSleepInteruptions;
    protected int attackDelay = -1;
    protected int corpseDropCount = 0;
    protected float regenHealth = 1.0f;
    protected float previousYaw = 0.0f;
    protected double curSpeed = 0.0;
    public BlockPos lastDrankAtPos;
    public BlockPos lastAteAtPos;
    private BlockState inBlockState;
    protected Entity fleeTarget;
    protected LivingEntity pendingTarget;
    protected boolean isStaticCreature;
    protected boolean isFrozenInPlace;
    protected boolean firstTick = true;
    protected float nextStep;
    protected int lastCrystalSoundPlayTick;
    protected float crystalSoundIntensity;
    protected HashMap<Attribute, Double> statMap = new HashMap();
    protected JSModuleHolder modules;

    protected JSEntityDataHolder(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(male, (Object)false);
        this.f_19804_.m_135372_(panicking, (Object)false);
        this.f_19804_.m_135372_(refreshData, (Object)false);
        this.f_19804_.m_135372_(resting, (Object)false);
        this.f_19804_.m_135372_(sleeping, (Object)false);
        this.f_19804_.m_135372_(stalking, (Object)false);
        this.f_19804_.m_135372_(observing, (Object)false);
        this.f_19804_.m_135372_(dead, (Object)false);
        this.f_19804_.m_135372_(onGround, (Object)false);
        this.f_19804_.m_135372_(crawling, (Object)false);
        this.f_19804_.m_135372_(additionalScale, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(aggression, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(textureVariant, (Object)JSVariants.NONE.getName());
        this.f_19804_.m_135372_(gene_data, (Object)new CompoundTag());
        this.f_19804_.m_135372_(growth_data, (Object)new CompoundTag());
        this.f_19804_.m_135372_(metabolism_data, (Object)new CompoundTag());
        this.f_19804_.m_135372_(leaping, (Object)false);
    }

    protected void m_8024_() {
        super.m_8024_();
        boolean grounded = this.checkOnGround();
        this.f_19804_.m_135381_(onGround, (Object)grounded);
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        Vec3 movement;
        if (this.f_19794_) {
            this.m_6034_(this.m_20185_() + pos.f_82479_, this.m_20186_() + pos.f_82480_, this.m_20189_() + pos.f_82481_);
            return;
        }
        this.f_146810_ = this.m_6060_();
        if (type == MoverType.PISTON && (pos = this.m_20133_(pos)).equals((Object)Vec3.f_82478_)) {
            return;
        }
        ProfilerFiller profiler = this.m_9236_().m_46473_();
        profiler.m_6180_("move");
        if (this.f_19865_.m_82556_() > 1.0E-7) {
            pos = pos.m_82559_(this.f_19865_);
            this.f_19865_ = Vec3.f_82478_;
            this.m_20256_(Vec3.f_82478_);
        }
        if ((movement = this.m_20272_(pos = this.m_5763_(pos, type))).m_82556_() > 1.0E-7) {
            this.handleFallReset(movement);
            this.m_6034_(this.m_20185_() + movement.f_82479_, this.m_20186_() + movement.f_82480_, this.m_20189_() + movement.f_82481_);
        }
        profiler.m_7238_();
        profiler.m_6180_("rest");
        this.updateCollisions(pos, movement);
        this.updateGroundAndFallDamage(movement);
        if (this.m_213877_()) {
            profiler.m_7238_();
            return;
        }
        this.handleHorizontalCollision();
        this.handleBlockInteractions(pos, movement);
        this.handleMovementEmission(pos, movement);
        this.m_146872_();
        this.applyBlockSpeedFactor();
        this.handleFireAndExtinguish();
        profiler.m_7238_();
    }

    private void handleFallReset(Vec3 movement) {
        BlockHitResult hit;
        if (this.f_19789_ != 0.0f && movement.m_82556_() >= 1.0 && (hit = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(movement), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
            this.m_183634_();
        }
    }

    private void updateCollisions(Vec3 input, Vec3 result) {
        boolean xCollide = !Mth.m_14082_((double)input.f_82479_, (double)result.f_82479_);
        boolean zCollide = !Mth.m_14082_((double)input.f_82481_, (double)result.f_82481_);
        this.f_19862_ = xCollide || zCollide;
        this.f_19863_ = input.f_82480_ != result.f_82480_;
        this.f_201939_ = this.f_19863_ && input.f_82480_ < 0.0;
        this.f_185931_ = this.f_19862_ && this.m_196406_(result);
    }

    private void updateGroundAndFallDamage(Vec3 movement) {
        BlockPos pos = this.m_216999_();
        BlockState state = this.m_9236_().m_8055_(pos);
        this.m_7840_(movement.f_82480_, this.m_20096_(), state, pos);
    }

    private void handleHorizontalCollision() {
        if (!this.f_19862_) {
            return;
        }
        Vec3 delta = this.m_20184_();
        this.m_20334_(this.f_19862_ ? 0.0 : delta.f_82479_, delta.f_82480_, this.f_19862_ ? 0.0 : delta.f_82481_);
    }

    private void handleBlockInteractions(Vec3 input, Vec3 movement) {
        BlockPos pos = this.m_216999_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (input.f_82480_ != movement.f_82480_) {
            block.m_5548_((BlockGetter)this.m_9236_(), (Entity)this);
        }
        if (this.m_20096_()) {
            block.m_141947_(this.m_9236_(), pos, state, (Entity)this);
        }
    }

    private void handleMovementEmission(Vec3 input, Vec3 movement) {
        Entity.MovementEmission emission = this.m_142319_();
        if (!emission.m_146944_() || this.m_20159_()) {
            return;
        }
        double dx = movement.f_82479_;
        double dy = this.m_285776_(this.m_9236_().m_8055_(this.m_20097_())) ? movement.f_82480_ : 0.0;
        double dz = movement.f_82481_;
        this.f_146794_ += (float)(movement.m_82553_() * (double)0.6f);
        this.f_19787_ += (float)(movement.m_165924_() * (double)0.6f);
        this.f_19788_ += (float)(Math.sqrt(dx * dx + dy * dy + dz * dz) * (double)0.6f);
        if (this.f_19788_ <= this.nextStep) {
            if (this.m_9236_().m_8055_(this.m_20097_()).m_60795_()) {
                this.m_146874_();
            }
            return;
        }
        BlockPos current = this.m_20097_();
        BlockPos previous = this.m_216999_();
        BlockState curState = this.m_9236_().m_8055_(current);
        BlockState prevState = this.m_9236_().m_8055_(previous);
        boolean sameBlock = current.equals((Object)previous);
        boolean triggered = this.m_286065_(previous, prevState, emission.m_146946_(), sameBlock, input);
        if (!sameBlock) {
            triggered |= this.m_286065_(current, curState, false, emission.m_146945_(), input);
        }
        if (triggered || this.m_20069_()) {
            this.nextStep = this.m_6059_();
            if (this.m_20069_()) {
                if (emission.m_146946_()) {
                    this.m_280447_();
                }
                if (emission.m_146945_()) {
                    this.m_146850_(GameEvent.f_157786_);
                }
            }
        }
    }

    private void applyBlockSpeedFactor() {
        float factor = this.m_6041_();
        this.m_20256_(this.m_20184_().m_82542_((double)factor, 1.0, (double)factor));
    }

    private void handleFireAndExtinguish() {
        boolean inFireBlock = this.m_9236_().m_46847_(this.m_20191_().m_82406_(1.0E-6)).anyMatch(s -> s.m_204336_(BlockTags.f_13076_) || s.m_60713_(Blocks.f_49991_));
        if (!inFireBlock) {
            if (this.m_20094_() <= 0) {
                this.m_7311_(-this.m_6101_());
            }
            if (this.f_146810_ && (this.f_146808_ || this.m_20071_())) {
                this.m_146873_();
            }
        }
        if (this.m_6060_() && (this.f_146808_ || this.m_20071_())) {
            this.m_7311_(-this.m_6101_());
        }
    }

    private Vec3 m_20272_(Vec3 vec) {
        boolean flag3;
        AABB aabb = this.m_20191_();
        List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(vec));
        Vec3 vec3 = vec.m_82556_() == 0.0 ? vec : JSEntityDataHolder.m_198894_((Entity)this, vec, aabb, this.m_9236_(), list);
        boolean flag = vec.f_82479_ != vec3.f_82479_;
        boolean flag1 = vec.f_82480_ != vec3.f_82480_;
        boolean flag2 = vec.f_82481_ != vec3.f_82481_;
        boolean bl = flag3 = flag1 && vec.f_82480_ < 0.0;
        if (this.m_274421_() > 0.0f && (flag3 || this.m_20096_()) && (flag || flag2)) {
            float[] afloat;
            AABB aabb1 = flag3 ? aabb.m_82386_(0.0, vec3.f_82480_, 0.0) : aabb;
            AABB aabb2 = aabb1.m_82363_(vec.f_82479_, (double)this.m_274421_(), vec.f_82481_);
            if (!flag3) {
                aabb2 = aabb2.m_82363_(0.0, (double)-1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = JSEntityDataHolder.collectColliders((Entity)this, this.m_9236_(), list, aabb2);
            float f = (float)vec3.f_82480_;
            for (float f1 : afloat = JSEntityDataHolder.collectCandidateStepUpHeights(aabb1, list1, this.m_274421_(), f)) {
                Vec3 vec31 = JSEntityDataHolder.m_198900_(new Vec3(vec.f_82479_, (double)f1, vec.f_82481_), aabb1, list1);
                if (!(vec31.m_165925_() > vec3.m_165925_())) continue;
                double d0 = aabb.f_82289_ - aabb1.f_82289_;
                return vec31.m_82520_(0.0, -d0, 0.0);
            }
        }
        return vec3;
    }

    private static float[] collectCandidateStepUpHeights(AABB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : colliders) {
            DoubleListIterator var7 = voxelshape.m_7700_(Direction.Axis.Y).iterator();
            while (var7.hasNext()) {
                double d0 = var7.next();
                float f = (float)(d0 - box.f_82289_);
                if (f < 0.0f || f == maxUpStep) continue;
                if (f > deltaY) continue block0;
                floatset.add(f);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3 m_198894_(@Nullable Entity entity, Vec3 motion, AABB box, Level level, List<VoxelShape> entityHits) {
        return JSEntityDataHolder.m_198900_(motion, box, JSEntityDataHolder.collectColliders(entity, level, entityHits, box.m_82369_(motion)));
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity entity, Level level, List<VoxelShape> entityHits, AABB box) {
        ImmutableList.Builder shapes = ImmutableList.builderWithExpectedSize((int)(entityHits.size() + 2));
        if (!entityHits.isEmpty()) {
            shapes.addAll(entityHits);
        }
        WorldBorder border = level.m_6857_();
        if (entity != null && border.m_187566_(entity, box)) {
            shapes.add((Object)border.m_61946_());
        }
        shapes.addAll(level.m_186434_(entity, box));
        return shapes.build();
    }

    private static Vec3 m_198900_(Vec3 motion, AABB box, List<VoxelShape> shapes) {
        boolean resolveZFirst;
        if (shapes.isEmpty()) {
            return motion;
        }
        double x = motion.f_82479_;
        double y = motion.f_82480_;
        double z = motion.f_82481_;
        if (y != 0.0 && (y = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)box, shapes, (double)y)) != 0.0) {
            box = box.m_82386_(0.0, y, 0.0);
        }
        boolean bl = resolveZFirst = Math.abs(x) < Math.abs(z);
        if (resolveZFirst && z != 0.0 && (z = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)box, shapes, (double)z)) != 0.0) {
            box = box.m_82386_(0.0, 0.0, z);
        }
        if (x != 0.0) {
            x = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)box, shapes, (double)x);
            if (!resolveZFirst && x != 0.0) {
                box = box.m_82386_(x, 0.0, 0.0);
            }
        }
        if (!resolveZFirst && z != 0.0) {
            z = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)box, shapes, (double)z);
        }
        return new Vec3(x, y, z);
    }

    private boolean m_285776_(BlockState state) {
        return state.m_204336_(BlockTags.f_13082_) || state.m_60713_(Blocks.f_152499_);
    }

    private boolean m_286065_(BlockPos pos, BlockState state, boolean playStepSound, boolean broadcastGameEvent, Vec3 entityPos) {
        boolean flag = this.m_285776_(state);
        if ((this.m_20096_() || flag || this.m_6047_() && entityPos.f_82480_ == 0.0 || this.m_288188_()) && !this.m_6069_()) {
            if (playStepSound) {
                this.m_280440_(pos, state);
            }
            if (broadcastGameEvent) {
                this.m_9236_().m_214171_(GameEvent.f_157785_, this.m_20182_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)state));
            }
            return true;
        }
        return false;
    }

    private void m_280440_(BlockPos pos, BlockState state) {
        this.m_7355_(pos, state);
        if (this.m_277063_(state)) {
            this.m_277116_();
        }
    }

    private boolean m_277063_(BlockState state) {
        return state.m_204336_(BlockTags.f_144270_) && this.f_19797_ >= this.lastCrystalSoundPlayTick + 20;
    }

    private void m_277116_() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.f_19797_ - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f = 0.5f + this.crystalSoundIntensity * this.f_19796_.m_188501_() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.m_5496_(SoundEvents.f_144243_, f1, f);
        this.lastCrystalSoundPlayTick = this.f_19797_;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(leaping);
    }

    public void setLeaping(boolean isLeaping) {
        this.f_19804_.m_135381_(leaping, (Object)isLeaping);
    }

    private boolean checkOnGround() {
        AABB box = this.m_20191_();
        double feetY = box.f_82289_ - 0.05;
        AABB groundCheck = new AABB(box.f_82288_, feetY, box.f_82290_, box.f_82291_, box.f_82289_ + 0.05, box.f_82293_);
        for (VoxelShape shape : this.m_9236_().m_186434_((Entity)this, groundCheck)) {
            if (shape.m_83281_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_20096_() {
        return (Boolean)this.f_19804_.m_135370_(onGround);
    }

    public void m_6853_(boolean onGround) {
    }

    public void m_289603_(boolean onGround, @NotNull Vec3 movement) {
    }

    public void setCrawling(boolean bool) {
        this.f_19804_.m_135381_(crawling, (Object)bool);
        this.m_6210_();
    }

    public boolean getCrawling() {
        return (Boolean)this.f_19804_.m_135370_(crawling);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("js.animal.dead", ((Boolean)this.f_19804_.m_135370_(dead)).booleanValue());
        this.saveBlockPos("js.lastdrankat", this.lastDrankAtPos, compound);
        this.saveBlockPos("js.lastateat", this.lastAteAtPos, compound);
    }

    private void saveBlockPos(String string, BlockPos pos, CompoundTag compound) {
        if (pos != null) {
            compound.m_128405_(string + ".x", pos.m_123341_());
            compound.m_128405_(string + ".y", pos.m_123342_());
            compound.m_128405_(string + ".z", pos.m_123343_());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(dead, (Object)compound.m_128471_("js.animal.dead"));
        this.lastDrankAtPos = this.readBlockPos(compound, "js.lastdrankat");
        this.lastAteAtPos = this.readBlockPos(compound, "js.lastateat");
    }

    private BlockPos readBlockPos(CompoundTag compound, String string) {
        if (!compound.m_128441_(string + ".x")) {
            return null;
        }
        return new BlockPos(compound.m_128451_(string + ".x"), compound.m_128451_(string + ".y"), compound.m_128451_(string + ".z"));
    }

    void setDead(boolean aBoolean) {
        this.f_19804_.m_135381_(dead, (Object)aBoolean);
    }

    public void setIsPanicking(boolean isPanicking) {
        this.f_19804_.m_135381_(panicking, (Object)isPanicking);
    }

    public boolean isPanicking() {
        return (Boolean)this.f_19804_.m_135370_(panicking);
    }

    public void setResting(boolean isResting) {
        this.f_19804_.m_135381_(resting, (Object)isResting);
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(resting);
    }

    public void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(sleeping, (Object)isSleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(sleeping);
    }

    public void setStalking(boolean isStalking) {
        this.f_19804_.m_135381_(stalking, (Object)isStalking);
    }

    public void setObserving(boolean isObserving) {
        this.f_19804_.m_135381_(observing, (Object)isObserving);
    }

    public boolean isObserving() {
        return (Boolean)this.f_19804_.m_135370_(observing);
    }

    public float getAggression() {
        return ((Float)this.f_19804_.m_135370_(aggression)).floatValue();
    }

    public void setAggression(float aggresionValue) {
        this.f_19804_.m_135381_(aggression, (Object)Float.valueOf(aggresionValue));
    }

    public float m_274421_() {
        return 1.0f;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.m_9236_().m_8055_(this.m_20183_());
        }
        return this.inBlockState;
    }

    public int getCurInjuredTicks() {
        return this.curInjuredTicks;
    }

    public int getCurAttackTicks() {
        return this.curAttackTicks;
    }

    public int getCurCallingTicks() {
        return this.curCallingTicks;
    }

    public int getCurEatTicks() {
        return this.curEatTicks;
    }

    public int getCurDrinkTicks() {
        return this.curDrinkTicks;
    }

    public int getCurSleepInteruptions() {
        return this.curSleepInteruptions;
    }

    public int getAttackDelay() {
        return this.attackDelay;
    }

    public int getCorpseDropCount() {
        return this.corpseDropCount;
    }

    public float getRegenHealth() {
        return this.regenHealth;
    }

    public float getPreviousYaw() {
        return this.previousYaw;
    }

    public double getCurSpeed() {
        return this.curSpeed;
    }

    public BlockPos getLastDrankAtPos() {
        return this.lastDrankAtPos;
    }

    public BlockPos getLastAteAtPos() {
        return this.lastAteAtPos;
    }

    public Entity getFleeTarget() {
        return this.fleeTarget;
    }

    public LivingEntity getPendingTarget() {
        return this.pendingTarget;
    }

    public boolean isStaticCreature() {
        return this.isStaticCreature;
    }

    public boolean isFrozenInPlace() {
        return this.isFrozenInPlace;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public float getNextStep() {
        return this.nextStep;
    }

    public int getLastCrystalSoundPlayTick() {
        return this.lastCrystalSoundPlayTick;
    }

    public float getCrystalSoundIntensity() {
        return this.crystalSoundIntensity;
    }

    public HashMap<Attribute, Double> getStatMap() {
        return this.statMap;
    }

    public JSModuleHolder getModules() {
        return this.modules;
    }

    public void setCurInjuredTicks(int curInjuredTicks) {
        this.curInjuredTicks = curInjuredTicks;
    }

    public void setCurAttackTicks(int curAttackTicks) {
        this.curAttackTicks = curAttackTicks;
    }

    public void setCurCallingTicks(int curCallingTicks) {
        this.curCallingTicks = curCallingTicks;
    }

    public void setCurEatTicks(int curEatTicks) {
        this.curEatTicks = curEatTicks;
    }

    public void setCurDrinkTicks(int curDrinkTicks) {
        this.curDrinkTicks = curDrinkTicks;
    }

    public void setCurSleepInteruptions(int curSleepInteruptions) {
        this.curSleepInteruptions = curSleepInteruptions;
    }

    public void setAttackDelay(int attackDelay) {
        this.attackDelay = attackDelay;
    }

    public void setCorpseDropCount(int corpseDropCount) {
        this.corpseDropCount = corpseDropCount;
    }

    public void setRegenHealth(float regenHealth) {
        this.regenHealth = regenHealth;
    }

    public void setPreviousYaw(float previousYaw) {
        this.previousYaw = previousYaw;
    }

    public void setCurSpeed(double curSpeed) {
        this.curSpeed = curSpeed;
    }

    public void setLastDrankAtPos(BlockPos lastDrankAtPos) {
        this.lastDrankAtPos = lastDrankAtPos;
    }

    public void setLastAteAtPos(BlockPos lastAteAtPos) {
        this.lastAteAtPos = lastAteAtPos;
    }

    public void setInBlockState(BlockState inBlockState) {
        this.inBlockState = inBlockState;
    }

    public void setFleeTarget(Entity fleeTarget) {
        this.fleeTarget = fleeTarget;
    }

    public void setPendingTarget(LivingEntity pendingTarget) {
        this.pendingTarget = pendingTarget;
    }

    public void setStaticCreature(boolean isStaticCreature) {
        this.isStaticCreature = isStaticCreature;
    }

    public void setFrozenInPlace(boolean isFrozenInPlace) {
        this.isFrozenInPlace = isFrozenInPlace;
    }

    public void setFirstTick(boolean firstTick) {
        this.firstTick = firstTick;
    }

    public void setNextStep(float nextStep) {
        this.nextStep = nextStep;
    }

    public void setLastCrystalSoundPlayTick(int lastCrystalSoundPlayTick) {
        this.lastCrystalSoundPlayTick = lastCrystalSoundPlayTick;
    }

    public void setCrystalSoundIntensity(float crystalSoundIntensity) {
        this.crystalSoundIntensity = crystalSoundIntensity;
    }

    public void setStatMap(HashMap<Attribute, Double> statMap) {
        this.statMap = statMap;
    }

    public void setModules(JSModuleHolder modules) {
        this.modules = modules;
    }
}

