/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.diet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class Diet {
    private final Set<Predicate<ItemStack>> conditions = new HashSet<Predicate<ItemStack>>();
    private final Map<Predicate<ItemStack>, Integer> foodOverrides = new HashMap<Predicate<ItemStack>, Integer>();
    private boolean canEatHaybale;
    private boolean canEatMeatCube;
    @NotNull
    private final Set<AnimalDietType> types = new HashSet<AnimalDietType>();

    public Diet(@NotNull AnimalDietType type) {
        this.types.add(type);
    }

    public Diet(Diet other) {
        this.types.addAll(other.types);
        this.foodOverrides.putAll(other.foodOverrides);
        this.conditions.addAll(other.conditions);
        this.canEatHaybale = other.canEatHaybale;
        this.canEatMeatCube = other.canEatMeatCube;
    }

    public boolean is(AnimalDietType diet) {
        return this.types.stream().anyMatch(d -> d == diet);
    }

    public Diet addItem(Item item) {
        this.conditions.add(stack -> stack.m_150930_(item));
        return this;
    }

    public Diet addItem(Item item, int points) {
        this.conditions.add(stack -> stack.m_150930_(item));
        this.foodOverrides.put(stack -> stack.m_150930_(item), Math.max(0, points));
        return this;
    }

    public Diet addItemTag(TagKey<Item> tag) {
        this.conditions.add(stack -> stack.m_204117_(tag));
        return this;
    }

    public Diet addItemTag(TagKey<Item> tag, int points) {
        this.conditions.add(stack -> stack.m_204117_(tag));
        this.foodOverrides.put(stack -> stack.m_204117_(tag), Math.max(0, points));
        return this;
    }

    public Diet addBlock(Block block) {
        return this.addItem(block.m_5456_());
    }

    public Diet addBlockTag(TagKey<Block> tag) {
        this.conditions.add(stack -> {
            Item item = stack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            return block.m_49966_().m_204336_(tag);
        });
        return this;
    }

    public Diet addBlockTag(TagKey<Block> tag, int points) {
        this.conditions.add(stack -> {
            Item item = stack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            return block.m_49966_().m_204336_(tag);
        });
        this.foodOverrides.put(stack -> {
            Item item = stack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            return block.m_49966_().m_204336_(tag);
        }, Math.max(0, points));
        return this;
    }

    public Diet clearFoodOverrides() {
        this.foodOverrides.clear();
        return this;
    }

    public Diet add(Diet diet) {
        this.types.addAll(diet.types);
        this.conditions.addAll(diet.conditions);
        this.foodOverrides.putAll(diet.foodOverrides);
        if (!this.canEatHaybale) {
            this.canEatHaybale = diet.canEatHaybale;
        }
        if (!this.canEatMeatCube) {
            this.canEatMeatCube = diet.canEatMeatCube;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public Diet copy() {
        return new Diet(this);
    }

    public boolean canEat(JSAnimalBase animal, Entity other) {
        boolean same = animal == other || animal.m_6095_() == other.m_6095_();
        return !same;
    }

    public int getFoodPoints(@NotNull JSAnimalBase animal, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        for (Map.Entry<Predicate<ItemStack>, Integer> entry : this.foodOverrides.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        FoodProperties food = stack.m_41720_().m_41473_();
        if (food != null) {
            return (int)JSUtils.toTickMinutes((float)food.m_38744_() * food.m_38745_() / 2.0f);
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block != Blocks.f_50016_) {
            return 5;
        }
        return 1;
    }

    public boolean canEatItem(@NotNull ItemStack stack) {
        ItemStack check = stack.m_41777_();
        check.m_41764_(1);
        for (Predicate<ItemStack> i : this.conditions) {
            if (!i.test(check)) continue;
            return true;
        }
        return false;
    }

    public Set<ItemStack> getAllItems() {
        return BuiltInRegistries.f_257033_.m_123024_().map(ItemStack::new).filter(stack -> this.conditions.stream().anyMatch(pred -> pred.test(stack))).collect(Collectors.toSet());
    }

    public Diet setCanEatMeatCube(boolean canEatMeatCube) {
        this.canEatMeatCube = canEatMeatCube;
        return this;
    }

    public Diet setCanEatHaybale(boolean canEatHaybale) {
        this.canEatHaybale = canEatHaybale;
        return this;
    }

    public boolean isCanEatHaybale() {
        return this.canEatHaybale;
    }

    public boolean isCanEatMeatCube() {
        return this.canEatMeatCube;
    }

    @NotNull
    public Set<AnimalDietType> getTypes() {
        return this.types;
    }
}

