/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import java.util.ArrayList;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSFeedbackModule;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSGeneticModule;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSGrowthStageModule;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;

public class JSModuleHolder {
    private final ArrayList<JSAnimalModuleBase> modules = new ArrayList();
    private final JSGeneticModule geneticModule;
    private final JSGrowthStageModule growthStageModule;
    private final JSMetabolismModule metabolismModule;
    private final JSHerdModule herdModule;
    private final JSFeedbackModule feedbackModule;

    public JSModuleHolder(JSAnimalBase owner) {
        this.geneticModule = new JSGeneticModule(owner);
        this.growthStageModule = new JSGrowthStageModule(owner);
        this.metabolismModule = new JSMetabolismModule(owner);
        this.herdModule = new JSHerdModule(owner);
        this.feedbackModule = new JSFeedbackModule(owner);
    }

    public void init() {
        this.modules.add(this.geneticModule);
        this.modules.add(this.growthStageModule);
        this.modules.add(this.metabolismModule);
        this.modules.add(this.herdModule);
        this.modules.add(this.feedbackModule);
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            module.init();
        }
    }

    public void loadNbt(@NotNull CompoundTag compound) {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            module.loadNbt(compound);
        }
    }

    public void saveNbt(@NotNull CompoundTag compound) {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            module.saveNbt(compound);
        }
    }

    private void profile(String name, Runnable r) {
        if (!TravelersMain.isDebugging()) {
            r.run();
            return;
        }
        long start = System.nanoTime();
        r.run();
        long t = System.nanoTime() - start;
        if (t > 1000000L) {
            System.out.println(name + " took " + (double)t / 1000000.0 + " ms");
        }
    }

    public void tick() {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            this.profile(module.getClass().getSimpleName() + "::tick", module::tick);
        }
    }

    public void serverAiStep() {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            this.profile(module.getClass().getSimpleName() + "::serverAiStep", module::serverAiStep);
        }
    }

    public void aiStep() {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            this.profile(module.getClass().getSimpleName() + "::aiStep", module::aiStep);
        }
    }

    public void clientTick() {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            this.profile(module.getClass().getSimpleName() + "::clientTick", module::clientTick);
        }
    }

    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        for (JSAnimalModuleBase module : this.modules) {
            if (module.disabled) continue;
            long start = System.nanoTime();
            module.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
            long time = System.nanoTime() - start;
            if (time <= 1000000L) continue;
            System.out.println(module.getClass().getSimpleName() + "::finalizeSpawn took " + (double)time / 1000000.0 + " ms");
        }
    }

    public JSGeneticModule getGeneticModule() {
        return this.geneticModule;
    }

    public JSGrowthStageModule getGrowthStageModule() {
        return this.growthStageModule;
    }

    public JSMetabolismModule getMetabolismModule() {
        return this.metabolismModule;
    }

    public JSHerdModule getHerdModule() {
        return this.herdModule;
    }

    public JSFeedbackModule getFeedbackModule() {
        return this.feedbackModule;
    }
}

