/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneticModule
extends JSAnimalModuleBase {
    private JSGeneData geneData;
    private boolean isFertile = true;
    private boolean dirty = false;

    public JSGeneticModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void tick() {
        if (this.dirty) {
            this.geneData = null;
            this.dirty = false;
        }
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        if (this.geneData != null) {
            CompoundTag tag = new CompoundTag();
            this.geneData.saveToNbt(tag);
            nbt.m_128365_("js.genetics.data", (Tag)tag);
        }
        nbt.m_128359_("js.genetics.variant", (String)this.owner.m_20088_().m_135370_(JSEntityDataHolder.textureVariant));
        nbt.m_128379_("js.genetics.male", this.isMale());
        nbt.m_128379_("js.genetics.fertile", this.isFertile);
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        CompoundTag tag = nbt.m_128469_("js.genetics.data");
        JSGeneData geneData = this.getGeneData();
        if (!tag.m_128456_()) {
            geneData.loadFromNbt(tag);
        }
        this.setMale(nbt.m_128471_("js.genetics.male"));
        this.setFertile(nbt.m_128471_("js.genetics.fertile"));
        this.setGeneData(geneData);
    }

    public JSGeneData getGeneData() {
        if (this.geneData == null) {
            CompoundTag tag = (CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.gene_data);
            if (tag == null || tag.m_128456_()) {
                this.geneData = new JSGeneData();
            } else {
                this.geneData = new JSGeneData();
                this.geneData.loadFromNbt(tag);
            }
        }
        return this.geneData;
    }

    public void setGeneData(JSGeneData data) {
        if (data == null) {
            return;
        }
        this.applyGenes(data);
    }

    private void applyGenes(JSGeneData data) {
        if (data == null || data.geneDataHolder == null) {
            return;
        }
        for (JSGene jsGene : data.geneDataHolder.getGENE_SET()) {
            jsGene.applyTo(data, this.owner);
        }
        CompoundTag tag = new CompoundTag();
        data.saveToNbt(tag);
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.gene_data, (Object)tag);
    }

    @Override
    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setMale(level.m_213780_().m_188499_());
        JSGeneData data = this.getGeneData();
        data.setGeneSeed(level.m_213780_().m_188502_());
        data.setSizeDimorphism((float)(1 + level.m_213780_().m_188503_((int)this.owner.getAnimal().getAnimalAttributes().getEntityBaseProperties().getSizeDimorphism())) / 750.0f);
        this.setGeneData(data);
    }

    @Override
    public void init() {
    }

    public void hatch() {
        JSGeneData data = this.getGeneData();
        if (data == null || data.geneDataHolder == null) {
            return;
        }
        for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
            gene.onHatch(this.owner);
        }
    }

    public void setMale(boolean male) {
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.male, (Object)male);
    }

    public boolean isMale() {
        return (Boolean)this.owner.m_20088_().m_135370_(JSEntityDataHolder.male);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isFertile() {
        return this.isFertile;
    }

    public void setFertile(boolean isFertile) {
        this.isFertile = isFertile;
    }
}

