/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;

public class JSMetabolismModule
extends JSAnimalModuleBase {
    private boolean hungerEnabled;
    private boolean thirstEnabled;
    private boolean sleepEnabled;
    private boolean breedingEnabled;
    private boolean isInterrupted;
    private int breedingCooldown;
    private int maxHunger;
    private int maxThirst;
    private int maxGestation;
    private int ticksSleeping;
    private int interruptTicks = 0;
    private Diet diet;
    private JSGeneData fatherGeneData;

    public JSMetabolismModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        nbt.m_128365_("js.metabolism", (Tag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data));
        if (this.fatherGeneData != null) {
            CompoundTag tag = new CompoundTag();
            this.fatherGeneData.saveToNbt(tag);
            nbt.m_128365_("js.metabolism.data.father", (Tag)tag);
        }
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.metabolism_data, (Object)nbt.m_128469_("js.metabolism"));
        this.fatherGeneData = JSGeneUtil.fromCompound(nbt.m_128469_("js.metabolism.data.father"));
    }

    @Override
    public void init() {
        TravelersAnimal animal = this.owner.getAnimal();
        JSMetabolismProperties attributes = animal.getAnimalAttributes().getMetabolismProperties();
        this.hungerEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        this.breedingEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isCanBreed() && this.owner.getModules().getGeneticModule().isFertile();
        this.maxHunger = attributes.getMaxFood();
        this.maxThirst = attributes.getMaxWater();
        this.maxGestation = attributes.getGestationTicks();
    }

    @Override
    public void tick() {
        TravelersAnimal animal = this.owner.getAnimal();
        this.hungerEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        boolean bl = this.breedingEnabled = this.owner.m_9236_().m_46469_().m_46207_(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isCanBreed() && this.owner.getModules().getGeneticModule().isFertile();
        if (this.interruptTicks > 0) {
            --this.interruptTicks;
        } else if (this.isInterrupted) {
            this.isInterrupted = false;
        }
    }

    public Diet getDiet() {
        if (this.diet != null) {
            return this.diet;
        }
        this.diet = this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietSupplier().get();
        return this.diet;
    }

    @Override
    public void serverAiStep() {
        if (this.maxHunger == -1 || this.maxThirst == -1) {
            this.init();
        }
        if (this.owner.isMoving()) {
            if (this.hungerEnabled) {
                int hunger = this.getHunger();
                this.setHunger(Math.max(0, hunger - 1));
                if (hunger == 0 && this.owner.m_217043_().m_188500_() > 0.8) {
                    this.owner.m_6469_(this.owner.m_9236_().m_269111_().m_269064_(), 2.0f);
                }
            }
            if (this.thirstEnabled) {
                int thirst = this.getThirst();
                this.setThirst(Math.max(0, thirst - 1));
                if (thirst == 0 && this.owner.m_217043_().m_188500_() > 0.8) {
                    this.owner.m_6469_(this.owner.m_9236_().m_269111_().m_269483_(), 2.0f);
                }
            }
        }
        if (this.breedingEnabled) {
            int gest = this.getGestation();
            if (this.fatherGeneData != null) {
                this.setGestation(Math.max(0, gest - 1));
                if (gest == 0) {
                    this.owner.onGestationFinished(this.fatherGeneData);
                }
            }
            if (this.getBreedingCooldown() > 0) {
                this.setBreedingCooldown(Math.max(0, this.getBreedingCooldown() - 1));
            }
        }
    }

    public boolean isHungry() {
        return this.hungerPercentage() < 0.75;
    }

    public boolean isThirsty() {
        return this.thirstPercentage() < 0.75;
    }

    public int getHunger() {
        CompoundTag data = (CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data);
        return Math.min(this.maxHunger, data.m_128451_("js.metabolism.hunger"));
    }

    public void setHunger(int newHunger) {
        CompoundTag data = ((CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data)).m_6426_();
        data.m_128405_("js.metabolism.hunger", Math.min(this.maxHunger, newHunger));
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getThirst() {
        CompoundTag data = (CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data);
        return Math.min(this.maxThirst, data.m_128451_("js.metabolism.thirst"));
    }

    public void setThirst(int newThirst) {
        CompoundTag data = ((CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data)).m_6426_();
        data.m_128405_("js.metabolism.thirst", Math.min(this.maxThirst, newThirst));
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getGestation() {
        CompoundTag data = (CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data);
        return data.m_128451_("js.metabolism.gestation");
    }

    public void setGestation(int newGestation) {
        CompoundTag data = ((CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data)).m_6426_();
        data.m_128405_("js.metabolism.gestation", newGestation);
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getBreedingCooldown() {
        CompoundTag data = (CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data);
        return data.m_128451_("js.metabolism.breedingcooldown");
    }

    private void setBreedingCooldown(int newGestation) {
        CompoundTag data = ((CompoundTag)this.owner.m_20088_().m_135370_(JSEntityDataHolder.metabolism_data)).m_6426_();
        data.m_128405_("js.metabolism.breedingcooldown", newGestation);
        this.owner.m_20088_().m_135381_(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public void maxBreedingCooldown() {
        this.setBreedingCooldown((int)((float)this.maxGestation / 2.0f));
    }

    public void setBreedingParentDNA(JSGeneData data) {
        this.fatherGeneData = data;
        if (TravelersMain.isDebugging()) {
            this.setGestation(500);
        } else {
            this.setGestation(this.maxGestation);
        }
    }

    public void clearBreedingParentData() {
        this.fatherGeneData = null;
        this.setGestation(0);
    }

    @Override
    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setMax();
    }

    public void setMax() {
        this.setThirst(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxWater());
        this.setHunger(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxFood());
        this.setBreedingCooldown(this.maxGestation / 2);
    }

    public boolean canTarget(LivingEntity mob) {
        return this.canTarget(true, false, (Entity)mob);
    }

    public boolean canTarget(boolean withBias, boolean revenge, Entity mob) {
        if (!revenge && this.owner.m_6095_() == mob.m_6095_() && this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize() > 1) {
            return false;
        }
        boolean canTarget = false;
        if (!revenge) {
            if (this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets().contains(mob.getClass())) {
                canTarget = true;
            } else {
                for (Class<Entity> huntTarget : this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets()) {
                    if (!huntTarget.isInstance(mob) && mob.getClass() != huntTarget) continue;
                    canTarget = true;
                    this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets().add(mob.getClass());
                    break;
                }
            }
            if (!canTarget) {
                return false;
            }
        }
        if (withBias) {
            JSHerdModule herdModule;
            float naturalAggresion;
            double boundingPoints = this.owner.m_20206_() + this.owner.m_20205_();
            double otherPoints = mob.m_20206_() + mob.m_20205_();
            double aggression = this.owner.getAggression();
            double hungerBias = this.hungerPercentage();
            if (!revenge) {
                otherPoints *= 1.0 + hungerBias;
            }
            if (aggression > 0.0) {
                boundingPoints += boundingPoints * Math.min(aggression, 0.5);
            }
            if ((naturalAggresion = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getNaturalAggression()) > 0.0f) {
                boundingPoints += boundingPoints * (double)naturalAggresion;
            }
            if ((herdModule = this.owner.getModules().getHerdModule()) != null) {
                JSAnimalBase leader;
                if (herdModule.isLeader()) {
                    int size = herdModule.getHerdSize();
                    boundingPoints += boundingPoints * ((double)size * 0.25);
                } else if (herdModule.isFollower() && (leader = herdModule.getTrueLeader()) != null) {
                    if (leader.m_5448_() != null) {
                        int size = leader.getModules().getHerdModule().getHerdSize();
                        boundingPoints += boundingPoints * ((double)size * 0.25);
                    } else {
                        return false;
                    }
                }
            }
            return boundingPoints >= otherPoints * 0.75;
        }
        return true;
    }

    public double hungerPercentage() {
        double value = (double)this.getHunger() / (double)this.maxHunger;
        return value;
    }

    public double thirstPercentage() {
        double value = (double)this.getThirst() / (double)this.maxThirst;
        return value;
    }

    public double gestationPercentage() {
        double value = (double)this.getGestation() / (double)this.maxGestation;
        return value;
    }

    public void interrupt(int ticks) {
        this.isInterrupted = true;
        this.interruptTicks = ticks;
        this.owner.setSleeping(false);
        this.owner.setResting(false);
    }

    public void eatEntity(IJSEdibleEntity edible) {
        this.setHunger(this.getHunger() + edible.getFoodPoints(this.owner));
    }

    public boolean canEatCorpse(JSAnimalBase edible) {
        return true;
    }

    public void eatCorpse(JSAnimalBase edible) {
        edible.m_6469_(edible.m_9236_().m_269111_().m_269333_((LivingEntity)this.owner), 5.0f);
        this.setHunger((int)((float)this.getHunger() + 1000.0f * (edible.m_20205_() + edible.m_20206_())));
    }

    public void addThirst(int thirst) {
        this.setThirst(this.getThirst() + thirst);
    }

    public void addFood(int thirst) {
        this.setHunger(this.getThirst() + thirst);
    }

    public boolean eatItem(ItemStack stack) {
        if (this.getDiet().canEatItem(stack)) {
            double foodValue = 100.0;
            FoodProperties food = stack.m_41720_().m_41473_();
            if (food != null) {
                foodValue += (double)(3500.0f * ((float)food.m_38744_() * food.m_38745_()));
            }
            this.setHunger((int)((double)this.getHunger() + foodValue));
            return true;
        }
        return false;
    }

    public boolean isGestating() {
        return this.getGestation() > 0 || this.fatherGeneData != null;
    }

    public boolean isBreedingInCooldown() {
        return this.getBreedingCooldown() > 0;
    }

    public void resetBreedingCooldown() {
        this.setBreedingCooldown(0);
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public boolean isThirstEnabled() {
        return this.thirstEnabled;
    }

    public boolean isSleepEnabled() {
        return this.sleepEnabled;
    }

    public boolean isBreedingEnabled() {
        return this.breedingEnabled;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getMaxThirst() {
        return this.maxThirst;
    }

    public int getMaxGestation() {
        return this.maxGestation;
    }

    public int getTicksSleeping() {
        return this.ticksSleeping;
    }

    public JSGeneData getFatherGeneData() {
        return this.fatherGeneData;
    }
}

