/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGenericNav;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;

public class JSGroundNavigation
extends TravelersPathNavigation {
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSGroundNavigation(JSAnimalBase mob, Level level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.mob.m_20096_() || this.mob.m_20069_() || this.mob.m_20159_();
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.m_20185_(), (double)this.getSurfaceY(), this.mob.m_20189_());
    }

    private int getSurfaceY() {
        if (this.mob.m_20069_() && !this.mob.m_20096_()) {
            int i = this.mob.m_146904_();
            BlockState blockstate = this.level.m_8055_(BlockPos.m_274561_((double)this.mob.m_20185_(), (double)i, (double)this.mob.m_20189_()));
            int j = 0;
            while (blockstate.m_60713_(Blocks.f_49990_)) {
                blockstate = this.level.m_8055_(BlockPos.m_274561_((double)this.mob.m_20185_(), (double)(++i), (double)this.mob.m_20189_()));
                if (++j <= 16) continue;
                return this.mob.m_146904_();
            }
            return i;
        }
        return Mth.m_14107_((double)(this.mob.m_20186_() + 0.5));
    }

    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState state = this.level.m_8055_(blockpos);
        if (this.base.m_20072_()) {
            return true;
        }
        return state.m_60804_((BlockGetter)this.level, blockpos);
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        if (JSGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            if (this.path.getNodes().size() > this.path.getNextNodeIndex() - 1) {
                this.path.advance();
            } else {
                this.stop();
            }
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public void stop() {
        super.stop();
        this.nodeStuckTime = 0;
        this.curNodeIndex = -1;
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersWalkNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }

    public boolean avoidsLight() {
        return ((TravelersWalkNodeEvaluator)this.nodeEvaluator).isTriesToAvoidLight();
    }

    public void setCanClimb(boolean b) {
        ((TravelersWalkNodeEvaluator)this.nodeEvaluator).setCanClimb(b);
    }
}

