/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav.eval;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;

public class JSCrabNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private final BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos tmp2 = new BlockPos.MutableBlockPos();

    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        mob.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.oldWalkableCost = mob.getPathfindingMalus(TravelersPathType.WALKABLE);
        mob.setPathfindingMalus(TravelersPathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.getPathfindingMalus(TravelersPathType.WATER_BORDER);
        mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.5f);
    }

    public void done() {
        if (this.mob != null) {
            this.mob.setPathfindingMalus(TravelersPathType.WALKABLE, this.oldWalkableCost);
            this.mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, this.oldWaterBorderCost);
        }
        super.done();
    }

    @NotNull
    public TravelersNode getStart() {
        return !this.mob.m_20069_() ? super.getStart() : this.getInnerStart();
    }

    @NotNull
    private TravelersNode getInnerStart() {
        AABB box = this.mob.m_20191_();
        double cx = (box.f_82288_ + box.f_82291_) * 0.5;
        double cy = (box.f_82289_ + box.f_82292_) * 0.5;
        double cz = (box.f_82290_ + box.f_82293_) * 0.5;
        int y = Mth.m_14107_((double)cy);
        this.tmp.m_122169_(cx, (double)y, cz);
        BlockState state = this.context.getBlockState((BlockPos)this.tmp);
        if (!state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                this.tmp.m_122169_(cx, (double)(y - dy), cz);
                if (this.context.getBlockState((BlockPos)this.tmp).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                    y -= dy;
                    found = true;
                    break;
                }
                this.tmp.m_122169_(cx, (double)(y + dy), cz);
                if (!this.context.getBlockState((BlockPos)this.tmp).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = Mth.m_14107_((double)this.mob.m_20186_());
            }
        }
        this.tmp.m_142448_(y);
        return this.getNode((BlockPos)this.tmp);
    }

    public TravelersNodeEvaluator copy() {
        JSCrabNodeEvaluator e = new JSCrabNodeEvaluator();
        this.applyDefaultProperties((TravelersNodeEvaluator)e);
        e.setCanClimb(this.isCanClimb());
        e.setCanClimbAnyBlock(this.isCanClimbAnyBlock());
        return e;
    }

    public int getNeighbors(TravelersNode[] arr, TravelersNode node) {
        int count = super.getNeighbors(arr, node);
        TravelersPathType above = this.getPathType(node.x, node.y + 1, node.z);
        TravelersPathType at = this.getPathType(node.x, node.y, node.z);
        int stepAllowance = this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY ? Mth.m_14143_((float)Math.max(1.0f, this.mob.m_274421_())) : 0;
        stepAllowance = Math.min(stepAllowance, 1);
        this.tmp.m_122178_(node.x, node.y, node.z);
        double floorY = this.getFloorLevel((BlockPos)this.tmp);
        TravelersNode up = this.findAcceptedNode(node, node.x, node.y + 1, node.z, 0, floorY, Direction.UP, at);
        TravelersNode down = this.findAcceptedNode(node, node.x, node.y - 1, node.z, 1, floorY, Direction.DOWN, at);
        if (this.mob.m_20069_() && this.isVerticalNeighborValid(up, node)) {
            arr[count++] = up;
        }
        if (this.isVerticalNeighborValid(down, node) && at != TravelersPathType.TRAPDOOR) {
            arr[count++] = down;
        }
        return this.applyCrabMovementBias(arr, count, node);
    }

    private boolean isVerticalNeighborValid(TravelersNode n, TravelersNode base) {
        if (n == null) {
            return false;
        }
        if (!this.isNeighborValid(n, base)) {
            return false;
        }
        if (n.type != TravelersPathType.WATER) {
            return false;
        }
        this.tmp.m_122178_(n.x, n.y, n.z);
        double floorY = this.getFloorLevel((BlockPos)this.tmp);
        return floorY - (double)n.y <= 1.5;
    }

    private int applyCrabMovementBias(TravelersNode[] arr, int count, TravelersNode base) {
        Direction facing = this.mob.m_6350_();
        Direction left = facing.m_122428_();
        Direction right = facing.m_122427_();
        for (int i = 0; i < count; ++i) {
            Direction d;
            TravelersNode n = arr[i];
            if (n == null || (d = this.horizontalDir(n, base)) == null) continue;
            if (d == left || d == right) {
                n.costMalus *= 0.3f;
                continue;
            }
            n.costMalus *= 1.8f;
        }
        return count;
    }

    private Direction horizontalDir(TravelersNode to, TravelersNode from) {
        int dx = to.x - from.x;
        int dz = to.z - from.z;
        if (dx == 1 && dz == 0) {
            return Direction.EAST;
        }
        if (dx == -1 && dz == 0) {
            return Direction.WEST;
        }
        if (dz == 1 && dx == 0) {
            return Direction.SOUTH;
        }
        if (dz == -1 && dx == 0) {
            return Direction.NORTH;
        }
        return null;
    }

    protected TravelersNode findAcceptedNode(TravelersNode parent, int x, int y, int z, int step, double floor, Direction dir, TravelersPathType baseType) {
        TravelersNode node = super.findAcceptedNode(parent, x, y, z, step, floor, dir, baseType);
        if (node == null) {
            return null;
        }
        TravelersPathType type = this.getPathType(this.context, node.x, node.y, node.z);
        if (type == TravelersPathType.WATER) {
            int snappedY = this.findWaterFloorY(this.context, node.x, node.y, node.z);
            if (snappedY == Integer.MIN_VALUE) {
                return null;
            }
            node.y = snappedY;
            if (!this.hasWaterSolidSupport(this.context, node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private int findWaterFloorY(TravelersPathfindingContext ctx, int x, int y, int z) {
        BlockPos.MutableBlockPos m = this.tmp;
        for (int dy = 0; dy < 8; ++dy) {
            m.m_122178_(x, y - dy, z);
            BlockState bs = ctx.getBlockState((BlockPos)m);
            if (bs.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
            BlockPos.MutableBlockPos solidPos = this.tmp2;
            solidPos.m_122178_(x, y - dy, z);
            BlockState below = ctx.getBlockState((BlockPos)solidPos);
            if (!below.m_60812_((BlockGetter)ctx.level(), (BlockPos)solidPos).m_83281_()) {
                return y - dy + 1;
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    private boolean hasWaterSolidSupport(TravelersPathfindingContext ctx, int x, int y, int z) {
        this.tmp.m_122178_(x, y - 1, z);
        BlockState bs = ctx.getBlockState((BlockPos)this.tmp);
        return !bs.m_60812_((BlockGetter)ctx.level(), (BlockPos)this.tmp).m_83281_();
    }

    protected boolean isAmphibious() {
        return true;
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext ctx, int x, int y, int z) {
        TravelersPathType at = ctx.getPathTypeFromState(x, y, z);
        if (at == TravelersPathType.WATER) {
            for (Direction dir : Direction.values()) {
                this.tmp2.m_122178_(x, y, z).m_122173_(dir);
                TravelersPathType adj = ctx.getPathTypeFromState(this.tmp2.m_123341_(), this.tmp2.m_123342_(), this.tmp2.m_123343_());
                if (adj != TravelersPathType.BLOCKED) continue;
                return TravelersPathType.WATER_BORDER;
            }
            return TravelersPathType.WATER;
        }
        return super.getPathType(ctx, x, y, z);
    }
}

