/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.other;

import java.util.HashMap;
import jp.jurassicsaga.JSCommon;
import net.minecraft.resources.ResourceLocation;

public class JSVariants {
    public static final HashMap<ResourceLocation, JSVariant> VARIANTS = new HashMap();
    public static final JSVariant NONE = new JSVariant(JSCommon.createId("none"), false);
    public static final JSVariant VIVID = new JSVariant(JSCommon.createId("vivid"), false);
    public static final JSVariant ALPINE = new JSVariant(JSCommon.createId("alpine"), false);
    public static final JSVariant FOREST = new JSVariant(JSCommon.createId("forest"), false);
    public static final JSVariant JUNGLE = new JSVariant(JSCommon.createId("jungle"), false);
    public static final JSVariant OCEAN = new JSVariant(JSCommon.createId("ocean"), false);
    public static final JSVariant PASTURE = new JSVariant(JSCommon.createId("pasture"), false);
    public static final JSVariant RAINFOREST = new JSVariant(JSCommon.createId("rainforest"), false);
    public static final JSVariant RIVER = new JSVariant(JSCommon.createId("river"), false);
    public static final JSVariant SAVANNA = new JSVariant(JSCommon.createId("savanna"), false);
    public static final JSVariant STEPPE = new JSVariant(JSCommon.createId("steppe"), false);
    public static final JSVariant TAIGA = new JSVariant(JSCommon.createId("taiga"), false);
    public static final JSVariant TROPICAL = new JSVariant(JSCommon.createId("tropical"), false);
    public static final JSVariant TUNDRA = new JSVariant(JSCommon.createId("tundra"), false);
    public static final JSVariant ARID = new JSVariant(JSCommon.createId("arid"), false);
    public static final JSVariant CHAOS_EFFECT = new JSVariant(JSCommon.createId("chaos_effect"), false);
    public static final JSVariant SPECIAL = new JSVariant(JSCommon.createId("special"), false);
    public static final JSVariant LEGACY = new JSVariant(JSCommon.createId("legacy"), false);

    public static void init() {
        JSVariants.register(NONE);
        JSVariants.register(VIVID);
        JSVariants.register(ALPINE);
        JSVariants.register(FOREST);
        JSVariants.register(JUNGLE);
        JSVariants.register(OCEAN);
        JSVariants.register(PASTURE);
        JSVariants.register(RAINFOREST);
        JSVariants.register(RIVER);
        JSVariants.register(SAVANNA);
        JSVariants.register(STEPPE);
        JSVariants.register(TAIGA);
        JSVariants.register(TROPICAL);
        JSVariants.register(TUNDRA);
        JSVariants.register(ARID);
        JSVariants.register(CHAOS_EFFECT);
        JSVariants.register(SPECIAL);
        JSVariants.register(LEGACY);
    }

    public static void register(JSVariant variant) {
        VARIANTS.putIfAbsent(variant.location, variant);
    }

    public static JSVariant fromLocation(String location) {
        return JSVariants.fromLocation(ResourceLocation.m_135822_((String)location, (char)':'));
    }

    public static JSVariant fromLocation(ResourceLocation location) {
        return VARIANTS.getOrDefault(location, NONE);
    }

    public static class JSVariant {
        private final boolean shouldGlow;
        private final ResourceLocation location;
        private final boolean ignoreGenders;

        public JSVariant(ResourceLocation location, boolean shouldGlow) {
            this.location = location;
            this.shouldGlow = shouldGlow;
            this.ignoreGenders = false;
        }

        public JSVariant(ResourceLocation location, boolean shouldGlow, boolean ignoreGenders) {
            this.location = location;
            this.shouldGlow = shouldGlow;
            this.ignoreGenders = ignoreGenders;
        }

        public ResourceLocation location() {
            return this.location;
        }

        public boolean shouldGlow() {
            return this.shouldGlow;
        }

        public String getName() {
            return this.location.toString();
        }

        public boolean ignoresGenders() {
            return false;
        }
    }
}

