/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSFloatTask
extends JSTaskBase {
    public JSFloatTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.animal.getNavigationController().setCanFloat(true);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        return this.animal.m_20069_() || this.animal.m_204029_(FluidTags.f_13131_);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStart() {
    }

    public void tick() {
        boolean onGround;
        if (!this.animal.m_20069_()) {
            return;
        }
        TravelersPathNavigation navigator = this.animal.getNavigationController();
        TravelersPath path = navigator.getPath();
        if (path != null && !(onGround = this.animal.m_20096_()) && !this.canReachWithoutCollision() && path.getNextNodeIndex() != path.getNodeCount()) {
            BlockPos nextPos = path.getNextNodePos();
            int y = nextPos.m_123342_();
            if (y > this.animal.m_146904_()) {
                this.animal.m_20256_(this.animal.m_20184_().m_82520_(0.0, 0.1, 0.0));
            } else if (y < this.animal.m_146904_()) {
                this.animal.m_20256_(this.animal.m_20184_().m_82520_(0.0, -0.025, 0.0));
                float percentage = (float)this.animal.m_20146_() / (float)this.animal.m_6062_();
                if (percentage > 0.5f) {
                    return;
                }
            }
        }
        if (this.animal.m_204029_(FluidTags.f_13131_) && !this.animal.isAmphibian()) {
            this.animal.m_20256_(this.animal.m_20184_().m_82520_(0.0, 0.03, 0.0));
        }
    }

    private boolean canReachWithoutCollision() {
        AABB aabb = this.animal.m_20191_();
        return !this.hasCollisions(aabb.m_82377_(0.5, 0.0, 0.5));
    }

    private boolean hasCollisions(AABB boundingBox) {
        Level level = this.animal.m_9236_();
        for (VoxelShape blockCollision : level.m_186434_((Entity)this.animal, boundingBox)) {
            if (blockCollision.m_83281_()) continue;
            return true;
        }
        return false;
    }

    public void onStop() {
    }
}

