/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class JSOpenDoorTask
extends JSTaskBase {
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;
    private int forgetTime;

    public JSOpenDoorTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.animal.m_9236_().m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_);
    }

    protected void setOpen(boolean open) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.animal.m_9236_().m_8055_(this.doorPos)).m_60734_() instanceof DoorBlock) {
            ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.animal, this.animal.m_9236_(), blockstate, this.doorPos, open);
        }
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (!JSTaskUtils.hasGroundPathNavigation(this.animal)) {
            return false;
        }
        if (!this.animal.f_19862_) {
            return false;
        }
        BlockPos animalPos = this.animal.m_20183_();
        AABB box = this.animal.m_20191_().m_82377_(2.0, 1.0, 2.0);
        BlockPos closestDoor = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121976_((int)((int)Math.floor(box.f_82288_)), (int)((int)Math.floor(box.f_82289_)), (int)((int)Math.floor(box.f_82290_)), (int)((int)Math.floor(box.f_82291_)), (int)((int)Math.floor(box.f_82292_)), (int)((int)Math.floor(box.f_82293_)))) {
            double dist;
            if (!DoorBlock.m_52745_((Level)this.animal.m_9236_(), (BlockPos)pos) || !((dist = animalPos.m_123331_((Vec3i)pos)) < closestDist)) continue;
            closestDist = dist;
            closestDoor = pos.m_7949_();
        }
        if (closestDoor != null) {
            this.doorPos = closestDoor;
            this.hasDoor = true;
            return true;
        }
        return false;
    }

    public boolean canContinueRunning() {
        return !this.passed && this.forgetTime > 0;
    }

    public void onStart() {
        this.forgetTime = 20;
        this.setOpen(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        float f1;
        --this.forgetTime;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.animal.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.animal.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }

    public void onStop() {
        this.hasDoor = false;
        this.doorPos = BlockPos.f_121853_;
        this.doorOpenDirX = 0.0f;
        this.doorOpenDirZ = 0.0f;
        this.setOpen(false);
    }
}

