/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskPriority;

public class JSCombatLeapTask
extends JSTaskBase {
    private final float yDelta;
    private LivingEntity target;

    public JSCombatLeapTask(JSAnimalBase baseAnimal, float yDelta) {
        super(baseAnimal);
        this.yDelta = yDelta;
        this.setPriority(TaskPriority.LOW);
    }

    public TaskPriority getPriority() {
        if (this.animal.m_5448_() == null) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM_HIGH;
    }

    public void onStart() {
        Vec3 vec3 = this.animal.m_20184_();
        Vec3 flat = new Vec3(this.target.m_20185_() - this.animal.m_20185_(), 0.0, this.target.m_20189_() - this.animal.m_20189_());
        double horizontalDist = Math.sqrt(flat.m_82556_());
        if (flat.m_82556_() > 1.0E-7) {
            flat = flat.m_82541_().m_82490_(1.5);
        }
        double scaledY = Math.max(0.2, horizontalDist * 0.075);
        this.animal.m_20334_(flat.f_82479_, scaledY, flat.f_82481_);
        this.animal.m_246865_(vec3.m_82490_((double)0.2f));
        LivingEntity target = this.animal.m_5448_();
        if (target != null) {
            this.animal.m_21563_().m_148051_((Entity)target);
            this.animal.getNavigationController().stop();
            this.animal.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
            ((IJSLeapingEntity)((Object)this.animal)).onLeap();
        }
    }

    public boolean shouldRun() {
        if (this.animal.m_5803_() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead()) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (!(jSAnimalBase instanceof IJSLeapingEntity)) {
            return false;
        }
        IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
        if (this.animal.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            return false;
        }
        if (this.animal.m_217005_()) {
            return false;
        }
        this.target = this.animal.m_5448_();
        if (this.target == null) {
            return false;
        }
        double d0 = this.animal.m_20238_(this.target.m_20182_());
        if (!(d0 < leapingEntity.maxDistance())) {
            return false;
        }
        return this.animal.m_20096_() && (double)this.random.nextFloat() > 0.7;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        return !this.animal.m_20096_();
    }

    public void tick() {
    }

    public void onStop() {
    }
}

