/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CompsognathusEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;

public class JSCompyCombatTask
extends JSCombatTaskBase {
    protected int recomputePathTicks = 10;
    protected int attackCooldown = 0;
    protected int attackResetTime = 10;

    public JSCompyCombatTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.isResting() || this.animal.m_5803_()) {
            return false;
        }
        List players = this.animal.m_9236_().m_6443_(LivingEntity.class, this.animal.m_20191_().m_82400_(16.0), a -> this.animal.m_142582_((Entity)a) && this.animal.getModules().getMetabolismModule().canTarget(false, false, (Entity)a));
        LivingEntity closest = null;
        double minDist = Double.MAX_VALUE;
        for (LivingEntity p : players) {
            double dist;
            Player player;
            if (p instanceof Player && (player = (Player)p).m_7500_() || !((dist = this.animal.m_20280_((Entity)p)) < minDist)) continue;
            minDist = dist;
            closest = p;
        }
        if (closest != null) {
            this.animal.m_6710_(closest);
            return true;
        }
        return false;
    }

    public void tick() {
        LivingEntity target = this.animal.m_5448_();
        if (target == null) {
            this.stop();
            return;
        }
        this.handleMoveTowards(target, 1.0);
        List nearbyCompys = this.animal.m_9236_().m_6443_(JSAnimalBase.class, this.animal.m_20191_().m_82400_(2.0), animalBase -> animalBase instanceof CompsognathusEntity || animalBase instanceof ProcompsognathusEntity);
        int packSize = (int)((float)nearbyCompys.size() * this.animal.m_21223_());
        float playerHealth = target.m_21223_();
        this.animal.m_21391_((Entity)target, 10.0f, 30.0f);
        if (this.random.nextFloat() < 0.2f && !this.animal.m_142582_((Entity)target)) {
            this.animal.m_6710_(null);
        }
        if ((float)packSize > playerHealth && this.attackCooldown == 0) {
            this.animal.m_21561_(true);
            if (target.m_20280_((Entity)this.animal) <= (double)this.animal.getAttackReach()) {
                this.animal.attack(target);
                this.attackCooldown = 20;
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void handleMoveTowards(LivingEntity target, double speed) {
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            Vec3 targetPos = target.m_20182_();
            Vec3 targetLook = target.m_20154_().m_82541_();
            double distanceAhead = 1.0;
            Vec3 aheadPos = targetPos.m_82549_(targetLook.m_82490_(distanceAhead));
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.f_82479_, aheadPos.f_82480_, aheadPos.f_82481_);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        int size = path.getNodes().size();
                        for (int i = 0; i < 2; ++i) {
                            path.setNextNodeIndex(Math.min(size, path.getNextNodeIndex() + i));
                        }
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(20, 40);
        } else {
            --this.recomputePathTicks;
        }
    }

    public void onStart() {
        LivingEntity target = this.animal.m_5448_();
        if (target == null) {
            this.stop();
            return;
        }
        this.handleMoveTowards(target, 1.0);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStop() {
        this.animal.m_21561_(false);
        this.animal.m_6710_(null);
        this.recomputePathTicks = 10;
    }
}

