/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private boolean isNearEnoughToBody = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;
    private boolean shouldObserve = false;
    private int reachTries = 0;
    private int observeTicks = 0;
    private int maxObserveTicks = 40;
    private final int maxFollowTicks = 2000;
    private int followTicks = 0;
    private double distance = Double.MAX_VALUE;
    private State state = State.AGGRESSIVE;
    private static final double RUN_AWAY_DIST = 10.0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    public JSCombatFollowTask observe() {
        this.shouldObserve = true;
        return this;
    }

    @Override
    public boolean shouldRun() {
        LivingEntity leaderTarget;
        JSHerdModule herdModule;
        Player player;
        LivingEntity livingEntity;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (this.animal.m_5448_() != null && (livingEntity = this.animal.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            if (player.m_20202_() != null) {
                SeatEntity e;
                Entity entity = player.m_20202_();
                if (entity instanceof SeatEntity && (e = (SeatEntity)entity).getJsVehicle() == null) {
                    this.animal.m_6710_(null);
                    return false;
                }
            } else {
                this.animal.m_6710_(null);
                return false;
            }
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().m_5448_()) != null && leaderTarget.m_6084_()) {
            return true;
        }
        return this.animal.m_5448_() != null && this.animal.m_5448_().m_6084_();
    }

    @Override
    public void onStart() {
        LivingEntity target;
        LivingEntity leaderTarget;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.m_5803_()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().m_5448_()) != null && leaderTarget.m_6084_()) {
            this.animal.m_6710_(leaderTarget);
        }
        if ((target = this.animal.m_5448_()) == null) {
            return;
        }
        if (!this.animal.m_5912_() && this.callOut && this.random.nextDouble() < 0.875 && herdModule.getFollowers().isEmpty()) {
            this.state = State.CALLING;
            this.animal.curCallingTicks = 30;
        } else if (!this.animal.m_5912_() && this.shouldObserve && !this.isTargetRunningAway(target) && this.animal.m_21188_() == null) {
            this.state = State.OBSERVING;
            this.observeTicks = 100;
            this.animal.setObserving(true);
        } else {
            this.state = State.AGGRESSIVE;
        }
        this.recomputePathTicks = 0;
    }

    @Override
    public void tick() {
        LivingEntity target;
        if (this.animal.isResting() || this.animal.m_5803_()) {
            this.animal.getModules().getMetabolismModule().interrupt(400);
        }
        if ((target = this.animal.m_5448_()) == null) {
            this.stop();
            return;
        }
        switch (this.state) {
            case CALLING: {
                this.tickCalling(target);
                break;
            }
            case OBSERVING: {
                this.tickObserving(target);
                break;
            }
            case STALKING: {
                this.tickStalking(target);
                break;
            }
            case AGGRESSIVE: {
                this.tickAggresive(target);
            }
        }
    }

    protected void tickCalling(LivingEntity target) {
        this.animal.m_21561_(false);
        if (this.shouldStalk && !this.isTargetRunningAway(target) && !this.canTargetSeeMe(target, (PathfinderMob)this.animal)) {
            this.state = State.STALKING;
            this.animal.setStalking(true);
            return;
        }
        if (this.callingTicks > 0) {
            --this.callingTicks;
            this.animal.stopInPlace();
            if (this.random.nextDouble() < (double)0.05f) {
                this.callingTicks -= 5;
            }
        } else {
            State state = this.state = this.shouldObserve ? State.OBSERVING : State.AGGRESSIVE;
            if (this.state == State.OBSERVING) {
                this.observeTicks = this.maxObserveTicks;
                this.animal.setObserving(true);
            }
        }
    }

    protected void tickObserving(LivingEntity target) {
        JSAnimalBase base;
        this.animal.m_21561_(false);
        if (this.animal.m_20069_() && !(this.animal instanceof JSAquaticBase)) {
            this.switchState(this.state, State.AGGRESSIVE);
            this.state = State.AGGRESSIVE;
            this.animal.m_21561_(true);
            return;
        }
        if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.state = State.AGGRESSIVE;
            this.animal.m_21561_(true);
            this.animal.setStalking(false);
        }
        if (this.observeTicks > 0 && this.shouldObserve) {
            JSAnimalBase base2;
            --this.observeTicks;
            this.animal.stopInPlace();
            double difference = target.m_20188_() - this.animal.m_20188_();
            if (target instanceof JSAnimalBase && (base2 = (JSAnimalBase)target).isDead()) {
                difference = 0.0;
            }
            Vec3 nextPos = new Vec3(target.m_20185_(), this.animal.m_20186_() + difference, target.m_20189_());
            this.animal.m_7618_(EntityAnchorArgument.Anchor.FEET, nextPos);
            if (this.isTargetRunningAway(target)) {
                this.switchState(this.state, State.AGGRESSIVE);
                this.state = State.AGGRESSIVE;
                this.animal.m_21561_(true);
            }
        } else {
            this.animal.setObserving(false);
            if (this.extraCheckBeforeSwitch(target, this.animal)) {
                if (!this.canTargetSeeMe(target, (PathfinderMob)this.animal) && this.shouldStalk) {
                    this.state = State.STALKING;
                    this.animal.setStalking(true);
                } else {
                    this.switchState(this.state, State.AGGRESSIVE);
                }
            } else {
                this.stop();
                return;
            }
        }
    }

    protected void tickStalking(LivingEntity target) {
        JSAnimalBase base;
        if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.state = State.AGGRESSIVE;
            this.animal.m_21561_(true);
            this.animal.setStalking(false);
        }
        this.followTicks = this.animal.isMoving() ? (this.followTicks += 5) : (this.followTicks += 25);
        this.animal.m_21561_(false);
        if (target.m_20280_((Entity)this.animal) <= (double)this.animal.getAttackReach() || this.canTargetSeeMe(target, (PathfinderMob)this.animal) || this.isTargetRunningAway(target)) {
            this.animal.setStalking(false);
            this.animal.m_21561_(true);
            this.state = State.AGGRESSIVE;
        } else {
            this.handleMoveTowards(target, 1.0);
        }
        if (this.followTicks > 2000) {
            this.cancel(target);
        }
    }

    protected void tickAggresive(LivingEntity target) {
        JSAnimalBase base;
        if (target instanceof JSAnimalBase && !(base = (JSAnimalBase)target).isDead()) {
            base.notifyAboutMe(this.animal);
        }
        this.followTicks = this.animal.isMoving() ? (!this.isGainingOnTarget(target, this.animal) ? (this.followTicks += 5) : 0) : (this.followTicks += 25);
        this.animal.m_21561_(true);
        this.handleMoveTowards(target, 1.0);
        if (this.attackCooldown == 0) {
            if (target.m_20280_((Entity)this.animal) <= (double)this.animal.getAttackReach()) {
                this.attack(target);
                this.recomputePathTicks += 5;
                this.attackResetTime = this.attackCooldown;
            }
        } else {
            --this.attackCooldown;
        }
        if (this.followTicks > 2000) {
            this.cancel(target);
        }
    }

    private boolean isGainingOnTarget(LivingEntity target, JSAnimalBase animal) {
        double distance = target.m_20270_((Entity)animal);
        if (distance < this.distance) {
            this.distance = distance;
            return true;
        }
        this.distance = distance;
        return false;
    }

    protected void switchState(State state, State newState) {
        this.state = newState;
        if (newState == State.AGGRESSIVE) {
            this.animal.m_21561_(true);
        }
    }

    private void cancel(LivingEntity target) {
        this.animal.blackListAnimal(target);
        this.stop();
    }

    private void handleMoveTowards(LivingEntity target, double speed) {
        JSAnimalBase base;
        if (target.m_20280_((Entity)this.animal) <= (double)this.animal.getAttackReach() && target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.animal.getNavigationController().stop();
            this.isNearEnoughToBody = true;
            this.animal.m_21563_().m_24964_(target.m_20182_());
            return;
        }
        if (this.isNearEnoughToBody) {
            this.isNearEnoughToBody = false;
            this.animal.getNavigationController().setFrozen(false);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            Vec3 aheadPos;
            Vec3 targetPos = target.m_20182_();
            Vec3 targetVel = target.m_20184_();
            if (targetVel.m_82556_() > 4.0E-4) {
                Vec3 targetLook = target.m_20154_().m_82541_();
                double distanceAhead = 1.0;
                aheadPos = targetPos.m_82549_(targetLook.m_82490_(distanceAhead));
            } else {
                aheadPos = targetPos;
            }
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.f_82479_, aheadPos.f_82480_, aheadPos.f_82481_);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 20;
                    } else if (!path.canReach()) {
                        ++this.reachTries;
                        if (this.reachTries > 10) {
                            this.cancel(target);
                        }
                    } else {
                        float aSpeed = this.animal.m_6113_() * 8.0f;
                        if ((float)path.getNodeCount() < aSpeed) {
                            path.setNextNodeIndex(path.getNodeCount());
                        } else {
                            path.setNextNodeIndex((int)aSpeed);
                        }
                    }
                });
            } else {
                this.recomputePathTicks += 20;
            }
            this.recomputePathTicks += this.random.nextInt(20, 40);
        } else {
            --this.recomputePathTicks;
        }
    }

    protected void attack(LivingEntity target) {
        this.animal.attack(target);
        this.followTicks = 0;
    }

    protected boolean extraCheckBeforeSwitch(LivingEntity target, JSAnimalBase animal) {
        return true;
    }

    protected boolean canTargetSeeMe(LivingEntity target, PathfinderMob entity) {
        double minDot;
        Vec3 toEntity;
        Vec3 entityEyes;
        if (target.m_9236_() != entity.m_9236_()) {
            return false;
        }
        Vec3 targetEyes = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (targetEyes.m_82554_(entityEyes = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_())) > 64.0) {
            return false;
        }
        Vec3 forward = target.m_20154_().m_82541_();
        double dot = forward.m_82526_(toEntity = entityEyes.m_82546_(targetEyes).m_82541_());
        return dot >= (minDot = Math.cos(Math.toRadians(67.5))) && target.m_9236_().m_45547_(new ClipContext(targetEyes, entityEyes, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target)).m_6662_() == HitResult.Type.MISS;
    }

    protected boolean isTargetRunningAway(LivingEntity target) {
        Vec3 targetMove;
        double dist = this.animal.m_20270_((Entity)target);
        if (dist < 10.0) {
            return false;
        }
        Vec3 toAnimal = this.animal.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        return toAnimal.m_82526_(targetMove = target.m_20184_().m_82541_()) < -0.1;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.recomputePathTicks = 0;
        this.callingTicks = this.maxCallingTicks;
        this.animal.getNavigationController().setFrozen(false);
        this.animal.setObserving(false);
        this.animal.m_6710_(null);
        this.animal.setStalking(false);
        this.animal.m_21561_(false);
        this.state = State.AGGRESSIVE;
        this.reachTries = 0;
        this.followTicks = 0;
    }

    protected static enum State {
        CALLING,
        OBSERVING,
        STALKING,
        AGGRESSIVE;

    }
}

