/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TaskGoal;

public class JSRangedAttackTask
extends JSTaskBase {
    private final RangedAttackMob rangedAttackanimal;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public JSRangedAttackTask(JSAnimalBase baseAnimal, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        super(baseAnimal);
        RangedAttackMob rangedAttackanimal;
        if (!(baseAnimal instanceof RangedAttackMob)) {
            throw new IllegalArgumentException("Can't apply ranged attack task to an non ranged entity");
        }
        this.rangedAttackanimal = rangedAttackanimal = (RangedAttackMob)baseAnimal;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.getGoals().add(TaskGoal.MISC);
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isResting() || this.animal.m_5803_()) {
            return false;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        LivingEntity livingentity = this.animal.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueRunning() {
        if (this.target == null) {
            return false;
        }
        if (this.animal.isDead() || this.animal.isResting() || this.animal.m_5803_()) {
            return false;
        }
        return this.shouldRun() || this.target.m_6084_() && !this.animal.getNavigationController().isDone();
    }

    protected boolean runOnce() {
        return false;
    }

    public void onStart() {
    }

    public void tick() {
        if (this.target instanceof LivingEntity) {
            double d0 = this.animal.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.animal.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.animal.getNavigationController().stop();
            } else {
                this.animal.getNavigationController().moveTo((Entity)this.target);
            }
            this.animal.m_21563_().m_148051_((Entity)this.target);
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackanimal.m_6504_(this.target, f1);
                if (this.runOnce()) {
                    this.checkCooldown = 20;
                    this.stop();
                }
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStop() {
        if (this.target != null) {
            this.animal.m_21563_().m_148051_((Entity)this.target);
        }
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }
}

