/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.tag.JSBlockTags;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;
import travelers.server.animal.entity.task.TravelerTaskBase;

public class JSGrazeTask
extends JSTaskBase {
    private Vec3 targetPos;
    private int grazeTicks;
    private int maxGrazeDuration = 40;
    private int xRange = 8;

    public JSGrazeTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetPos != null;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (this.checkCooldown-- > 0) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        BlockPos base = this.animal.m_20183_();
        Level level = this.animal.m_9236_();
        for (int dx = -this.xRange; dx <= this.xRange; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -this.xRange; dz <= this.xRange; ++dz) {
                    BlockPos pos = base.m_7918_(dx, dy, dz);
                    if (!this.isValidEatBlock(pos, level.m_8055_(pos)) || !level.m_46859_(pos.m_7494_())) continue;
                    this.targetPos = Vec3.m_82512_((Vec3i)pos);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canContinueRunning() {
        return this.targetPos != null && this.animal.getModules().getMetabolismModule().isHungry();
    }

    public void onStart() {
        if (this.targetPos != null) {
            this.animal.getNavigationController().moveTo(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
        }
    }

    public void tick() {
        if (this.targetPos == null) {
            return;
        }
        TravelersPathNavigation nav = this.animal.getNavigationController();
        if (!nav.isInProgress()) {
            nav.moveTo(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
        }
        BlockPos grassPos = BlockPos.m_274446_((Position)this.targetPos);
        if (JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 2.0f)) {
            nav.setFrozen(true);
            this.animal.m_7618_(EntityAnchorArgument.Anchor.FEET, this.targetPos);
            ++this.grazeTicks;
            if (this.grazeTicks == 1) {
                this.animal.curEatTicks = 2;
            }
            if (this.grazeTicks >= this.maxGrazeDuration / 2) {
                if (this.isValidEatBlock(grassPos, this.animal.m_9236_().m_8055_(grassPos))) {
                    this.animal.m_9236_().m_7731_(grassPos, Blocks.f_50016_.m_49966_(), 3);
                }
                this.animal.getModules().getMetabolismModule().addFood((int)JSUtils.toTickMinutes(5.0f));
                this.targetPos = null;
                this.grazeTicks = 0;
                this.checkCooldown = this.random.nextInt(1, 3);
                nav.setFrozen(false);
            }
        } else if (nav.isFrozen()) {
            nav.setFrozen(false);
        }
    }

    public void onStop() {
        this.targetPos = null;
        this.grazeTicks = 0;
        this.animal.getNavigationController().setFrozen(false);
    }

    public void cleanUp() {
        this.targetPos = null;
        this.grazeTicks = 0;
        this.animal.getNavigationController().setFrozen(false);
    }

    public TravelerTaskBase setRange(int x, int y) {
        this.xRange = x;
        return this;
    }

    public boolean isValidEatBlock(BlockPos pos, BlockState state) {
        return state.m_204336_(JSBlockTags.EXTINCT_PLANT_BLOCKS) || state.m_60713_(Blocks.f_50034_) || state.m_204336_(JSBlockTags.HERBIVORE_BLOCK_EDIBLE);
    }

    public int getMaxGrazeDuration() {
        return this.maxGrazeDuration;
    }

    public JSGrazeTask setMaxGrazeDuration(int maxGrazeDuration) {
        this.maxGrazeDuration = maxGrazeDuration;
        return this;
    }
}

