/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSMateTask
extends JSTaskBase {
    JSAnimalBase target;
    protected int recomputePathTicks = 10;
    private int movingTicks = 0;

    public JSMateTask(JSAnimalBase en) {
        super(en);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead() || this.animal.m_6162_() || this.animal.getModules().getMetabolismModule().isGestating() || this.animal.m_6069_() || this.animal.getModules().getMetabolismModule().isBreedingInCooldown()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isBreedingEnabled()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (!this.animal.getModules().getMetabolismModule().isBreedingEnabled() || this.animal.getModules().getMetabolismModule().isGestating() || this.animal.getModules().getMetabolismModule().isBreedingInCooldown()) {
            return false;
        }
        if (this.animal.m_5448_() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        if (this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.m_5803_() || this.animal.isPanicking()) {
            return false;
        }
        this.findMate();
        return this.target != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.m_5448_() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        return this.target != null && this.animal.getModules().getMetabolismModule().isBreedingEnabled() && !this.animal.getModules().getMetabolismModule().isGestating() && !this.animal.getModules().getMetabolismModule().isBreedingInCooldown();
    }

    public void onStart() {
        if (this.target == null) {
            this.stop();
        }
        CompletableFuture future = this.animal.getNavigationController().moveTo((Entity)this.target);
        this.animal.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
        if (future != null) {
            future.thenAccept(travelersPath -> {
                if (travelersPath != null) {
                    travelersPath.advance();
                }
            });
        }
    }

    public void tick() {
        if (this.target == null || this.animal.getModules().getMetabolismModule().isGestating() || this.target.getModules().getMetabolismModule().isGestating() || this.target.isDead() || this.target.m_5803_() || this.target.isPanicking()) {
            this.stop();
            return;
        }
        if (JSTaskUtils.isCloseEnough(this.animal, this.target.m_20097_().m_252807_(), 2.0f) && !this.animal.getModules().getGeneticModule().isMale()) {
            this.animal.onMate(this.target);
            this.target.onMate(this.animal);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo((Entity)this.target);
            if (moveTo != null) {
                moveTo.thenAccept(travelersPath -> {
                    if (travelersPath == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        travelersPath.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(20, 25);
        } else if (this.recomputePathTicks > 0) {
            --this.recomputePathTicks;
        }
    }

    public void onStop() {
        this.recomputePathTicks = 10;
    }

    public void findMate() {
        AABB tracking = this.getTargetSearchArea(this.animal.getTrackingRange());
        boolean isMale = this.animal.getModules().getGeneticModule().isMale();
        List entities = this.animal.m_9236_().m_6443_(JSAnimalBase.class, tracking, mob -> mob.getAnimal() == this.animal.getAnimal() && this.animal.m_142582_((Entity)mob) && isMale != mob.getModules().getGeneticModule().isMale() && !mob.m_6162_() && !mob.isDead() && mob.getModules().getMetabolismModule().isBreedingEnabled() && !mob.isPanicking() && !mob.getModules().getMetabolismModule().isGestating() && !mob.getModules().getMetabolismModule().isBreedingInCooldown());
        this.target = (JSAnimalBase)this.animal.m_9236_().m_45982_(entities, TargetingConditions.f_26872_.m_26883_(this.animal.getTrackingRange()), (LivingEntity)this.animal, this.animal.m_20185_(), this.animal.m_20188_(), this.animal.m_20189_());
    }

    protected AABB getTargetSearchArea(double targetDistance) {
        return this.animal.m_20191_().m_82377_(targetDistance, targetDistance, targetDistance);
    }
}

