/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class JSCrawlTask
extends JSTaskBase {
    private boolean isCrawling;

    public JSCrawlTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public boolean shouldRun() {
        TravelersPathNavigation nav = this.animal.getNavigationController();
        if (nav == null || nav.isDone()) {
            return false;
        }
        TravelersPath path = nav.getPath();
        if (path == null) {
            return false;
        }
        int nextIndex = path.getNextNodeIndex();
        if (nextIndex < 0 || nextIndex >= path.getNodeCount()) {
            return false;
        }
        TravelersNode next = path.getNode(nextIndex);
        TravelersNode current = null;
        if (nextIndex > 0) {
            current = path.getNode(nextIndex - 1);
        }
        return next != null && next.type == TravelersPathType.CRAWL || current != null && current.type == TravelersPathType.CRAWL;
    }

    public boolean canContinueRunning() {
        boolean canStand = this.canStandUp();
        if (this.animal.getCrawling() && canStand) {
            return false;
        }
        if (!canStand) {
            this.animal.setCrawling(true);
            return true;
        }
        return super.canContinueRunning();
    }

    private boolean canStandUp() {
        AABB crawlBox = this.animal.m_20191_();
        double height = crawlBox.f_82292_ - crawlBox.f_82289_;
        AABB standBox = new AABB(crawlBox.f_82288_, crawlBox.f_82289_, crawlBox.f_82290_, crawlBox.f_82291_, crawlBox.f_82289_ + height * 2.0, crawlBox.f_82293_);
        return this.animal.m_9236_().m_45756_((Entity)this.animal, standBox);
    }

    public boolean requiresUpdateEveryTick() {
        return this.isCrawling;
    }

    public void onStart() {
        this.isCrawling = true;
        this.animal.setCrawling(true);
    }

    public void tick() {
        this.animal.setCrawling(true);
    }

    public void onStop() {
        this.isCrawling = false;
        this.animal.setCrawling(false);
    }
}

