/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSRoarTask
extends JSTaskBase {
    private int roarLength = 0;
    private final TravelersSoundAnimationDefinition[] defs;
    private TravelersSoundAnimationDefinition roar;
    private int roarTickOffset = 0;
    private int lastIndex = -1;
    private int roarCooldown = 0;
    private boolean hasEnteredShake;
    private boolean scaresNearby;

    public JSRoarTask(JSAnimalBase baseAnimal, TravelersSoundAnimationDefinition ... definitions) {
        super(baseAnimal);
        this.defs = definitions;
    }

    public JSRoarTask scareNearby() {
        this.scaresNearby = true;
        return this;
    }

    public boolean shouldRun() {
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
            return false;
        }
        if (this.animal.isDead() || this.animal.m_20072_() && !this.animal.m_20096_() || this.animal.m_5803_() || this.animal.m_5448_() != null || this.animal.m_5803_() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.getModules().getHerdModule().isFollower()) {
            return this.animal.m_21533_() && this.animal.getNavigationController().isDone();
        }
        return this.animal.getNavigationController().isDone() && this.random.nextDouble() < (double)0.08f;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead() || this.animal.m_5803_() || this.animal.m_20072_() || this.animal.isResting()) {
            return false;
        }
        return this.roarLength != 0;
    }

    public boolean requiresUpdateEveryTick() {
        if (this.animal.isDead() || this.animal.m_5803_()) {
            return false;
        }
        return this.roarLength > 0;
    }

    public void onStart() {
        int index;
        while ((index = this.random.nextInt(this.defs.length)) == this.lastIndex && this.defs.length > 1) {
        }
        this.lastIndex = index;
        TravelersSoundAnimationDefinition soundAnimDef = this.defs[index];
        this.roarTickOffset = soundAnimDef.length() - soundAnimDef.offset();
        this.roarLength = soundAnimDef.length();
        this.roar = soundAnimDef;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.m_5496_(soundAnimDef.event(), 6.0f, 1.0f);
            if (this.scaresNearby) {
                for (JSAnimalBase animalBase : this.animal.m_9236_().m_6443_(JSAnimalBase.class, this.animal.m_20191_().m_82400_(30.0), e -> e.m_20206_() + e.m_20205_() < this.animal.m_20206_() + this.animal.m_20205_())) {
                    animalBase.setFleeTarget((Entity)this.animal);
                }
            }
        }
        this.animal.m_20256_(Vec3.f_82478_);
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setFrozen(true);
        this.animal.f_20883_ = this.animal.m_146908_();
        this.animal.f_20885_ = this.animal.m_146908_();
        this.animal.f_19859_ = this.animal.m_146908_();
        this.animal.f_20884_ = this.animal.f_20883_;
        this.animal.f_20886_ = this.animal.f_20885_;
        this.animal.m_21563_().m_24946_(this.animal.m_20185_(), this.animal.m_20188_(), this.animal.m_20189_());
        this.tick();
    }

    public void tick() {
        --this.roarLength;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.m_9236_().m_5594_(null, this.animal.m_20183_(), this.roar.event(), SoundSource.HOSTILE, 2.0f, 1.0f);
        }
        if (this.animal.canShake() && !this.hasEnteredShake && this.roar.length() - this.roar.secondaryOffset() > this.roarLength) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this.animal, (TravelersBasePacket)new TravelersShakeCamera(false, this.animal.shakeAmount() * 0.7f, this.roarLength, this.animal.shakeDistance() * 0.7f, this.animal.m_20182_().m_252839_()));
            this.hasEnteredShake = true;
        }
        this.animal.freezeAnimator();
        if (this.roar != null && this.roarLength > 0) {
            this.roar.def().sendForEntity((SmartAnimalBase)this.animal);
        }
    }

    public void onStop() {
        this.roarCooldown = 26;
        this.roar = null;
        this.roarLength = 0;
        this.hasEnteredShake = false;
        this.animal.getNavigationController().setFrozen(false);
    }
}

