/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSDefaultRandomPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFleeTask
extends JSTaskBase {
    private final int fleeDistance;
    private int ticksToNextPathCalc;
    protected Entity currentFleeTarget = null;

    public JSFleeTask(JSAnimalBase baseAnimal, int fleeDistance) {
        super(baseAnimal);
        this.fleeDistance = fleeDistance;
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.setPriority(TaskPriority.VERY_HIGH);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.m_5448_() != null) {
            return false;
        }
        if (this.animal.getFleeTarget() == null) {
            Player nearestPlayer;
            AABB bb = this.animal.m_20191_().m_82377_((double)this.fleeDistance, (double)this.fleeDistance / 2.0, (double)this.fleeDistance);
            List list = this.level.m_6443_(PathfinderMob.class, bb, a -> {
                if (!this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().isScaredOf((LivingEntity)a)) {
                    return false;
                }
                if (!this.canTargetSeeMe((LivingEntity)this.animal, (PathfinderMob)a) && !a.m_5912_()) {
                    return false;
                }
                if (a instanceof JSAnimalBase) {
                    JSAnimalBase b = (JSAnimalBase)((Object)a);
                    return !b.isDead() && a.m_6084_() && !a.m_7306_((Entity)this.animal);
                }
                return a.m_6084_() && !a.m_7306_((Entity)this.animal);
            });
            list.stream().min(Comparator.comparingDouble(e -> e.m_20270_((Entity)this.animal))).ifPresent(this.animal::setFleeTarget);
            if (this.animal.getAnimal().getAnimalAttributes().getSocialGroupProperties().getScaredOf().contains(Player.class) && (nearestPlayer = this.level.m_45930_((Entity)this.animal, (double)this.fleeDistance)) != null) {
                this.animal.setFleeTarget((Entity)nearestPlayer);
            }
        }
        return this.animal.getFleeTarget() != null;
    }

    private boolean canTargetSeeMe(LivingEntity target, PathfinderMob entity) {
        double minDot;
        Vec3 toEntity;
        Vec3 entityEyes;
        if (target.m_9236_() != entity.m_9236_()) {
            return false;
        }
        Vec3 targetEyes = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (targetEyes.m_82554_(entityEyes = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_())) > 64.0) {
            return false;
        }
        Vec3 forward = target.m_20154_().m_82541_();
        double dot = forward.m_82526_(toEntity = entityEyes.m_82546_(targetEyes).m_82541_());
        return dot >= (minDot = Math.cos(Math.toRadians(75.0))) && target.m_9236_().m_45547_(new ClipContext(targetEyes, entityEyes, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target)).m_6662_() == HitResult.Type.MISS;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.currentFleeTarget = this.animal.getFleeTarget();
        this.animal.getModules().getMetabolismModule().interrupt(20);
        this.animal.setIsPanicking(true);
    }

    public boolean canContinueRunning() {
        JSAnimalBase base;
        Entity entity;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.currentFleeTarget.m_213877_() || (entity = this.currentFleeTarget) instanceof JSAnimalBase && (base = (JSAnimalBase)entity).isDead()) {
            return false;
        }
        return this.currentFleeTarget != null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.currentFleeTarget == null) {
            this.stop();
            return;
        }
        if (this.animal.m_20270_(this.currentFleeTarget) > this.animal.m_20205_() * (float)this.fleeDistance) {
            this.stop();
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.ticksToNextPathCalc <= 0) {
            double angleVariance;
            this.ticksToNextPathCalc = 20 + this.random.nextInt(20);
            Vec3 awayDir = this.animal.m_20182_().m_82546_(this.currentFleeTarget.m_20182_()).m_82541_();
            double dist = (double)this.fleeDistance * 2.0;
            Vec3 wantedPos = this.animal.m_20182_().m_82549_(awayDir.m_82490_(dist));
            Vec3 pos = JSDefaultRandomPos.getPosTowards(this.animal, this.fleeDistance * 2, this.fleeDistance, wantedPos, angleVariance = Math.toRadians(30.0));
            if (pos == null) {
                pos = JSDefaultRandomPos.getPosAway(this.animal, this.fleeDistance * 2, this.fleeDistance, this.currentFleeTarget.m_20182_());
            }
            if (pos == null) {
                this.ticksToNextPathCalc = 0;
                return;
            }
            CompletableFuture path = this.animal.getNavigationController().moveTo(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (path != null) {
                path.thenAccept(jsPath -> {
                    if (jsPath == null) {
                        this.ticksToNextPathCalc += 15;
                    } else {
                        jsPath.advance();
                    }
                });
            } else {
                this.ticksToNextPathCalc += 15;
            }
        }
        if (this.ticksToNextPathCalc > 0) {
            --this.ticksToNextPathCalc;
        }
    }

    public void onStop() {
        this.currentFleeTarget = null;
        this.animal.setFleeTarget(null);
        this.animal.setIsPanicking(false);
    }
}

