/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSAirAndWaterRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, maxDistance);
        return JSRandomPos.generateBestRandomPos(() -> JSAirAndWaterRandomPos.generateRandomPos(mob, maxDistance, yRange, maxDistanceOfGround, restricted), arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    private static BlockPos generateRandomPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround, boolean restricted) {
        RandomSource rng = mob.m_217043_();
        BlockPos base = mob.m_20183_();
        int dx = rng.m_188503_(maxDistance * 2 + 1) - maxDistance;
        int dy = rng.m_188503_(yRange * 2 + 1) - yRange;
        int dz = rng.m_188503_(maxDistance * 2 + 1) - maxDistance;
        int x = base.m_123341_() + dx;
        int y = base.m_123342_() + dy;
        int z = base.m_123343_() + dz;
        if (maxDistanceOfGround != -1) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(x, base.m_123342_(), z);
            while (cursor.m_123342_() > mob.m_9236_().m_141937_() && mob.m_9236_().m_46859_((BlockPos)cursor)) {
                cursor.m_122173_(Direction.DOWN);
            }
            int groundY = cursor.m_123342_();
            int minY = groundY + 1;
            int maxY = groundY + maxDistanceOfGround;
            y = Mth.m_14045_((int)y, (int)minY, (int)maxY);
        } else {
            y = Mth.m_14045_((int)y, (int)(mob.m_9236_().m_141937_() + 1), (int)(mob.m_9236_().m_151558_() - 1));
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (JSGoalUtils.isOutsideLimits(pos, mob)) {
            return null;
        }
        if (JSGoalUtils.isRestricted(restricted, mob, pos)) {
            return null;
        }
        if (JSGoalUtils.hasMalus(mob, pos)) {
            return null;
        }
        return pos;
    }
}

