/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSDefaultRandomPos {
    private static final Random rng = new Random();

    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int verticalDistance) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSDefaultRandomPos.generateUnbiasedDirection(radius, verticalDistance);
            return JSDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset);
        }, arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    public static Vec3 getPosTowards(SmartAnimalBase mob, int radius, int yRange, Vec3 target, double angleVarianceRadians) {
        Vec3 direction = target.m_82546_(mob.m_20182_());
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.f_82479_, direction.f_82481_, angleVarianceRadians);
            return offset != null ? JSDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    public static Vec3 getPosAway(SmartAnimalBase mob, int radius, int yRange, Vec3 dangerSource) {
        Vec3 awayDir = mob.m_20182_().m_82546_(dangerSource).m_82541_();
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, awayDir.f_82479_, awayDir.f_82481_, 1.5707963267948966);
            return offset != null ? JSDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    private static BlockPos generateUnbiasedDirection(int radius, int verticalRange) {
        int dx = rng.nextInt(radius * 2 + 1) - radius;
        int dy = rng.nextInt(verticalRange * 2 + 1) - verticalRange;
        int dz = rng.nextInt(radius * 2 + 1) - radius;
        return new BlockPos(dx, dy, dz);
    }

    @Nullable
    private static BlockPos generateValidTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = mob.m_20183_().m_121955_((Vec3i)offset);
        if (JSGoalUtils.isSolid(mob, candidate) && JSGoalUtils.isSolid(mob, candidate = candidate.m_7494_())) {
            return null;
        }
        return !JSGoalUtils.isOutsideLimits(candidate, mob) && !JSGoalUtils.isRestricted(restricted, mob, candidate) && !JSGoalUtils.isNotStable(mob.getNavigationController(), candidate) && !JSGoalUtils.hasMalus(mob, candidate) ? candidate : null;
    }
}

