/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.function.ToDoubleFunction;
import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSLandRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int verticalRange) {
        return JSLandRandomPos.getPos(mob, radius, verticalRange, arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int yRange, ToDoubleFunction<BlockPos> scorer) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSRandomPos.generateRandomDirection(radius, yRange);
            BlockPos candidate = JSLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? JSLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, scorer);
    }

    @Nullable
    public static Vec3 getPosTowards(SmartAnimalBase mob, int radius, int yRange, Vec3 target) {
        Vec3 direction = target.m_82546_(mob.m_20182_());
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    public static Vec3 getPosAway(SmartAnimalBase mob, int radius, int yRange, Vec3 dangerSource) {
        Vec3 direction = mob.m_20182_().m_82546_(dangerSource);
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    private static Vec3 getPosInDirection(SmartAnimalBase mob, int radius, int yRange, Vec3 direction, boolean restricted) {
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.f_82479_, direction.f_82481_, 1.5707963267948966);
            if (offset == null) {
                return null;
            }
            BlockPos candidate = JSLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? JSLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    private static BlockPos movePosUpOutOfSolid(SmartAnimalBase mob, BlockPos pos) {
        BlockPos corrected = JSRandomPos.searchUpDown(pos, 4, p -> !JSGoalUtils.isSolid(mob, p));
        if (corrected == null) {
            return null;
        }
        return !JSGoalUtils.isWater(mob, corrected) && !JSGoalUtils.hasMalus(mob, corrected) ? corrected : null;
    }

    @Nullable
    private static BlockPos generateValidRandomTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = JSRandomPos.generateRandomPosTowardDirection((PathfinderMob)mob, radius, offset);
        return candidate != null && !JSGoalUtils.isOutsideLimits(candidate, mob) && !JSGoalUtils.isRestricted(restricted, mob, candidate) && !JSGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }
}

