/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSCrabNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.util.JSAirAndWaterRandomPos;
import jp.jurassicsaga.server.base.animal.entity.util.JSDefaultRandomPos;
import jp.jurassicsaga.server.base.animal.entity.util.JSLandRandomPos;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSTaskUtils {
    private static final Random rng = new Random();

    public static Vec3 findTargetPos(JSAnimalBase animal, int xRange, int yRange, int heightVariation) {
        boolean isAmphibious;
        boolean isFlyingAnimal = animal.getNavigationController() instanceof JSFlyingNavigation;
        boolean isAquaticAnimal = animal.getNavigationController() instanceof JSAquaticNavigation || animal instanceof JSAquaticBase;
        boolean bl = isAmphibious = animal.getNavigationController() instanceof JSAmphibiousNavigation || animal.getNavigationController() instanceof JSCrabNavigation;
        if (isAmphibious && !isAquaticAnimal) {
            isAquaticAnimal = rng.nextBoolean();
        }
        if (isFlyingAnimal && animal instanceof JSAvianBase) {
            JSAvianBase flying = (JSAvianBase)animal;
            boolean bl2 = isFlyingAnimal = flying.isFlying() && !flying.wantsToLand();
        }
        if (!isFlyingAnimal && !isAquaticAnimal) {
            if (animal.m_20072_()) {
                Vec3 vec3 = JSLandRandomPos.getPos(animal, xRange, yRange);
                return vec3 == null ? JSDefaultRandomPos.getPos(animal, xRange, yRange) : vec3;
            }
            if (animal.avoidsLight()) {
                int attempts = 10;
                while (attempts != 0) {
                    Vec3 pos;
                    Vec3 vec3 = pos = (double)rng.nextFloat() >= 0.6 ? JSLandRandomPos.getPos(animal, xRange * 2, yRange) : JSDefaultRandomPos.getPos(animal, xRange, yRange);
                    if (pos != null) {
                        int blockLight;
                        Level level = animal.m_9236_();
                        boolean isDay = level.m_46468_() % 24000L < 12000L;
                        BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
                        if (!level.m_8055_(blockPos).m_60795_() && !level.m_8055_(blockPos = blockPos.m_7494_()).m_60795_()) continue;
                        int skyLight = isDay ? level.m_45517_(LightLayer.SKY, blockPos) : 0;
                        int totalLight = Math.min(15, skyLight + (blockLight = level.m_45517_(LightLayer.BLOCK, blockPos)));
                        if (totalLight < 14) {
                            return pos;
                        }
                    }
                    --attempts;
                }
            }
            return (double)rng.nextFloat() >= 0.5 ? JSLandRandomPos.getPos(animal, xRange * 2, yRange) : JSDefaultRandomPos.getPos(animal, xRange, yRange);
        }
        if (isFlyingAnimal) {
            int maxDistance = -1;
            if (animal instanceof JSAvianBase) {
                JSAvianBase avianBase = (JSAvianBase)animal;
                maxDistance = avianBase.getDistanceOfGround();
            }
            return JSAirAndWaterRandomPos.getPos(animal, xRange, yRange, maxDistance);
        }
        Vec3 target = null;
        Vec3 baseTarget = JSTaskUtils.getRandomSwimmablePos(animal, xRange, yRange);
        if (baseTarget != null) {
            double baseY = baseTarget.f_82480_ - 1.0 - (double)rng.nextInt(heightVariation);
            double newY = Math.max((double)animal.m_9236_().m_141937_(), baseY);
            BlockPos checkPos = new BlockPos((int)baseTarget.f_82479_, (int)newY, (int)baseTarget.f_82481_);
            if (animal.m_9236_().m_6425_(checkPos).m_205070_(FluidTags.f_13131_)) {
                target = new Vec3(baseTarget.f_82479_, newY, baseTarget.f_82481_);
            }
        }
        return target;
    }

    private static Vec3 getRandomSwimmablePos(SmartAnimalBase pathfinder, int radius, int verticalDistance) {
        Vec3 vec3 = JSDefaultRandomPos.getPos(pathfinder, radius, verticalDistance);
        int i = 0;
        while (vec3 != null && !pathfinder.m_9236_().m_6425_(new BlockPos((int)vec3.f_82479_, (int)vec3.f_82480_, (int)vec3.f_82481_)).m_205070_(FluidTags.f_13131_) && i++ < 10) {
            vec3 = JSDefaultRandomPos.getPos(pathfinder, radius, verticalDistance);
        }
        return vec3;
    }

    public static boolean hasGroundPathNavigation(SmartAnimalBase mob) {
        return mob.getNavigationController() instanceof JSGroundNavigation;
    }

    public static boolean isCloseEnough(JSAnimalBase animal, Vec3 target, float mul) {
        return JSUtils.isWithinDistanceSqr(target, animal.m_20182_(), (double)(Math.max(0.5f, animal.m_20205_()) * mul));
    }
}

