/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.DroppableItem;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalRemains;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.HatchedEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.util.JSHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.misc.DropObject;
import travelers.util.helper.PlatformHelper;

public class JSTravelersItems<T extends JSAnimalBase>
implements TravelersItemInterface<T> {
    private final HashMap<DroppableItem, Supplier<Item>> custom_items = new HashMap();
    private String modID = "jurassicsaga";
    private Supplier<Item> spawnEgg;
    private JSTravelersAttributes<T> attributes;
    private HashMap<ItemLike, DropObject> drops = new HashMap();
    private Supplier<Item> rawMeat;
    private Supplier<Item> cookedMeat;
    private Supplier<Item> coin;
    private Supplier<Item> fossil_remains;
    private Supplier<Item> hatched_egg;
    private Supplier<Item> bucket;

    public void init(TravelersAnimalAttributes<T> attribz, TravelersAnimal<T> travelersAnimal) {
        this.attributes = (JSTravelersAttributes)attribz;
        JSAnimal animal = (JSAnimal)travelersAnimal;
        String name = this.attributes.getAnimalName().toLowerCase();
        this.modID = attribz.getModId();
        if (animal.getAnimalAttributes().getItemProperties().isHasMeat()) {
            this.rawMeat = this.registerItem(name + "_raw", (Supplier<Item>)((Supplier)() -> new AnimalItem(animal, true, new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38762_(new MobEffectInstance(MobEffects.f_19612_, 600, 0), 0.3f).m_38767_()))));
            this.cookedMeat = this.registerItem(name + "_cooked", (Supplier<Item>)((Supplier)() -> new AnimalItem(animal, false, new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38767_()))));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getAnimalAttributes().getItemProperties().isHasCoin()) {
            this.coin = this.registerItem(name + "_coin", (Supplier<Item>)((Supplier)() -> new DnaItem(animal, new Item.Properties())));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct() && animal.getAnimalAttributes().getItemProperties().isHasFossil()) {
            this.fossil_remains = this.registerItem(name + "_fossil_remains", (Supplier<Item>)((Supplier)() -> new AnimalRemains(animal, new Item.Properties(), animal.getAnimalAttributes().getMiscProperties().getEra(), PossibleResult.REMAINS)));
        }
        for (DroppableItem additionalItem : this.attributes.getItemProperties().getAdditionalItems()) {
            this.custom_items.put(additionalItem, this.registerItem(name + "_" + additionalItem.name(), (Supplier<Item>)((Supplier)() -> new Item(new Item.Properties()))));
        }
        this.drops = animal.getItems().initDrops(this, this.drops);
    }

    public void initSpawnEgg(TravelersAnimalAttributes<?> attribz, TravelersAnimal<?> travelersAnimal) {
        JSAnimal animal = (JSAnimal)travelersAnimal;
        if (this.attributes.getItemProperties().isHasDrops()) {
            if (this.attributes.getItemProperties().isBucketable()) {
                this.bucket = this.registerItem(this.attributes.getAnimalName().toLowerCase() + "_bucket", (Supplier<Item>)((Supplier)() -> new MobBucketItem((EntityType)animal.getEntityType().get(), (Fluid)Fluids.f_76193_, SoundEvents.f_11779_, new Item.Properties().m_41487_(1))));
            }
            this.spawnEgg = this.attributes.getItemProperties().getSpawnEggColoursMale() != null ? this.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<Item>)((Supplier)() -> new GenderSpawnEgg(animal, () -> (EntityType)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], this.attributes.getItemProperties().getSpawnEggColoursMale()[0], this.attributes.getItemProperties().getSpawnEggColoursMale()[1], new Item.Properties()))) : this.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<Item>)((Supplier)() -> new BasicSpawnEgg(animal, () -> (EntityType)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], new Item.Properties())));
            if (this.attributes.getItemProperties().isHasEgg()) {
                this.hatched_egg = this.registerItem(this.attributes.getAnimalName().toLowerCase() + "_hatch_egg", (Supplier<Item>)((Supplier)() -> new HatchedEgg(this.attributes.getGeneticProperties().getDefaultGenetics())));
            }
        }
        JSHelper.jsPlatform.registerDataFor(this);
    }

    public HashMap<ItemLike, DropObject> initDrops(TravelersItemInterface<T> travelersItemInterface, HashMap<ItemLike, DropObject> hashMap) {
        return new HashMap<ItemLike, DropObject>();
    }

    @Nullable
    public ItemStack getPickItem(SmartAnimalBase smartAnimalBase) {
        return ((Item)this.spawnEgg.get()).m_7968_();
    }

    public ItemStack getBucketItem() {
        return this.bucket != null ? ((Item)this.bucket.get()).m_7968_() : ItemStack.f_41583_;
    }

    public Set<java.util.function.Supplier<Item>> spawnEggs() {
        return super.spawnEggs();
    }

    private Supplier<Item> registerItem(String name, Supplier<Item> o) {
        return PlatformHelper.register((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)new ResourceLocation(this.modID, name), o);
    }

    public HashMap<DroppableItem, Supplier<Item>> getCustom_items() {
        return this.custom_items;
    }

    public String getModID() {
        return this.modID;
    }

    public Supplier<Item> getSpawnEgg() {
        return this.spawnEgg;
    }

    public JSTravelersAttributes<T> getAttributes() {
        return this.attributes;
    }

    public HashMap<ItemLike, DropObject> getDrops() {
        return this.drops;
    }

    public Supplier<Item> getRawMeat() {
        return this.rawMeat;
    }

    public Supplier<Item> getCookedMeat() {
        return this.cookedMeat;
    }

    public Supplier<Item> getCoin() {
        return this.coin;
    }

    public Supplier<Item> getFossil_remains() {
        return this.fossil_remains;
    }

    public Supplier<Item> getHatched_egg() {
        return this.hatched_egg;
    }

    public Supplier<Item> getBucket() {
        return this.bucket;
    }
}

