/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.HashSet;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSBiomeTarget;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.Era;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec2;
import oshi.util.tuples.Pair;
import travelers.server.world.obj.BiomeHolder;

public class JSMiscProperties<T extends JSAnimalBase> {
    private final Set<JSBiomeTarget> spawnTargets = new HashSet<JSBiomeTarget>();
    private SpawnPlacements.Type spawnPlacementType = SpawnPlacements.Type.ON_GROUND;
    private Heightmap.Types spawnHeightMap = Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
    private SpawnPlacements.SpawnPredicate<T> spawnPredicate = null;
    private final Vec2[] guidebookOffset = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 0.0f)};
    private float[] guidebookScaling = new float[]{1.0f, 1.0f};
    private String guideBookDescription = "ERROR. Description not found.";
    private String guideBookSource = "ERROR. Source not found.";
    private String guideBookScientificName = "ERROR. Name not found.";
    private String advancementTitle = "ERROR. No advancement found.";
    private float maxHeadYRot = 35.0f;
    private float maxHeadXRot = 20.0f;
    private float machineScale = 1.0f;
    private Versions.Version version = Versions.VERSION_1;
    private int corpseDropTimes = 2;
    private boolean shouldCorpseDropItems = true;
    private boolean hasGuideBookPose = false;
    private boolean hasBabyGuidebook = true;
    private boolean canBeLeashed = false;
    private boolean babyAnimations = false;
    private boolean genderedVariants = false;
    private boolean isMammal = false;
    private boolean isExtinct = false;
    private boolean requiresGlow = false;
    private boolean showInGuidebook = false;
    private boolean attacksCar = false;
    private Pair<Integer, Integer> corpseMeatDropRange = new Pair((Object)1, (Object)4);
    private Pair<Integer, Integer> corpseBoneDropRange = new Pair((Object)1, (Object)4);
    private Era era;

    public JSMiscProperties<T> disableCorpseDrops() {
        this.shouldCorpseDropItems = false;
        return this;
    }

    public JSMiscProperties<T> addBiomeTarget(String name, int weight, int minGroup, int maxGroup, MobCategory mobCategory, TagKey<Biome> biomeTagKey) {
        this.spawnTargets.add(new JSBiomeTarget(new BiomeHolder(biomeTagKey), name, weight, minGroup, maxGroup, mobCategory));
        return this;
    }

    @SafeVarargs
    public final JSMiscProperties<T> addBiomeTarget(String name, int weight, int minGroup, int maxGroup, MobCategory mobCategory, ResourceKey<Biome> ... biomes) {
        this.spawnTargets.add(new JSBiomeTarget(new BiomeHolder(biomes), name, weight, maxGroup, minGroup, mobCategory));
        return this;
    }

    public JSMiscProperties<T> setCorpseMeatDrops(int min, int max) {
        min = Math.max(0, min);
        max = Math.max(min, max);
        this.corpseMeatDropRange = new Pair((Object)min, (Object)max);
        return this;
    }

    public JSMiscProperties<T> setCorpseBoneDrops(int min, int max) {
        min = Math.max(0, min);
        max = Math.max(min, max);
        this.corpseBoneDropRange = new Pair((Object)min, (Object)max);
        return this;
    }

    public JSMiscProperties<T> hideInGuidebook() {
        this.showInGuidebook = false;
        return this;
    }

    public JSMiscProperties<T> enableGuidebookPose() {
        this.hasGuideBookPose = true;
        return this;
    }

    public JSMiscProperties<T> disableBabyGuidebook() {
        this.hasBabyGuidebook = false;
        return this;
    }

    public JSMiscProperties<T> enableLeashing() {
        this.canBeLeashed = true;
        return this;
    }

    public JSMiscProperties<T> setGuidebookOffset(Vec2 offsetBaby, Vec2 offsetAdult) {
        this.guidebookOffset[0] = offsetBaby;
        this.guidebookOffset[1] = offsetAdult;
        return this;
    }

    public JSMiscProperties<T> setMaxHeadRotation(float maxHeadXRot, float maxHeadYRot) {
        this.maxHeadXRot = maxHeadXRot;
        this.maxHeadYRot = maxHeadYRot;
        return this;
    }

    public JSMiscProperties<T> setBabyAnimations() {
        this.babyAnimations = true;
        return this;
    }

    public JSMiscProperties<T> setGenderedVariants() {
        this.genderedVariants = true;
        return this;
    }

    public JSMiscProperties<T> setMammal() {
        this.isMammal = true;
        return this;
    }

    public JSMiscProperties<T> setRequiresGlow() {
        this.requiresGlow = true;
        return this;
    }

    public JSMiscProperties<T> setExtinct() {
        this.isExtinct = true;
        this.showInGuidebook = true;
        return this;
    }

    public Set<JSBiomeTarget> getSpawnTargets() {
        return this.spawnTargets;
    }

    public SpawnPlacements.Type getSpawnPlacementType() {
        return this.spawnPlacementType;
    }

    public Heightmap.Types getSpawnHeightMap() {
        return this.spawnHeightMap;
    }

    public SpawnPlacements.SpawnPredicate<T> getSpawnPredicate() {
        return this.spawnPredicate;
    }

    public Vec2[] getGuidebookOffset() {
        return this.guidebookOffset;
    }

    public float[] getGuidebookScaling() {
        return this.guidebookScaling;
    }

    public String getGuideBookDescription() {
        return this.guideBookDescription;
    }

    public String getGuideBookSource() {
        return this.guideBookSource;
    }

    public String getGuideBookScientificName() {
        return this.guideBookScientificName;
    }

    public String getAdvancementTitle() {
        return this.advancementTitle;
    }

    public float getMaxHeadYRot() {
        return this.maxHeadYRot;
    }

    public float getMaxHeadXRot() {
        return this.maxHeadXRot;
    }

    public float getMachineScale() {
        return this.machineScale;
    }

    public Versions.Version getVersion() {
        return this.version;
    }

    public int getCorpseDropTimes() {
        return this.corpseDropTimes;
    }

    public boolean isShouldCorpseDropItems() {
        return this.shouldCorpseDropItems;
    }

    public boolean isHasGuideBookPose() {
        return this.hasGuideBookPose;
    }

    public boolean isHasBabyGuidebook() {
        return this.hasBabyGuidebook;
    }

    public boolean isCanBeLeashed() {
        return this.canBeLeashed;
    }

    public boolean isBabyAnimations() {
        return this.babyAnimations;
    }

    public boolean isGenderedVariants() {
        return this.genderedVariants;
    }

    public boolean isMammal() {
        return this.isMammal;
    }

    public boolean isExtinct() {
        return this.isExtinct;
    }

    public boolean isRequiresGlow() {
        return this.requiresGlow;
    }

    public boolean isShowInGuidebook() {
        return this.showInGuidebook;
    }

    public boolean isAttacksCar() {
        return this.attacksCar;
    }

    public Pair<Integer, Integer> getCorpseMeatDropRange() {
        return this.corpseMeatDropRange;
    }

    public Pair<Integer, Integer> getCorpseBoneDropRange() {
        return this.corpseBoneDropRange;
    }

    public Era getEra() {
        return this.era;
    }

    public JSMiscProperties<T> setSpawnPlacementType(SpawnPlacements.Type spawnPlacementType) {
        this.spawnPlacementType = spawnPlacementType;
        return this;
    }

    public JSMiscProperties<T> setSpawnHeightMap(Heightmap.Types spawnHeightMap) {
        this.spawnHeightMap = spawnHeightMap;
        return this;
    }

    public JSMiscProperties<T> setSpawnPredicate(SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        this.spawnPredicate = spawnPredicate;
        return this;
    }

    public JSMiscProperties<T> setGuidebookScaling(float[] guidebookScaling) {
        this.guidebookScaling = guidebookScaling;
        return this;
    }

    public JSMiscProperties<T> setGuideBookDescription(String guideBookDescription) {
        this.guideBookDescription = guideBookDescription;
        return this;
    }

    public JSMiscProperties<T> setGuideBookSource(String guideBookSource) {
        this.guideBookSource = guideBookSource;
        return this;
    }

    public JSMiscProperties<T> setGuideBookScientificName(String guideBookScientificName) {
        this.guideBookScientificName = guideBookScientificName;
        return this;
    }

    public JSMiscProperties<T> setAdvancementTitle(String advancementTitle) {
        this.advancementTitle = advancementTitle;
        return this;
    }

    public JSMiscProperties<T> setMaxHeadYRot(float maxHeadYRot) {
        this.maxHeadYRot = maxHeadYRot;
        return this;
    }

    public JSMiscProperties<T> setMaxHeadXRot(float maxHeadXRot) {
        this.maxHeadXRot = maxHeadXRot;
        return this;
    }

    public JSMiscProperties<T> setMachineScale(float machineScale) {
        this.machineScale = machineScale;
        return this;
    }

    public JSMiscProperties<T> setVersion(Versions.Version version) {
        this.version = version;
        return this;
    }

    public JSMiscProperties<T> setCorpseDropTimes(int corpseDropTimes) {
        this.corpseDropTimes = corpseDropTimes;
        return this;
    }

    public JSMiscProperties<T> setShouldCorpseDropItems(boolean shouldCorpseDropItems) {
        this.shouldCorpseDropItems = shouldCorpseDropItems;
        return this;
    }

    public JSMiscProperties<T> setHasGuideBookPose(boolean hasGuideBookPose) {
        this.hasGuideBookPose = hasGuideBookPose;
        return this;
    }

    public JSMiscProperties<T> setHasBabyGuidebook(boolean hasBabyGuidebook) {
        this.hasBabyGuidebook = hasBabyGuidebook;
        return this;
    }

    public JSMiscProperties<T> setCanBeLeashed(boolean canBeLeashed) {
        this.canBeLeashed = canBeLeashed;
        return this;
    }

    public JSMiscProperties<T> setBabyAnimations(boolean babyAnimations) {
        this.babyAnimations = babyAnimations;
        return this;
    }

    public JSMiscProperties<T> setGenderedVariants(boolean genderedVariants) {
        this.genderedVariants = genderedVariants;
        return this;
    }

    public JSMiscProperties<T> setMammal(boolean isMammal) {
        this.isMammal = isMammal;
        return this;
    }

    public JSMiscProperties<T> setExtinct(boolean isExtinct) {
        this.isExtinct = isExtinct;
        return this;
    }

    public JSMiscProperties<T> setRequiresGlow(boolean requiresGlow) {
        this.requiresGlow = requiresGlow;
        return this;
    }

    public JSMiscProperties<T> setShowInGuidebook(boolean showInGuidebook) {
        this.showInGuidebook = showInGuidebook;
        return this;
    }

    public JSMiscProperties<T> setAttacksCar(boolean attacksCar) {
        this.attacksCar = attacksCar;
        return this;
    }

    public JSMiscProperties<T> setCorpseMeatDropRange(Pair<Integer, Integer> corpseMeatDropRange) {
        this.corpseMeatDropRange = corpseMeatDropRange;
        return this;
    }

    public JSMiscProperties<T> setCorpseBoneDropRange(Pair<Integer, Integer> corpseBoneDropRange) {
        this.corpseBoneDropRange = corpseBoneDropRange;
        return this;
    }

    public JSMiscProperties<T> setEra(Era era) {
        this.era = era;
        return this;
    }
}

