/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class JSSocialGroupProperties<T extends JSAnimalBase> {
    private final Set<Class<? extends Entity>> huntTargets = new HashSet<Class<? extends Entity>>();
    private final Set<Class<? extends LivingEntity>> herdCompatible = new HashSet<Class<? extends LivingEntity>>();
    private final Set<Class<? extends LivingEntity>> scaredOf = new HashSet<Class<? extends LivingEntity>>();
    private int maxHerdSize = 1;
    private float maxDistanceToPackLeader = 500.0f;
    private float minDistanceToPackLeader = 100.0f;
    private float naturalAggression = 0.0f;
    private boolean usesNest = false;

    public JSSocialGroupProperties<T> enableNesting() {
        this.usesNest = true;
        return this;
    }

    public final JSSocialGroupProperties<T> setNaturalAggression(float aggression) {
        this.naturalAggression = Mth.m_14036_((float)aggression, (float)0.0f, (float)5.0f);
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addHuntTargets(Class<? extends Entity> ... clazz) {
        this.huntTargets.addAll(List.of(clazz));
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addHerdTargets(Class<? extends LivingEntity> ... clazz) {
        this.herdCompatible.addAll(List.of(clazz));
        return this;
    }

    public final JSSocialGroupProperties<T> addHerdTargets(List<Class<? extends LivingEntity>> clazz) {
        this.herdCompatible.addAll(clazz);
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addScaredOf(Class<? extends LivingEntity> ... clazz) {
        this.scaredOf.addAll(List.of(clazz));
        return this;
    }

    public final JSSocialGroupProperties<T> setMaxHerdSize(int maxHerdSize) {
        this.maxHerdSize = Math.max(0, maxHerdSize);
        return this;
    }

    public boolean isScaredOf(LivingEntity livingEntity) {
        for (Class<? extends LivingEntity> aClass1 : this.scaredOf) {
            if (!aClass1.isInstance(livingEntity) && aClass1 != livingEntity.getClass()) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends Entity>> getHuntTargets() {
        return this.huntTargets;
    }

    public Set<Class<? extends LivingEntity>> getHerdCompatible() {
        return this.herdCompatible;
    }

    public Set<Class<? extends LivingEntity>> getScaredOf() {
        return this.scaredOf;
    }

    public int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public float getMaxDistanceToPackLeader() {
        return this.maxDistanceToPackLeader;
    }

    public float getMinDistanceToPackLeader() {
        return this.minDistanceToPackLeader;
    }

    public float getNaturalAggression() {
        return this.naturalAggression;
    }

    public boolean isUsesNest() {
        return this.usesNest;
    }

    public JSSocialGroupProperties<T> setMaxDistanceToPackLeader(float maxDistanceToPackLeader) {
        this.maxDistanceToPackLeader = maxDistanceToPackLeader;
        return this;
    }

    public JSSocialGroupProperties<T> setMinDistanceToPackLeader(float minDistanceToPackLeader) {
        this.minDistanceToPackLeader = minDistanceToPackLeader;
        return this;
    }

    public JSSocialGroupProperties<T> setUsesNest(boolean usesNest) {
        this.usesNest = usesNest;
        return this;
    }
}

