/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSAnimalBaseLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    private final boolean hasGenders;
    private boolean adultOnly;
    protected Cache<String, ResourceLocation> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

    public JSAnimalBaseLocator() {
        this(true);
    }

    public JSAnimalBaseLocator(boolean gendered) {
        this.hasGenders = gendered;
    }

    public JSAnimalBaseLocator<T> setAdultOnly() {
        this.adultOnly = true;
        return this;
    }

    public ResourceLocation getTextureLocation(T entity) {
        Object key = this.makeCacheKey(entity, "texture");
        if (entity.m_8077_()) {
            key = (String)key + "|name=" + entity.m_7770_().getString().toLowerCase(Locale.ROOT);
        }
        try {
            return (ResourceLocation)this.cache.get(key, () -> this.buildTextureLocation(entity));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceLocation getLuxLocation(T entity) {
        String key = this.makeCacheKey(entity, "lux");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String growthStage = this.getGrowthStage(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_lux.png");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceLocation getModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "model");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String growthStage = this.getGrowthStage(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".geo.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceLocation getDefaultModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "default_model");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_adult.geo.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String key = this.makeCacheKey(entity, "anim");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                boolean baby = !this.adultOnly && entity.getAnimal().getAnimalAttributes().getMiscProperties().isBabyAnimations() && entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
                return JSCommon.createId("animations/animal/" + version + "/" + name + "/" + name + (baby ? "_baby.animation.json" : ".animation.json"));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected ResourceLocation buildTextureLocation(T entity) {
        String name = this.getEntityName(entity);
        String growthStage = this.getGrowthStage(entity);
        String version = this.getVersion(entity);
        if (((JSEntityDataHolder)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT && !this.adultOnly) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
        }
        if (this.adultOnly) {
            growthStage = "adult";
        }
        JSVariants.JSVariant variant = JSVariants.fromLocation((String)entity.m_20088_().m_135370_(JSEntityDataHolder.textureVariant));
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            if (!this.hasGenders) {
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
            }
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_" + suffix + ".png");
        }
        ResourceLocation variantLoc = variant.location();
        String path = variantLoc.m_135815_();
        boolean genderedVariants = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isGenderedVariants();
        if (variant.ignoresGenders()) {
            return new ResourceLocation(variantLoc.m_135827_(), "textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png");
        }
        if (genderedVariants) {
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "_male" : "_female";
            return new ResourceLocation(variantLoc.m_135827_(), "textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + suffix + ".png");
        }
        return new ResourceLocation(variantLoc.m_135827_(), "textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png");
    }

    protected String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    private String getGrowthStage(T entity) {
        if (this.adultOnly) {
            return "adult";
        }
        return ((JSEntityDataHolder)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion().versionId();
        return "v" + version;
    }

    protected String makeCacheKey(T entity, String type) {
        TravelersAnimalAttributes animal = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes();
        JSModuleHolder modules = ((JSEntityDataHolder)((Object)entity)).getModules();
        String growth = modules.getGrowthStageModule().getGrowthStage().name();
        boolean male = modules.getGeneticModule().isMale();
        String variant = (String)entity.m_20088_().m_135370_(JSEntityDataHolder.textureVariant);
        return type + ":" + animal.getAnimalName() + ":" + growth + ":" + (male ? "1" : "0") + ":" + variant;
    }
}

