/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSVariantLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    protected Cache<String, ResourceLocation> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

    public ResourceLocation getTextureLocation(T entity) {
        String key = this.makeKey(entity, "texture");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> this.buildTexture(entity));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ResourceLocation buildTexture(T entity) {
        String name = this.getEntityName(entity);
        String version = this.getVersion(entity);
        String gender = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
        JSVariants.JSVariant variant = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().getGeneData().getVariant();
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + gender + ".png");
        }
        String basePath = "textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_" + variant.getName();
        if (variant.ignoresGenders()) {
            return JSCommon.createId(basePath + ".png");
        }
        return JSCommon.createId(basePath + "_" + gender + ".png");
    }

    public ResourceLocation getModelLocation(T entity) {
        String key = this.makeKey(entity, "model");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + ".geo.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String key = this.makeKey(entity, "anim");
        try {
            return (ResourceLocation)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("animations/animal/" + version + "/" + name + "/" + name + ".animation.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion().versionId();
        return "v" + (version % 1.0f == 0.0f ? (float)((int)version) : version);
    }

    private String makeKey(T entity, String type) {
        JSVariants.JSVariant variant = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().getGeneData().getVariant();
        boolean male = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale();
        return type + ":" + this.getEntityName(entity) + ":" + this.getVersion(entity) + ":" + variant.getName() + ":" + male;
    }
}

