/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.entity.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.base.menu.obj.NestMenu;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SmallNestBlockEntity
extends GenericMachineEntity {
    private final int maxProgress = 60000;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int progress5 = 0;
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 1 -> SmallNestBlockEntity.this.progress1;
                case 2 -> SmallNestBlockEntity.this.progress2;
                case 3 -> SmallNestBlockEntity.this.progress3;
                case 4 -> SmallNestBlockEntity.this.progress4;
                case 5 -> SmallNestBlockEntity.this.progress5;
                default -> 60000;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 1: {
                    SmallNestBlockEntity.this.progress1 = value;
                    break;
                }
                case 2: {
                    SmallNestBlockEntity.this.progress2 = value;
                    break;
                }
                case 3: {
                    SmallNestBlockEntity.this.progress3 = value;
                    break;
                }
                case 4: {
                    SmallNestBlockEntity.this.progress4 = value;
                    break;
                }
                case 5: {
                    SmallNestBlockEntity.this.progress5 = value;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public SmallNestBlockEntity(BlockPos pos, BlockState state) {
        super(5, null, (BlockEntityType)JSBlockEntities.SMALL_NEST.get(), pos, state);
    }

    private void tickItem(int slot, Level lvl, SmallNestBlockEntity be) {
        ItemStack slot1 = (ItemStack)be.items.get(slot);
        if (lvl.f_46443_) {
            return;
        }
        Item item = slot1.m_41720_();
        if (item instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)item;
            int speed = Math.max(1, this.f_58857_.m_46469_().m_46215_(JSCommon.MACHINE_SPEED) / 2);
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                case 3 -> be.progress4;
                case 4 -> be.progress5;
                default -> 0;
            };
            CompoundTag tag = slot1.m_41784_();
            CompoundTag animal = tag.m_128469_("jsGeneData");
            if (animal.m_128456_()) {
                return;
            }
            JSGeneData geneData = JSGeneUtil.fromCompound(animal);
            ResourceLocation name = ResourceLocation.m_135822_((String)geneData.getDataOwnerName(), (char)':');
            JSAnimal<?> animal1 = JSAnimals.getAnimal(name.m_135815_());
            if (animal1 == null || animal1.getItems().getHatched_egg() == null) {
                return;
            }
            if ((progressCur += speed) >= 60000) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                int failChance = 0;
                int roll = this.f_58857_.m_213780_().m_216339_(0, 100);
                if (roll < failChance) {
                    be.items.set(slot, (Object)((Item)JSV1Items.FAILED_EGG.get()).m_7968_());
                } else {
                    if (data.isValid()) {
                        this.spawnEntityOnHatch(data);
                    }
                    be.items.set(slot, (Object)ItemStack.f_41583_);
                }
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                    break;
                }
                case 3: {
                    be.progress4 = progressCur;
                    break;
                }
                case 4: {
                    be.progress5 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                    break;
                }
                case 3: {
                    be.progress4 = 0;
                    break;
                }
                case 4: {
                    be.progress5 = 0;
                }
            }
        }
    }

    protected void spawnEntityOnHatch(JSGeneData data) {
        if (data == null || data.getAnimal() == null) {
            return;
        }
        JSAnimal<?> animal = data.getAnimal();
        JSAnimalBase base = (JSAnimalBase)((EntityType)animal.getEntityType().get()).m_20615_(this.m_58904_());
        if (base == null) {
            return;
        }
        base.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        base.m_246847_((float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.2f, (float)this.m_58899_().m_123343_() + 0.5f);
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            base.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(this.m_58899_()), MobSpawnType.BREEDING, null, null);
            base.getModules().getMetabolismModule().setMax();
            base.getModules().getGeneticModule().setGeneData(data);
            base.getModules().getGeneticModule().markDirty();
            level2.m_7967_((Entity)base);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
        tag.m_128405_("js.egg.3", this.progress4);
        tag.m_128405_("js.egg.4", this.progress5);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress1 = tag.m_128451_("js.egg.0");
        this.progress2 = tag.m_128451_("js.egg.1");
        this.progress3 = tag.m_128451_("js.egg.2");
        this.progress4 = tag.m_128451_("js.egg.3");
        this.progress5 = tag.m_128451_("js.egg.4");
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
        tag.m_128405_("js.egg.3", this.progress4);
        tag.m_128405_("js.egg.4", this.progress5);
        return tag;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!(be instanceof SmallNestBlockEntity)) {
            return;
        }
        SmallNestBlockEntity e = (SmallNestBlockEntity)be;
        this.localTick(level, e);
    }

    public void localTick(Level lvl, SmallNestBlockEntity be) {
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.tickItem(3, lvl, be);
        be.tickItem(4, lvl, be);
        be.m_6596_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new NestMenu(i, inventory, this, this.data);
    }
}

