/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.entity.obj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.block.obj.entity.VehicleGate;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VehicleGateBlockEntity
extends BlockEntity {
    private int openTicks = 0;
    private int closeTicks = 16;
    private int checkCooldown = 0;
    private boolean openedByCar = false;
    public boolean isOpen = false;
    private boolean isActuallyOpen = false;
    private boolean isActuallyClosed = true;
    private static final HashMap<BlockPos, BlockPos> BLOCK_POS_BLOCK_ENTITY = new HashMap();
    private final BlockPos mainPos;

    public VehicleGateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JSBlockEntities.VEHICLE_GATE.get(), pos, state);
        this.mainPos = pos;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VehicleGateBlockEntity be) {
        if (level.f_46443_) {
            be.animate();
        } else {
            if (be.isOpen) {
                if (be.openTicks < 21) {
                    ++be.openTicks;
                }
                if (be.openTicks >= 20) {
                    be.isActuallyOpen = true;
                }
            } else {
                if (be.closeTicks < 21) {
                    ++be.closeTicks;
                }
                if (be.closeTicks >= 20) {
                    be.isActuallyClosed = true;
                }
            }
            if (be.checkCooldown-- <= 0) {
                JSVehicleEntity nearest = VehicleGateBlockEntity.findNearestVehicle(level, be.getMainPos(), 16.0);
                if (nearest != null) {
                    if (!be.isOpen) {
                        be.toggleOpen(null);
                        be.openedByCar = true;
                    }
                } else if (be.openedByCar && be.isOpen) {
                    be.toggleOpen(null);
                    be.openedByCar = false;
                }
                be.checkCooldown = 20;
            }
            be.m_6596_();
            if (be.closeTicks < 20 || be.openTicks < 20) {
                level.m_7260_(be.mainPos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
    }

    @Nullable
    private static JSVehicleEntity findNearestVehicle(Level level, BlockPos mainPos, double radius) {
        if (level.f_46443_) {
            return null;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)mainPos);
        AABB box = new AABB(center, center).m_82400_(radius);
        List list = level.m_6443_(JSVehicleEntity.class, box, e -> e.canTriggerNearbyDoors());
        if (list.isEmpty()) {
            return null;
        }
        double radiusSq = radius * radius;
        double bestDistSq = Double.MAX_VALUE;
        JSVehicleEntity nearest = null;
        for (JSVehicleEntity e2 : list) {
            double dSq = e2.m_20275_(center.f_82479_, center.f_82480_, center.f_82481_);
            if (!(dSq <= radiusSq) || !(dSq < bestDistSq)) continue;
            bestDistSq = dSq;
            nearest = e2;
        }
        return nearest;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("openTicks", this.openTicks);
        tag.m_128405_("closeTicks", this.closeTicks);
        tag.m_128379_("isOpen", this.isOpen);
        tag.m_128379_("isActuallyOpen", this.isActuallyOpen);
        tag.m_128379_("isActuallyClosed", this.isActuallyClosed);
        tag.m_128379_("openedByCar", this.openedByCar);
        List<BlockPos> children = BLOCK_POS_BLOCK_ENTITY.entrySet().stream().filter(e -> ((BlockPos)e.getValue()).equals((Object)this.mainPos)).map(Map.Entry::getKey).toList();
        tag.m_128405_("childCount", children.size());
        for (int i = 0; i < children.size(); ++i) {
            BlockPos c = children.get(i);
            tag.m_128405_("cX" + i, c.m_123341_());
            tag.m_128405_("cY" + i, c.m_123342_());
            tag.m_128405_("cZ" + i, c.m_123343_());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.openTicks = tag.m_128451_("openTicks");
        this.closeTicks = tag.m_128441_("closeTicks") ? tag.m_128451_("closeTicks") : 16;
        this.isOpen = tag.m_128471_("isOpen");
        this.isActuallyOpen = tag.m_128471_("isActuallyOpen");
        this.isActuallyClosed = tag.m_128471_("isActuallyClosed");
        this.openedByCar = tag.m_128471_("openedByCar");
        int count = tag.m_128451_("childCount");
        for (int i = 0; i < count; ++i) {
            BlockPos child = new BlockPos(tag.m_128451_("cX" + i), tag.m_128451_("cY" + i), tag.m_128451_("cZ" + i));
            BLOCK_POS_BLOCK_ENTITY.put(child, this.mainPos);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("isOpen", this.isOpen);
        tag.m_128405_("closeTicks", this.closeTicks);
        tag.m_128405_("openTicks", this.openTicks);
        tag.m_128379_("isActuallyOpen", this.isActuallyOpen);
        tag.m_128379_("isActuallyClosed", this.isActuallyClosed);
        return tag;
    }

    public void toggleOpen(Player player) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        if (this.isActuallyClosed) {
            this.isOpen = true;
            this.isActuallyClosed = false;
            this.isActuallyOpen = false;
            this.openTicks = 0;
            this.m_6596_();
            level.m_7260_(this.mainPos, this.m_58900_(), this.m_58900_(), 3);
            VehicleGate.checkForDoorUpdate(this, this.m_58900_(), level, this.mainPos);
        } else if (this.isActuallyOpen) {
            this.isOpen = false;
            this.isActuallyOpen = false;
            this.isActuallyClosed = false;
            this.closeTicks = 0;
            this.m_6596_();
            level.m_7260_(this.mainPos, this.m_58900_(), this.m_58900_(), 3);
            VehicleGate.checkForDoorUpdate(this, this.m_58900_(), level, this.mainPos);
        } else if (player != null) {
            player.m_5496_(SoundEvents.f_11748_, 1.0f, 1.0f);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void animate() {
        if (this.isOpen) {
            if (this.openTicks >= 15) {
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)this);
            } else {
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)this);
            }
        } else if (this.closeTicks >= 15) {
            JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)this);
        } else {
            JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)this);
        }
    }

    public void addOffsetBlockPos(BlockPos childPos) {
        BLOCK_POS_BLOCK_ENTITY.put(childPos, this.mainPos);
    }

    public void clear() {
        BLOCK_POS_BLOCK_ENTITY.entrySet().removeIf(e -> ((BlockPos)e.getValue()).equals((Object)this.mainPos));
    }

    public static HashMap<BlockPos, BlockPos> getBLOCK_POS_BLOCK_ENTITY() {
        return BLOCK_POS_BLOCK_ENTITY;
    }

    public BlockPos getMainPos() {
        return this.mainPos;
    }
}

