/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.entity;

import java.util.ArrayList;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.block.entity.obj.VehicleGateBlockEntity;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleGate
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty IS_BASE = BooleanProperty.m_61465_((String)"is_base");
    public static final BooleanProperty IS_SOLID = BooleanProperty.m_61465_((String)"is_solid");
    private static final VoxelShape SHAPE = VehicleGate.makeShape();
    private static final VoxelShape SHAPE_ROTATED = JSUtils.rotateShape(SHAPE, Rotation.CLOCKWISE_90);

    public VehicleGate(BlockBehaviour.Properties properties) {
        super(properties.m_280606_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_BASE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IS_SOLID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return facing == Direction.NORTH || facing == Direction.SOUTH ? SHAPE : SHAPE_ROTATED;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState pState, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        boolean solid = (Boolean)pState.m_61143_((Property)IS_SOLID);
        if (!solid) {
            return Shapes.m_83040_();
        }
        return facing == Direction.NORTH || facing == Direction.SOUTH ? SHAPE : SHAPE_ROTATED;
    }

    public static void checkForDoorUpdate(VehicleGateBlockEntity gate, BlockState pState, Level pLevel, BlockPos pPos) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean isOpen = gate.isOpen;
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        for (int i = -1; i < 2; ++i) {
            for (int a = 0; a < 3; ++a) {
                BlockPos pos = facing != Direction.EAST && facing != Direction.WEST ? pPos.m_7918_(i, a, 0) : pPos.m_7918_(0, a, i);
                BlockState state = pLevel.m_8055_(pos);
                if (!(state.m_60734_() instanceof VehicleGate) || !state.m_61138_((Property)IS_SOLID)) continue;
                pLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_SOLID, (Comparable)Boolean.valueOf(!isOpen)), 3);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (lvl, pos, st, blockEntity) -> {
            if (blockEntity instanceof VehicleGateBlockEntity) {
                VehicleGateBlockEntity be = (VehicleGateBlockEntity)blockEntity;
                VehicleGateBlockEntity.tick(lvl, pos, state, be);
            }
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)IS_SOLID) == false;
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, IS_BASE, IS_SOLID});
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (!level.f_46443_) {
            VehicleGateBlockEntity be = (VehicleGateBlockEntity)level.m_7702_(pos);
            if (be == null) {
                return;
            }
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            for (int i = -1; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    BlockPos thisPos = facing != Direction.EAST && facing != Direction.WEST ? pos.m_7918_(i, j, 0) : pos.m_7918_(0, j, i);
                    if (thisPos.equals((Object)pos)) continue;
                    if (level.m_8055_(thisPos).m_247087_()) {
                        list.add(thisPos);
                        continue;
                    }
                    if (placer instanceof Player) {
                        Player player = (Player)placer;
                        player.m_5496_(SoundEvents.f_11748_, 1.0f, 1.0f);
                    }
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    return;
                }
            }
            for (BlockPos blockPos : list) {
                be.addOffsetBlockPos(blockPos);
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)IS_BASE, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        if (!level.f_46443_) {
            this.breakFromMain(state, level, pos);
        }
        super.m_6240_(level, player, pos, state, blockEntity, tool);
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_6786_(level, pos, state);
        if (level instanceof Level) {
            Level lvl = (Level)level;
            if (!lvl.f_46443_) {
                this.breakFromMain(state, lvl, pos);
            }
        }
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.f_46443_) {
            this.breakFromMain(state, level, pos);
        }
    }

    private void breakFromMain(BlockState state, Level level, BlockPos pos) {
        VehicleGateBlockEntity be;
        BlockPos mainPos;
        if (level.f_46443_) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)IS_BASE)).booleanValue()) {
            mainPos = VehicleGateBlockEntity.getBLOCK_POS_BLOCK_ENTITY().get(pos);
            if (mainPos == null) {
                return;
            }
            be = (VehicleGateBlockEntity)level.m_7702_(mainPos);
        } else {
            be = (VehicleGateBlockEntity)level.m_7702_(pos);
        }
        if (be == null) {
            return;
        }
        mainPos = be.getMainPos();
        BlockState mainState = level.m_8055_(mainPos);
        Direction facing = (Direction)mainState.m_61143_((Property)FACING);
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos thisPos = facing != Direction.EAST && facing != Direction.WEST ? mainPos.m_7918_(i, j, 0) : mainPos.m_7918_(0, j, i);
                BlockState bs = level.m_8055_(thisPos);
                if (!(bs.m_60734_() instanceof VehicleGate)) continue;
                level.m_7731_(thisPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        be.clear();
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return (Boolean)pState.m_61143_((Property)IS_BASE) != false ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockPos newPos = pos;
            if (!((Boolean)state.m_61143_((Property)IS_BASE)).booleanValue()) {
                newPos = VehicleGateBlockEntity.getBLOCK_POS_BLOCK_ENTITY().get(pos);
            }
            if (newPos == null) {
                return InteractionResult.PASS;
            }
            level.m_141902_(newPos, (BlockEntityType)JSBlockEntities.VEHICLE_GATE.get()).ifPresent(blockEntity -> {
                if (blockEntity instanceof VehicleGateBlockEntity) {
                    VehicleGateBlockEntity be = (VehicleGateBlockEntity)((Object)blockEntity);
                    be.toggleOpen(player);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        if (!((Boolean)blockState.m_61143_((Property)IS_BASE)).booleanValue()) {
            return null;
        }
        return new VehicleGateBlockEntity(blockPos, blockState);
    }

    public static VoxelShape getSHAPE() {
        return SHAPE;
    }
}

