/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.fence;

import java.util.stream.Stream;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PoleBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CONNECTED_LEFT = BooleanProperty.m_61465_((String)"attached_left");
    public static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.m_61465_((String)"attached_right");
    public static final BooleanProperty CONNECTED_FWD = BooleanProperty.m_61465_((String)"attached_forward");
    public static final BooleanProperty CONNECTED_RWD = BooleanProperty.m_61465_((String)"attached_back");
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final VoxelShape SHAPE_NORTH = PoleBlock.getShape();
    public static final VoxelShape SHAPE_EAST = JSUtils.rotateShape(SHAPE_NORTH, Rotation.CLOCKWISE_90);
    public static final VoxelShape SHAPE_SOUTH = JSUtils.rotateShape(SHAPE_NORTH, Rotation.CLOCKWISE_180);
    public static final VoxelShape SHAPE_WEST = JSUtils.rotateShape(SHAPE_NORTH, Rotation.COUNTERCLOCKWISE_90);

    public PoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTED_LEFT, CONNECTED_RIGHT, CONNECTED_FWD, CONNECTED_RWD, POWERED});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_FWD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_RWD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return this.updateConnections(state, level, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.f_46443_) {
            this.updateConnections(state, (LevelAccessor)level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockState updated = this.updateConnections(state, (LevelAccessor)level, pos);
        if (updated != state) {
            level.m_7731_(pos, updated, 2);
        }
    }

    private BlockState updateConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction left = facing.m_122428_();
        Direction right = facing.m_122427_();
        Direction forward = facing;
        Direction behind = facing.m_122424_();
        state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(this.isWire(level, pos.m_121945_(left))))).m_61124_((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(this.isWire(level, pos.m_121945_(right))))).m_61124_((Property)CONNECTED_RWD, (Comparable)Boolean.valueOf(this.isWire(level, pos.m_121945_(behind))))).m_61124_((Property)CONNECTED_FWD, (Comparable)Boolean.valueOf(this.isWire(level, pos.m_121945_(forward))));
        return this.updatePower(state, level, pos);
    }

    private boolean isBottomPole(LevelAccessor level, BlockPos pos) {
        return !(level.m_8055_(pos.m_7495_()).m_60734_() instanceof PoleBlock);
    }

    private boolean isPoweredFromRedstone(LevelAccessor level, BlockPos pos) {
        return level.m_276867_(pos);
    }

    private BlockState updatePower(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean powered;
        if (this.isBottomPole(level, pos)) {
            powered = this.isPoweredFromRedstone(level, pos);
        } else {
            BlockState below = level.m_8055_(pos.m_7495_());
            powered = (Boolean)below.m_61143_((Property)POWERED);
        }
        return (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    private boolean isWire(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_((Block)JSV2Blocks.WIRE_BLOCK.get()) || state.m_60713_((Block)JSBlocks.VEHICLE_GATE.get()) || state.m_60838_((BlockGetter)level, pos);
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public static VoxelShape getShape() {
        return Stream.of(Block.m_49796_((double)5.25, (double)0.0, (double)10.0, (double)10.75, (double)16.0, (double)12.0), Block.m_49796_((double)5.25, (double)0.0, (double)20.0, (double)10.75, (double)16.0, (double)22.0), Block.m_49796_((double)6.25, (double)0.0, (double)12.0, (double)9.75, (double)16.0, (double)20.0), Block.m_49796_((double)7.75, (double)11.5, (double)9.0, (double)8.25, (double)12.5, (double)10.5), Block.m_49796_((double)7.75, (double)11.0, (double)7.0, (double)8.25, (double)13.0, (double)9.0), Block.m_49796_((double)7.75, (double)3.5, (double)9.0, (double)8.25, (double)4.5, (double)10.5), Block.m_49796_((double)7.75, (double)3.0, (double)7.0, (double)8.25, (double)5.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }
}

