/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.group;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSStair;
import jp.jurassicsaga.server.base.item.JSItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BasicBlockSetRegistries {
    public final Supplier<Block> WALL;
    public final Supplier<Block> SLAB;
    public final Supplier<Block> STAIRS;
    public final Supplier<Block> BLOCK;

    public BasicBlockSetRegistries(String name, BlockBehaviour.Properties baseBlock, Item.Properties empty) {
        this.BLOCK = JSBlocks.registerBlock(name, (Supplier<Block>)((Supplier)() -> new Block(baseBlock)));
        this.SLAB = JSBlocks.registerBlock(name + "_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())))));
        this.STAIRS = JSBlocks.registerBlock(name + "_stair", (Supplier<Block>)((Supplier)() -> new JSStair(((Block)this.BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())))));
        this.WALL = JSBlocks.registerBlock(name + "_wall", (Supplier<Block>)((Supplier)() -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())))));
        JSItems.registerItem(name, (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.BLOCK.get(), empty)));
        JSItems.registerItem(name + "_slab", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.SLAB.get(), empty)));
        JSItems.registerItem(name + "_stair", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.STAIRS.get(), empty)));
        JSItems.registerItem(name + "_wall", (Supplier<Item>)((Supplier)() -> new BlockItem((Block)this.WALL.get(), empty)));
    }

    public Collection<ItemLike> collect() {
        return this.stacks(this.WALL, this.SLAB, this.STAIRS, this.BLOCK);
    }

    @SafeVarargs
    private ArrayList<ItemLike> stacks(Supplier<Block> ... stacks) {
        ArrayList<ItemLike> stacksList = new ArrayList<ItemLike>();
        for (Supplier<Block> stack : stacks) {
            stacksList.add(this.stack(stack));
        }
        return stacksList;
    }

    private ItemLike stack(Supplier<Block> block) {
        return ((Block)block.get()).m_5456_();
    }

    public Supplier<Block> getWALL() {
        return this.WALL;
    }

    public Supplier<Block> getSLAB() {
        return this.SLAB;
    }

    public Supplier<Block> getSTAIRS() {
        return this.STAIRS;
    }

    public Supplier<Block> getBLOCK() {
        return this.BLOCK;
    }
}

