/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import jp.jurassicsaga.server.base.block.obj.plant.CustomPlaceMechanics;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBasicTriplePlant
extends JSPlantBlock
implements CustomPlaceMechanics {
    public static final EnumProperty<TripleBlockPart> PART = EnumProperty.m_61587_((String)"triple_block_part", TripleBlockPart.class);

    public JSBasicTriplePlant(BlockBehaviour.Properties props, boolean requiresLight, boolean spreadsAtDay) {
        super(props, requiresLight, spreadsAtDay);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)TripleBlockPart.LOWER)));
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        TripleBlockPart tripleBlockPart = (TripleBlockPart)((Object)pState.m_61143_(PART));
        if (pFacing.m_122434_() != Direction.Axis.Y || tripleBlockPart == TripleBlockPart.LOWER != (pFacing == Direction.UP) || pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(PART) != tripleBlockPart) {
            return tripleBlockPart == TripleBlockPart.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        if (tripleBlockPart == TripleBlockPart.MIDDLE != (pFacing == Direction.UP) || pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(PART) != tripleBlockPart) {
            return tripleBlockPart == TripleBlockPart.MIDDLE && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape SHAPE = super.m_5940_(state, level, pos, context);
        TripleBlockPart tripleBlockPart = (TripleBlockPart)((Object)state.m_61143_(PART));
        if (tripleBlockPart == TripleBlockPart.MIDDLE) {
            pos = pos.m_7495_();
        } else if (tripleBlockPart == TripleBlockPart.UPPER) {
            pos = pos.m_7495_().m_7495_();
        }
        Vec3 vec3 = state.m_60824_(level, pos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 2 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext) && level.m_8055_(blockpos.m_7494_().m_7494_()).m_60629_(pContext) ? super.m_5573_(pContext) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        BlockPos blockpos = pPos.m_7494_();
        pLevel.m_7731_(blockpos, JSBasicTriplePlant.copyWaterloggedFrom((LevelReader)pLevel, blockpos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)TripleBlockPart.MIDDLE))), 3);
        pLevel.m_7731_(blockpos.m_7494_(), JSBasicTriplePlant.copyWaterloggedFrom((LevelReader)pLevel, blockpos.m_7494_(), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)TripleBlockPart.UPPER))), 3);
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_61143_(PART) != TripleBlockPart.UPPER && pState.m_61143_(PART) != TripleBlockPart.MIDDLE) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_60734_() != this) {
            return false;
        }
        return blockstate.m_60713_((Block)this) && (blockstate.m_61143_(PART) == TripleBlockPart.LOWER || blockstate.m_61143_(PART) == TripleBlockPart.MIDDLE);
    }

    public void m_5707_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.f_46443_) {
            if (pPlayer.m_7500_()) {
                JSBasicTriplePlant.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
            } else {
                JSBasicTriplePlant.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.m_21205_());
                JSBasicTriplePlant.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
            }
        }
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        TripleBlockPart part = (TripleBlockPart)((Object)state.m_61143_(PART));
        BlockPos basePos = switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case TripleBlockPart.LOWER -> pos;
            case TripleBlockPart.MIDDLE -> pos.m_7495_();
            case TripleBlockPart.UPPER -> pos.m_6625_(2);
        };
        for (int i = 0; i < 3; ++i) {
            BlockPos targetPos = basePos.m_6630_(i);
            BlockState targetState = level.m_8055_(targetPos);
            if (!targetState.m_60713_(state.m_60734_())) continue;
            BlockState replacement = targetState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(targetPos, replacement, 35);
            level.m_5898_(player, 2001, targetPos, Block.m_49956_((BlockState)targetState));
        }
    }

    public static void placeAt(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        BlockPos blockpos = pPos.m_7494_();
        pLevel.m_7731_(pPos, JSBasicTriplePlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)pState.m_61124_(PART, (Comparable)((Object)TripleBlockPart.LOWER))), pFlags);
        pLevel.m_7731_(blockpos, JSBasicTriplePlant.copyWaterloggedFrom((LevelReader)pLevel, blockpos, (BlockState)pState.m_61124_(PART, (Comparable)((Object)TripleBlockPart.MIDDLE))), pFlags);
        pLevel.m_7731_(blockpos.m_7494_(), JSBasicTriplePlant.copyWaterloggedFrom((LevelReader)pLevel, blockpos, (BlockState)pState.m_61124_(PART, (Comparable)((Object)TripleBlockPart.UPPER))), pFlags);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PART});
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        return Mth.m_14130_((int)pPos.m_123341_(), (int)pPos.m_6625_(pState.m_61143_(PART) == TripleBlockPart.LOWER ? 0 : (pState.m_61143_(PART) == TripleBlockPart.MIDDLE ? 1 : 2)).m_123342_(), (int)pPos.m_123343_());
    }

    public static BlockState copyWaterloggedFrom(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pLevel.m_46801_(pPos))) : pState;
    }

    @Override
    public boolean canPlace(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        if (!pLevel.m_46859_(pPos.m_7494_())) {
            return false;
        }
        if (!pLevel.m_46859_(pPos.m_6630_(2))) {
            return false;
        }
        JSBasicTriplePlant.placeAt(pLevel, pState, pPos, pFlags);
        return true;
    }
}

