/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.stream.Stream;
import jp.jurassicsaga.JSCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class JSPlantBlock
extends BushBlock
implements BonemealableBlock {
    protected final int spreadRadius = 5;
    protected final int spreadHeight = 2;
    protected final int maxSamePlant = 3;
    protected final boolean requiresLight;
    protected final boolean spreadsAtDay;
    protected final int spreadChance = 50;

    public JSPlantBlock(BlockBehaviour.Properties props, boolean requiresLight, boolean spreadsAtDay) {
        super(props.m_60977_());
        this.requiresLight = requiresLight;
        this.spreadsAtDay = spreadsAtDay;
    }

    public JSPlantBlock(BlockBehaviour.Properties props, boolean requiresLight) {
        this(props.m_60977_(), requiresLight, true);
    }

    public JSPlantBlock(BlockBehaviour.Properties props) {
        this(props.m_60977_(), true, true);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(@NotNull Level level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return random.m_188503_(7) == 0;
    }

    public void m_214148_(@NotNull ServerLevel level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        for (int i = 0; i < random.m_216339_(1, 4); ++i) {
            if (!level.m_46749_(pos)) {
                return;
            }
            if (!this.isSpreadSuccess((Level)level, random, pos, state)) continue;
            this.performSpread((Level)level, random, pos, state);
        }
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (!level.m_46749_(pos)) {
            return;
        }
        if (!level.m_46469_().m_46207_(JSCommon.PLANT_SPREADING)) {
            return;
        }
        if ((float)random.m_188503_(100) > 75.0f) {
            return;
        }
        if (this.isSpreadSuccess((Level)level, random, pos, state)) {
            this.performSpread((Level)level, random, pos, state);
        }
    }

    public boolean isSpreadSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.requiresLight ? !this.spreadsAtDay || level.m_46461_() && level.m_46803_(pos.m_7494_()) >= 9 : !this.spreadsAtDay || level.m_46461_() && level.m_46803_(pos.m_7494_()) <= 8) {
            return this.getNumberOfNeibours(level, pos) < 6 && this.isWaterInRange(level, pos);
        }
        return false;
    }

    public void performSpread(Level level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos spreadTo = this.getSpreadPosition(level, random, pos, state, 5, 2);
        BlockState spr = level.m_8055_(spreadTo);
        if (spr.m_60734_() != this && spr.m_60795_() && level.m_8055_(spreadTo.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            level.m_46597_(spreadTo, this.m_49966_());
        }
    }

    public BlockPos getSpreadPosition(Level level, RandomSource random, BlockPos pos, BlockState state, int radius, int verticalDistance) {
        return pos.m_7918_(random.m_188503_(radius * 2) - radius, random.m_188503_(verticalDistance * 2) - verticalDistance, random.m_188503_(radius * 2) - radius);
    }

    public int getNumberOfNeibours(Level worldIn, BlockPos originalPos) {
        int spreadxz = 2;
        int y = 1;
        Stream e = BlockPos.MutableBlockPos.m_121921_((AABB)AABB.m_82321_((BoundingBox)new BoundingBox(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).m_82338_(originalPos));
        Stream<BlockPos> filtered = e.filter(blockPos -> worldIn.m_8055_(blockPos).m_60734_() == this);
        return (int)filtered.count() - 1;
    }

    public boolean isWaterInRange(Level worldIn, BlockPos pos) {
        int spreadxz = 5;
        int y = 1;
        Stream e = BlockPos.MutableBlockPos.m_121921_((AABB)AABB.m_82321_((BoundingBox)new BoundingBox(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).m_82338_(pos));
        return e.anyMatch(blockPos -> worldIn.m_8055_(blockPos).m_60819_().m_205070_(FluidTags.f_13131_));
    }
}

