/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.stream.Stream;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTallPlantBlock
extends JSPlantBlock {
    public static final EnumProperty<SegmentPart> SEGMENT = JSBlockStateProperties.SEGMENTED;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected final int wantedSegmentCount;

    public JSTallPlantBlock(int wantedSegmentCount, BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
        this.wantedSegmentCount = wantedSegmentCount > 9 ? 8 : wantedSegmentCount;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SEGMENT, (Comparable)((Object)SegmentPart.SEGMENT_1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SEGMENT});
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel && state.m_60734_() == this && state.m_61138_(JSBlockStateProperties.SEGMENTED) && state.m_61143_(JSBlockStateProperties.SEGMENTED) == SegmentPart.SEGMENT_1) {
            this.updateSegments(level, pos);
        }
    }

    @Override
    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.m_46749_(pos)) {
            return;
        }
        if (state.m_61143_(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1)) {
            super.m_213898_(state, level, pos, random);
        }
        if (level.m_46803_(pos.m_7494_()) >= 9 && random.m_188503_(4) == 0 && level.m_8055_(pos.m_7494_()).m_60795_() && this.countSegments((BlockGetter)level, pos) < this.wantedSegmentCount) {
            level.m_7731_(pos.m_7494_(), this.m_49966_(), 2);
        }
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_6786_(level, pos, state);
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            this.updateSegments(actualLevel, pos.m_7495_());
        }
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        this.updateSegments(level, pos.m_7495_());
    }

    public int countSegments(BlockGetter worldIn, BlockPos pos) {
        for (int i = 0; i < this.wantedSegmentCount + 1; ++i) {
            BlockState state = worldIn.m_8055_(pos.m_6625_(i));
            if (state.m_60734_() == this) {
                continue;
            }
            return i;
        }
        return -1;
    }

    public boolean m_5946_(BlockState state, @NotNull Fluid fluid) {
        return state.m_61143_(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1);
    }

    public void updateSegments(Level world, BlockPos pos) {
        BlockPos top = pos;
        while (world.m_8055_(top.m_7494_()).m_60734_() == this) {
            top = top.m_7494_();
        }
        BlockPos current = top;
        for (int segmentIndex = 0; world.m_8055_(current).m_60734_() == this && segmentIndex <= this.wantedSegmentCount; ++segmentIndex) {
            SegmentPart part = SegmentPart.getSegment(segmentIndex);
            BlockState state = world.m_8055_(current);
            BlockState newState = (BlockState)this.m_49966_().m_61124_(SEGMENT, (Comparable)((Object)part));
            if (state.m_60734_() == this && state.m_61138_(SEGMENT) && state.m_61143_(SEGMENT) != part) {
                world.m_7731_(current, newState, 2);
            }
            current = current.m_7495_();
        }
    }

    protected boolean m_6266_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.m_6266_(state, level, pos) || level.m_8055_(pos).m_60734_() == this && this.countSegments(level, pos) < this.wantedSegmentCount;
    }

    @Override
    public void m_214148_(@NotNull ServerLevel level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_214148_(level, random, pos, state);
        if (level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50016_ && this.m_6266_(level.m_8055_(pos), (BlockGetter)level, pos)) {
            level.m_46597_(pos.m_121945_(Direction.UP), this.m_49966_());
            this.updateSegments((Level)level, pos.m_7494_());
        } else {
            Block block = level.m_8055_(pos.m_7494_()).m_60734_();
            if (block instanceof JSTallPlantBlock) {
                JSTallPlantBlock block2 = (JSTallPlantBlock)block;
                block2.m_214148_(level, random, pos.m_7494_(), state);
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vec3d = state.m_60824_(level, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (neighborPos.equals((Object)pos.m_7495_())) {
            this.updateSegments(level, pos);
        }
    }

    @Override
    public boolean isSpreadSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return state.m_61143_(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1) && super.isSpreadSuccess(level, random, pos, state);
    }

    @Override
    public int getNumberOfNeibours(Level worldIn, BlockPos originalPos) {
        int spreadXz = 5;
        int y = 2;
        Stream e = BlockPos.MutableBlockPos.m_121921_((AABB)AABB.m_82321_((BoundingBox)new BoundingBox(-spreadXz, -y, -spreadXz, spreadXz, y, spreadXz)).m_82338_(originalPos));
        Stream<BlockPos> filtered = e.filter(blockPos -> worldIn.m_8055_(blockPos).m_60734_() == this && worldIn.m_8055_(blockPos).m_61143_(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1));
        return (int)filtered.count() - 1;
    }

    public int getWantedSegmentCount() {
        return this.wantedSegmentCount;
    }
}

