/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.Random;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentedTallPlant
extends JSPlantBlock {
    public static final EnumProperty<SegmentPart> PART = JSBlockStateProperties.SEGMENTED;
    public static final EnumProperty<SegmentPart> START_PART = JSBlockStateProperties.START_SEGMENT;
    private final SegmentPart maxSegment;
    private final boolean randomStartHeight;
    private final Random random = new Random();

    public SegmentedTallPlant(BlockBehaviour.Properties properties, SegmentPart maxSegment) {
        this(properties, maxSegment, false);
    }

    public SegmentedTallPlant(BlockBehaviour.Properties properties, SegmentPart maxSegment, boolean randomStartHeight) {
        super(properties);
        this.randomStartHeight = randomStartHeight;
        this.maxSegment = maxSegment;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(START_PART, (Comparable)((Object)maxSegment)));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)maxSegment)));
    }

    public static BlockState copyWaterloggedFrom(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pLevel.m_46801_(pPos))) : pState;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 2 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext) && level.m_8055_(blockpos.m_7494_().m_7494_()).m_60629_(pContext) ? super.m_5573_(pContext) : null;
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        int startCount;
        BlockState state;
        SegmentPart start = this.maxSegment;
        if (this.randomStartHeight && this.random.nextBoolean()) {
            float nextFloat = this.random.nextFloat();
            start = nextFloat <= 0.4f ? this.maxSegment.getPartBelow() : ((double)nextFloat >= 0.6 ? this.maxSegment.getPartBelow().getPartBelow() : this.maxSegment.getPartBelow().getPartBelow().getPartBelow());
        }
        int segmentCount = this.maxSegment.getOffset() + 1;
        int offset = 0;
        if (segmentCount >= 8) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_8)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 8) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 7) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_7)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 7) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 6) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_6)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 7) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 5) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_5)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 5) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 4) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_4)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 4) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 3) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_3)));
            state = (BlockState)state.m_61124_(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 3) {
                    pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.m_7731_(pPos.m_6630_(offset), state, 3);
                ++offset;
            }
        }
        pLevel.m_7731_(pPos.m_6630_(offset), SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_2))).m_61124_(START_PART, (Comparable)((Object)start))), 3);
        pLevel.m_7731_(pPos.m_6630_(++offset), SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)SegmentPart.SEGMENT_1))).m_61124_(START_PART, (Comparable)((Object)start))), 3);
    }

    public boolean m_7898_(BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        SegmentPart part = (SegmentPart)((Object)pState.m_61143_(PART));
        SegmentPart startPart = (SegmentPart)((Object)pState.m_61143_(START_PART));
        if (startPart == SegmentPart.SEGMENT_1) {
            return this.m_6266_(pLevel.m_8055_(pPos.m_7495_()), (BlockGetter)pLevel, pPos.m_7495_());
        }
        if (part == startPart) {
            return this.m_6266_(pLevel.m_8055_(pPos.m_7495_()), (BlockGetter)pLevel, pPos.m_7495_()) && pLevel.m_8055_(pPos.m_7494_()).m_60713_((Block)this);
        }
        if (part != SegmentPart.SEGMENT_1 && !pLevel.m_8055_(pPos.m_7494_()).m_60713_((Block)this)) {
            return false;
        }
        return pLevel.m_8055_(pPos.m_7495_()).m_61138_(PART);
    }

    public void m_5707_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.f_46443_ && !pPlayer.m_7500_()) {
            SegmentedTallPlant.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.m_21205_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PART});
        pBuilder.m_61104_(new Property[]{START_PART});
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        return Mth.m_14130_((int)pPos.m_123341_(), (int)pPos.m_6625_(((SegmentPart)((Object)pState.m_61143_(PART))).getOffset()).m_123342_(), (int)pPos.m_123343_());
    }

    public SegmentPart getMaxSegment() {
        return this.maxSegment;
    }
}

