/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.egg;

import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.ModelType;

public class EggEntity
extends Mob {
    private static final EntityDataAccessor<Integer> hatchTicks = SynchedEntityData.m_135353_(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> hatched = SynchedEntityData.m_135353_(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<CompoundTag> gene_data = SynchedEntityData.m_135353_(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final int DECAY_TICKS = 2000;
    private int maxTicks;
    private int decayTicks;
    private JSAnimal<?> animal = null;
    private JSGeneData data = new JSGeneData();
    private EntityDimensions dimensions = null;

    public EggEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21183_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    @Nullable
    public ItemStack m_142340_() {
        JSGeneData data = JSGeneUtil.fromCompound((CompoundTag)this.f_19804_.m_135370_(gene_data));
        JSAnimal<?> animal = JSAnimals.getAnimal(data.getDataOwnerName());
        if (animal != null && animal.getItems().getHatched_egg() != null) {
            ItemStack item = ((Item)animal.getItems().getHatched_egg().get()).m_7968_();
            JSGeneUtil.writeToStack(item, data);
            return item;
        }
        return super.m_142340_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!((Boolean)this.f_19804_.m_135370_(hatched)).booleanValue()) {
            JSAnimations.IDLE.sendForEntity(ModelType.AZURE, (Entity)this);
            if (this.animal != null) {
                int maxTicks = this.getMaxHatchTicks();
                int ticks = this.getHatchTicks();
                if (++ticks >= maxTicks) {
                    this.hatch();
                    this.setHatchTicks(ticks);
                    return;
                }
                this.setHatchTicks(ticks);
            }
        } else {
            JSAnimations.OPEN_HOLD.sendForEntity(ModelType.AZURE, (Entity)this);
            if (this.decayTicks < 2000) {
                ++this.decayTicks;
            } else {
                this.m_6074_();
            }
        }
    }

    private void hatch() {
        JSAnimalBase base = (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).m_20615_(this.m_9236_());
        if (base == null) {
            return;
        }
        base.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        base.m_246847_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            base.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(this.m_20183_()), MobSpawnType.SPAWN_EGG, null, null);
            base.getModules().getMetabolismModule().setMax();
            base.getModules().getGeneticModule().setGeneData(this.data);
            level2.m_7967_((Entity)base);
            this.f_19804_.m_135381_(hatched, (Object)true);
        }
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.DESTROY;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(hatchTicks, (Object)0);
        this.f_19804_.m_135372_(hatched, (Object)false);
        this.f_19804_.m_135372_(gene_data, (Object)new CompoundTag());
        super.m_8097_();
    }

    public void m_7378_(CompoundTag compound) {
        this.setHatchTicks(compound.m_128451_("js.hatch_ticks"));
        this.setMaxHatchTicks(compound.m_128451_("js.max_hatch_ticks"));
        this.decayTicks = compound.m_128451_("js.decay");
        this.f_19804_.m_135381_(hatched, (Object)compound.m_128471_("js.hatched"));
        CompoundTag tag = compound.m_128469_("js.animal");
        this.data.loadFromNbt(tag);
        this.f_19804_.m_135381_(gene_data, (Object)tag);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("js.hatch_ticks", this.getHatchTicks());
        compound.m_128405_("js.max_hatch_ticks", this.getMaxHatchTicks());
        compound.m_128405_("js.decay", this.decayTicks);
        compound.m_128379_("js.hatched", ((Boolean)this.f_19804_.m_135370_(hatched)).booleanValue());
        CompoundTag tag = new CompoundTag();
        this.data.saveToNbt(tag);
        compound.m_128365_("js.animal", (Tag)tag);
    }

    private int getHatchTicks() {
        return (Integer)this.f_19804_.m_135370_(hatchTicks);
    }

    private void setHatchTicks(int anInt) {
        this.f_19804_.m_135381_(hatchTicks, (Object)anInt);
    }

    private int getMaxHatchTicks() {
        return this.maxTicks;
    }

    public void setMaxHatchTicks(int maxHatchTicks) {
        this.maxTicks = maxHatchTicks;
    }

    public float getSize() {
        if (this.animal == null) {
            this.animal = this.getAnimal();
        }
        if (this.animal != null) {
            return (float)this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale();
        }
        return 1.0f;
    }

    @NotNull
    protected AABB m_142242_() {
        if (this.data == null) {
            return this.getDefaultDimensions(this.m_20089_()).m_20393_(this.m_20182_());
        }
        JSAnimal<?> animal1 = this.getAnimal();
        if (animal1 == null) {
            return this.getDefaultDimensions(this.m_20089_()).m_20393_(this.m_20182_());
        }
        if (this.dimensions == null) {
            if (this.animal != null) {
                float xz = (float)((double)0.325f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                float y = (float)((double)0.525f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                this.dimensions = EntityDimensions.m_20395_((float)xz, (float)y);
            } else {
                return this.getDefaultDimensions(this.m_20089_()).m_20393_(this.m_20182_());
            }
        }
        return this.dimensions.m_20393_(this.m_20182_());
    }

    private EntityDimensions getDefaultDimensions(Pose pose) {
        return this.m_6095_().m_20680_();
    }

    private JSAnimal<?> getAnimal() {
        return JSAnimals.getAnimal(this.data.getDataOwnerName());
    }

    public void m_6043_() {
        if (((Boolean)this.f_19804_.m_135370_(hatched)).booleanValue()) {
            super.m_6043_();
        }
    }

    protected void m_6153_() {
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_269138_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268464_)) {
            super.m_269138_(damageSource);
        }
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        if (damageSource.m_276093_(DamageTypes.f_268464_) || damageSource.m_276093_(DamageTypes.f_286979_) && ((Boolean)this.f_19804_.m_135370_(hatched)).booleanValue()) {
            super.m_6475_(damageSource, damageAmount);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_286979_) && ((Boolean)this.f_19804_.m_135370_(hatched)).booleanValue()) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public void setData(JSGeneData data) {
        this.f_19804_.m_135381_(gene_data, (Object)data.saveToNbt(new CompoundTag()));
        this.data = data;
        this.animal = data.getAnimal();
        if (!TravelersMain.isDebugging()) {
            this.setMaxHatchTicks(this.animal.getAnimalAttributes().getGeneticProperties().getEggHatchTicks());
        } else {
            this.setMaxHatchTicks(5);
        }
    }
}

