/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other;

import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.other.LerpRotHolder;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends Entity
implements LerpRotHolder {
    protected static final EntityDataAccessor<Boolean> STAND = SynchedEntityData.m_135353_(SeatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private JSVehicleEntity jsVehicle;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 relativePos;
    private boolean interacteAble;

    public SeatEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public SeatEntity(Level world, Vec3 pos, boolean canBeInteractedWith, JSVehicleEntity jsVehicleEntity) {
        super((EntityType)JSEntities.SEAT.get(), world);
        this.m_146884_(pos);
        this.relativePos = pos;
        this.interacteAble = canBeInteractedWith;
        this.jsVehicle = jsVehicleEntity;
    }

    public SeatEntity(Level world, Vec3 pos) {
        this(world, pos, false);
    }

    public SeatEntity(Level world, Vec3 pos, boolean canBeInteractedWith) {
        super((EntityType)JSEntities.SEAT.get(), world);
        this.m_146884_(pos);
        this.relativePos = pos;
        this.interacteAble = canBeInteractedWith;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STAND, (Object)false);
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickLerp();
        if (!this.interacteAble && this.m_20197_().isEmpty() && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void tickLerp() {
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    protected void lerpPositionAndRotationStep(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d0 = 1.0 / (double)steps;
        double d1 = Mth.m_14139_((double)d0, (double)this.m_20185_(), (double)targetX);
        double d2 = Mth.m_14139_((double)d0, (double)this.m_20186_(), (double)targetY);
        double d3 = Mth.m_14139_((double)d0, (double)this.m_20189_(), (double)targetZ);
        float f = Mth.m_14189_((float)((float)d0), (float)this.m_146908_(), (float)((float)targetYRot));
        float f1 = (float)Mth.m_14139_((double)d0, (double)this.m_146909_(), (double)targetXRot);
        this.m_6034_(d1, d2, d3);
        this.m_19915_(f, f1);
    }

    public boolean hasNoPassenger() {
        return this.m_20197_().isEmpty();
    }

    public Entity m_146895_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public boolean m_142391_() {
        return false;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (!this.m_20197_().isEmpty()) {
            this.lerpX = x;
            this.lerpY = y;
            this.lerpZ = z;
            this.lerpYRot = yaw;
            this.lerpXRot = pitch;
            this.lerpSteps = 10;
        } else {
            this.m_6034_(x, y, z);
            this.m_19915_(yaw, pitch);
        }
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.m_20185_();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.m_20186_();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.m_20189_();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.m_146909_();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.m_146908_();
    }

    public boolean m_6047_() {
        return false;
    }

    public boolean m_20151_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_20145_() {
        return true;
    }

    public boolean m_7337_(@NotNull Entity entity) {
        return false;
    }

    public boolean shouldStand() {
        return (Boolean)this.f_19804_.m_135370_(STAND);
    }

    public void setStanding() {
        this.f_19804_.m_135381_(STAND, (Object)true);
    }

    public JSVehicleEntity getJsVehicle() {
        return this.jsVehicle;
    }

    public Vec3 getRelativePos() {
        return this.relativePos;
    }
}

