/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import jp.jurassicsaga.client.base.sound.SoundRelayer;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.block.obj.entity.VehicleGate;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v2.block.entity.obj.TriggerTourRailEntity;
import jp.jurassicsaga.server.v2.block.obj.TourRailBlock;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import jp.jurassicsaga.server.v2.item.obj.WrenchItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.TravelersAnimal;

public class FordExplorerEntity
extends JSVehicleEntity {
    protected static final EntityDataAccessor<Boolean> IS_IN_TOUR_MODE = SynchedEntityData.m_135353_(FordExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> REQUIRES_TAG_REFRESH = SynchedEntityData.m_135353_(FordExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Map<RailShape, Direction[]> SHAPE_DIRS = Map.of(RailShape.NORTH_SOUTH, new Direction[]{Direction.NORTH, Direction.SOUTH}, RailShape.EAST_WEST, new Direction[]{Direction.EAST, Direction.WEST}, RailShape.ASCENDING_NORTH, new Direction[]{Direction.NORTH, Direction.SOUTH}, RailShape.ASCENDING_SOUTH, new Direction[]{Direction.SOUTH, Direction.NORTH}, RailShape.ASCENDING_EAST, new Direction[]{Direction.EAST, Direction.WEST}, RailShape.ASCENDING_WEST, new Direction[]{Direction.WEST, Direction.EAST}, RailShape.SOUTH_EAST, new Direction[]{Direction.SOUTH, Direction.EAST}, RailShape.SOUTH_WEST, new Direction[]{Direction.SOUTH, Direction.WEST}, RailShape.NORTH_EAST, new Direction[]{Direction.NORTH, Direction.EAST}, RailShape.NORTH_WEST, new Direction[]{Direction.NORTH, Direction.WEST});
    private Direction railDir;
    private BlockPos currentRail;
    private BlockPos lastTriggerPos = null;
    private int stopTicks;
    private int blockedTicks;
    private FordExplorerEntity followTarget;
    private UUID linkedVehicleUUID;
    private boolean isInPursuit;
    private boolean cantFindRail;
    private float currentMaxSpeed = 0.1f;

    public FordExplorerEntity(EntityType<? extends JSVehicleEntity> entityType, Level level) {
        super(entityType, level);
        this.setMaxSpeed(0.9f);
        this.setTurnSpeed(5.0f);
        this.setMaxTurnSpeed(5.0f);
        this.setAcceleration(0.02f);
        this.setMaxSpeedBackwards(0.4f);
    }

    @Override
    void honk() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)JSSounds.CAR_HONK.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
        Optional<SeatEntity> optionalSeatEntity = this.seats.stream().filter(seatEntity -> seatEntity.m_146895_() != null).findFirst();
        List animals = this.m_9236_().m_6443_(JSAnimalBase.class, this.m_20191_().m_82400_(10.0), a -> true);
        for (JSAnimalBase animal : animals) {
            TravelersAnimal animalobj = animal.getAnimal();
            boolean attacksCar = animalobj.getAnimalAttributes().getMiscProperties().isAttacksCar();
            if (!attacksCar) {
                boolean bl = attacksCar = animal.getAggression() + animalobj.getAnimalAttributes().getSocialGroupProperties().getNaturalAggression() > 0.5f;
            }
            if (attacksCar) {
                Entity passenger;
                if (!optionalSeatEntity.isPresent() || !((passenger = optionalSeatEntity.get().m_146895_()) instanceof Player)) continue;
                Player player = (Player)passenger;
                animal.m_6710_((LivingEntity)player);
                JSAnimalBase trueLeader = animal.getModules().getHerdModule().getTrueLeader();
                if (trueLeader != null) {
                    for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                        if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                            follower.m_6710_((LivingEntity)player);
                            continue;
                        }
                        follower.setFleeTarget(this);
                    }
                    trueLeader.m_6710_((LivingEntity)player);
                }
                animal.setFleeTarget(null);
                continue;
            }
            animal.setFleeTarget(this);
            animal.m_6710_(null);
        }
    }

    @Override
    protected InteractionResult wrenchInteract(InteractionHand hand, WrenchItem.WrenchMode wrenchMode, Player player) {
        if (wrenchMode == WrenchItem.WrenchMode.TOGGLE_MODE) {
            boolean isInTour = (Boolean)this.f_19804_.m_135370_(IS_IN_TOUR_MODE);
            if (isInTour) {
                this.currentRail = null;
                this.lastTriggerPos = null;
                this.stopTicks = 0;
            } else {
                this.railDir = Direction.m_122364_((double)this.m_146908_());
            }
            this.f_19804_.m_135381_(IS_IN_TOUR_MODE, (Object)(!this.isInTour() ? 1 : 0));
            JSUtils.message(player, (Component)(isInTour ? Component.m_237115_((String)"tooltip.jurassicsaga.wrench.ford_toggle_off") : Component.m_237115_((String)"tooltip.jurassicsaga.wrench.ford_toggle_on")));
        } else if (wrenchMode == WrenchItem.WrenchMode.LINK) {
            ItemStack wrench = player.m_21120_(hand);
            CompoundTag tag = wrench.m_41784_();
            if (wrench.m_150930_((Item)JSV2Items.WRENCH.get())) {
                if (tag.m_128441_("vehicleUUID")) {
                    String uuidString = tag.m_128461_("vehicleUUID");
                    UUID uuid = UUID.fromString(uuidString);
                    if (!uuid.equals(this.m_20148_())) {
                        this.linkedVehicleUUID = uuid;
                        this.isInPursuit = true;
                        tag.m_128473_("vehicleUUID");
                        JSUtils.message(player, (Component)Component.m_237115_((String)"tooltip.jurassicsaga.wrench.ford_link"));
                        if (this.linkedVehicleUUID != null && this.followTarget == null) {
                            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.linkedVehicleUUID);
                            if (entity instanceof FordExplorerEntity) {
                                FordExplorerEntity fordExplorerEntity;
                                this.followTarget = fordExplorerEntity = (FordExplorerEntity)entity;
                                fordExplorerEntity.linkedVehicleUUID = this.m_20148_();
                                fordExplorerEntity.followTarget = this;
                                fordExplorerEntity.isInPursuit = false;
                            } else {
                                this.linkedVehicleUUID = null;
                            }
                        }
                    } else {
                        JSUtils.message(player, (Component)Component.m_237115_((String)"tooltip.jurassicsaga.wrench.ford_link_fail_self"));
                    }
                    wrench.m_41784_().m_128473_("vehicleUUID");
                } else {
                    tag.m_128359_("vehicleUUID", this.m_20149_());
                }
                wrench.m_41751_(tag);
                player.m_21008_(hand, wrench);
            }
        } else if (wrenchMode == WrenchItem.WrenchMode.UNLINK) {
            this.unlink();
        }
        return super.wrenchInteract(hand, wrenchMode, player);
    }

    @Override
    public void m_8119_() {
        if (!this.isInTour()) {
            super.m_8119_();
            return;
        }
        this.m_6075_();
        if (this.m_9236_().f_46443_) {
            if ((double)((Float)this.f_19804_.m_135370_(CURRENT_SPEED)).floatValue() != 0.0) {
                SoundRelayer.playCarLoop(this);
            } else {
                SoundRelayer.stopCarLoop(this);
            }
            super.m_8119_();
        } else {
            Entity entity;
            this.animateServer();
            float speed = this.getCurrentSpeed();
            if (!this.isInPursuit) {
                speed = this.handleSpeed(speed);
            } else if (this.followTarget != null) {
                double dist = this.followTarget.m_20270_(this);
                float targetSpeed = dist > 11.5 ? Math.min(1.1f, Math.max(0.1f, this.followTarget.getCurrentSpeed()) * 2.0f) : (dist < 10.5 ? ((double)this.followTarget.getCurrentSpeed() == 0.0 ? -0.1f : Math.max(0.001f, this.followTarget.getCurrentSpeed()) * 0.6f) : this.followTarget.getCurrentSpeed());
                if (speed < targetSpeed) {
                    speed = Math.min(speed + this.acceleration, Math.min(targetSpeed, this.getMaxSpeed()));
                } else if (speed > targetSpeed) {
                    speed = Math.max(speed - this.acceleration, targetSpeed);
                }
            } else if (this.linkedVehicleUUID != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.linkedVehicleUUID)) instanceof FordExplorerEntity) {
                FordExplorerEntity fordExplorerEntity;
                this.followTarget = fordExplorerEntity = (FordExplorerEntity)entity;
                fordExplorerEntity.linkedVehicleUUID = this.m_20148_();
                fordExplorerEntity.followTarget = this;
                fordExplorerEntity.isInPursuit = false;
            }
            BlockPos railPos = this.currentRail == null ? this.m_20183_() : this.currentRail;
            Vec3 railCenter = Vec3.m_82512_((Vec3i)railPos);
            if (this.currentRail == null || this.m_20182_().m_82557_(railCenter) < 2.0) {
                BlockPos next = this.findNextRail(railPos);
                if (next != null) {
                    this.currentRail = next;
                    railPos = next;
                    this.cantFindRail = false;
                } else {
                    this.cantFindRail = true;
                }
            }
            Vec3 target = Vec3.m_82512_((Vec3i)railPos);
            Vec3 dir = target.m_82546_(this.m_20182_()).m_82541_();
            float targetYaw = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
            float currentYaw = this.m_146908_();
            float newYaw = Mth.m_14189_((float)0.1f, (float)currentYaw, (float)targetYaw);
            this.m_146922_(newYaw);
            double dx = dir.f_82479_ * (double)this.getCurrentSpeed();
            double dz = dir.f_82481_ * (double)this.getCurrentSpeed();
            Vec3 movementVec = this.applyGravityToVec(dx, dz);
            this.m_6478_(MoverType.SELF, movementVec);
            this.setCurrentSpeed(speed);
            this.m_146922_(newYaw);
            this.setCurrentSpeed(speed);
            this.handleCollision();
            this.checkForClimbingBlocks();
            this.updateSeats(this.m_146908_());
        }
    }

    private float handleSpeed(float speed) {
        double dist;
        if (this.cantFindRail) {
            return Math.max(speed - this.acceleration, 0.0f);
        }
        if (this.stopTicks == 0) {
            double lookAhead = 8.0 * (double)Math.max(1.0f, speed * 4.0f);
            double brakeStart = 30.0;
            double fullStop = 15.0;
            Vec3 pos = this.m_20182_();
            Vec3 forward = this.m_20154_().m_82541_();
            AABB scanBox = this.m_20191_().m_82369_(forward.m_82490_(lookAhead)).m_82400_(1.0);
            List entities = this.m_9236_().m_6249_((Entity)this, scanBox, e -> e instanceof LivingEntity && e.m_6084_() && e != this && !e.m_20159_());
            double nearestForward = Double.MAX_VALUE;
            Entity nearestEntity = null;
            for (Entity e2 : entities) {
                Vec3 toEntity = e2.m_20191_().m_82399_().m_82546_(pos);
                double forwardDist = toEntity.m_82526_(forward);
                if (forwardDist <= 0.0 || forwardDist > lookAhead) continue;
                Vec3 closest = pos.m_82549_(forward.m_82490_(forwardDist));
                double hitboxDistSq = e2.m_20191_().m_272282_(closest);
                double score = Math.sqrt(hitboxDistSq);
                if (!(score < nearestForward)) continue;
                nearestForward = score;
                nearestEntity = e2;
            }
            if (nearestForward < brakeStart) {
                if (this.blockedTicks == 0) {
                    if (nearestEntity instanceof JSAnimalBase) {
                        JSAnimalBase base = (JSAnimalBase)nearestEntity;
                        if (!base.isDead()) {
                            this.honk();
                        }
                    } else {
                        this.honk();
                    }
                    this.blockedTicks = 40;
                } else {
                    --this.blockedTicks;
                }
                if (nearestForward <= fullStop) {
                    return Math.max(speed - this.acceleration * 4.0f, 0.0f);
                }
                return Math.max(speed - this.acceleration * 2.0f, this.getMaxSpeed() * 0.5f);
            }
        }
        if (this.stopTicks > 0) {
            --this.stopTicks;
            if (speed > 0.0f) {
                return Math.max(speed - this.acceleration, 0.0f);
            }
            if (speed < 0.02f) {
                return 0.0f;
            }
        }
        if (this.followTarget != null && (dist = (double)this.followTarget.m_20270_(this)) > 16.0) {
            if (dist > 22.0) {
                if ((double)speed > 0.0) {
                    return Math.max(speed - this.acceleration, 0.0f);
                }
                return 0.0f;
            }
            if (speed > this.getMaxSpeed() * 0.5f) {
                return Math.max(speed - this.acceleration, this.getMaxSpeed() * 0.5f);
            }
            return speed;
        }
        if (Math.abs(speed) < 1.0E-4f) {
            speed = 0.0f;
        }
        speed = speed < this.getMaxSpeed() ? Math.min(speed + this.acceleration, this.getMaxSpeed()) : this.getMaxSpeed();
        return speed;
    }

    private void stopFor(int stopTicks) {
        this.stopTicks = stopTicks;
    }

    public void setSpeed(float speed) {
        this.currentMaxSpeed = speed;
    }

    private BlockPos findNextRail(BlockPos pos) {
        boolean isGate;
        RailShape shape;
        Direction[] options;
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!this.isValidBlock(pos)) {
            state = this.m_9236_().m_8055_(pos.m_7495_());
            if (!this.isValidBlock(pos = pos.m_7495_())) {
                return null;
            }
        }
        if ((options = SHAPE_DIRS.get(shape = (isGate = state.m_60734_() instanceof VehicleGate) ? this.getShapeFromGate(state) : (RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_))) == null) {
            return null;
        }
        Direction back = this.railDir == null ? null : this.railDir.m_122424_();
        for (Direction dir : options) {
            BlockPos up;
            if (dir == back) continue;
            BlockPos next = pos.m_121945_(dir);
            if (this.isValidBlock(next.m_7495_())) {
                this.railDir = dir;
                return next;
            }
            if (this.isValidBlock(next)) {
                this.railDir = dir;
                return next;
            }
            if (!shape.m_61745_() || !this.isValidBlock(up = next.m_7494_())) continue;
            return up;
        }
        return null;
    }

    private RailShape getShapeFromGate(BlockState state) {
        Optional facing = state.m_61145_((Property)BlockStateProperties.f_61374_);
        if (facing.isPresent()) {
            Direction actualFacing = (Direction)facing.get();
            if (actualFacing == Direction.NORTH || actualFacing == Direction.SOUTH) {
                return RailShape.NORTH_SOUTH;
            }
            return RailShape.EAST_WEST;
        }
        return RailShape.NORTH_SOUTH;
    }

    private boolean isValidBlock(BlockPos pos) {
        BlockState block = this.m_9236_().m_8055_(pos);
        if (block.m_60734_() instanceof VehicleGate) {
            return (Boolean)block.m_61143_((Property)VehicleGate.IS_BASE);
        }
        return block.m_60734_() instanceof TourRailBlock;
    }

    @Override
    protected void updateDriver(Player driver) {
        if (this.isInTour()) {
            return;
        }
        super.updateDriver(driver);
    }

    @Override
    protected void updateNoDriver() {
        if (this.isInTour()) {
            return;
        }
        super.updateNoDriver();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_IN_TOUR_MODE, (Object)false);
        this.f_19804_.m_135372_(REQUIRES_TAG_REFRESH, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IS_IN_TOUR_MODE", ((Boolean)this.f_19804_.m_135370_(IS_IN_TOUR_MODE)).booleanValue());
        compoundTag.m_128379_("REQUIRES_TAG_REFRESH", ((Boolean)this.f_19804_.m_135370_(REQUIRES_TAG_REFRESH)).booleanValue());
        compoundTag.m_128350_("MAX_SPEED", this.currentMaxSpeed);
        compoundTag.m_128405_("stopTicks", this.stopTicks);
        compoundTag.m_128359_("LINKED_VEHICLE", this.followTarget == null ? (this.linkedVehicleUUID == null ? "" : this.linkedVehicleUUID.toString()) : this.followTarget.m_20149_());
        compoundTag.m_128379_("inPursuit", this.isInPursuit);
        compoundTag.m_128359_("railDir", this.railDir.m_122433_());
        compoundTag.m_128405_("railPosX", this.currentRail == null ? 0 : this.currentRail.m_123341_());
        compoundTag.m_128405_("railPosY", this.currentRail == null ? -9999 : this.currentRail.m_123342_());
        compoundTag.m_128405_("railPosZ", this.currentRail == null ? 0 : this.currentRail.m_123343_());
        compoundTag.m_128379_("cantFindRail", this.cantFindRail);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(IS_IN_TOUR_MODE, (Object)compoundTag.m_128471_("IS_IN_TOUR_MODE"));
        this.f_19804_.m_135381_(REQUIRES_TAG_REFRESH, (Object)compoundTag.m_128471_("REQUIRES_TAG_REFRESH"));
        this.currentMaxSpeed = compoundTag.m_128457_("MAX_SPEED");
        this.stopTicks = compoundTag.m_128451_("stopTicks");
        try {
            this.linkedVehicleUUID = UUID.fromString(compoundTag.m_128461_("LINKED_VEHICLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isInPursuit = compoundTag.m_128471_("inPursuit");
        this.railDir = (Direction)Direction.f_175356_.m_262792_(compoundTag.m_128461_("railDir"), (Enum)Direction.NORTH);
        int y = compoundTag.m_128451_("railPosY");
        if (y != -9999) {
            int x = compoundTag.m_128451_("railPosX");
            int z = compoundTag.m_128451_("railPosZ");
            this.currentRail = new BlockPos(x, y, z);
        }
        this.cantFindRail = compoundTag.m_128471_("cantFindRail");
    }

    public void unlink() {
        if (this.followTarget != null && !this.isInPursuit) {
            this.followTarget.unlink();
        }
        if (this.isInPursuit && this.followTarget != null) {
            this.currentMaxSpeed = this.followTarget.currentMaxSpeed;
        }
        this.linkedVehicleUUID = null;
        this.isInPursuit = false;
        this.followTarget = null;
    }

    @Override
    public float getMaxSpeed() {
        if (this.isInTour()) {
            return this.currentMaxSpeed;
        }
        return super.getMaxSpeed();
    }

    private boolean isInTour() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_TOUR_MODE);
    }

    @Override
    public boolean canTriggerNearbyDoors() {
        return true;
    }

    @Override
    protected Item vehicleItem() {
        return (Item)JSItems.FORD_EXPLORER.get();
    }

    @Override
    protected void initializeSeats() {
        this.addSeat(0.5, 0.55, 0.2);
        this.addSeat(-0.5, 0.55, 0.2);
        this.addSeat(0.5, 0.5, -1.25);
        this.addSeat(-0.5, 0.5, -1.25);
    }

    @Override
    public void initItem(ItemStack itemInHand, UseOnContext context) {
        this.railDir = Direction.m_122364_((double)this.m_146908_()).m_122424_();
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (this.followTarget != null) {
            this.followTarget.unlink();
        }
    }

    public void trigger(TriggerTourRailEntity railEntity) {
        if (this.lastTriggerPos != railEntity.m_58899_()) {
            this.lastTriggerPos = railEntity.m_58899_();
            if ((float)railEntity.getSpeed() > 0.0f) {
                this.setSpeed((float)railEntity.getSpeed() / 100.0f);
                if (this.followTarget != null) {
                    this.followTarget.setSpeed((float)railEntity.getSpeed() / 100.0f);
                }
            }
            if ((float)railEntity.getStopTicks() > 0.0f) {
                this.stopFor(railEntity.getStopTicks());
            }
        }
    }

    public Direction getRailDir() {
        return this.railDir;
    }

    public BlockPos getCurrentRail() {
        return this.currentRail;
    }

    public BlockPos getLastTriggerPos() {
        return this.lastTriggerPos;
    }

    public int getStopTicks() {
        return this.stopTicks;
    }

    public int getBlockedTicks() {
        return this.blockedTicks;
    }

    public FordExplorerEntity getFollowTarget() {
        return this.followTarget;
    }

    public UUID getLinkedVehicleUUID() {
        return this.linkedVehicleUUID;
    }

    public boolean isInPursuit() {
        return this.isInPursuit;
    }

    public boolean isCantFindRail() {
        return this.cantFindRail;
    }

    public float getCurrentMaxSpeed() {
        return this.currentMaxSpeed;
    }
}

