/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.client.base.sound.SoundRelayer;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.entity.obj.other.LerpRotHolder;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.VehicleAnimations;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import jp.jurassicsaga.server.v2.item.obj.WrenchItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class JSVehicleEntity
extends Entity
implements LerpRotHolder {
    protected static final EntityDataAccessor<Float> CURRENT_SPEED = SynchedEntityData.m_135353_(JSVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(JSVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> HAS_DRIVER = SynchedEntityData.m_135353_(JSVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CAN_BE_DRIVEN = SynchedEntityData.m_135353_(JSVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final VehicleAnimations module;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    public float yHeadRot;
    public float yHeadRotO;
    public float rearWheelRot = 0.0f;
    public float frontLeftWheelRot = 0.0f;
    public float frontRightWheelRot = 0.0f;
    protected final List<SeatEntity> seats = new LinkedList<SeatEntity>();
    protected float maxSpeed = 2.0f;
    protected float maxSpeedBackwards = 0.5f;
    protected float acceleration = 0.1f;
    protected float turnSpeed = 0.1f;
    protected float maxTurnSpeed = 5.0f;
    protected float currentTurn = 0.0f;
    protected final SeatEntity driverSeat;
    protected boolean hasDriver = true;

    public JSVehicleEntity(EntityType<? extends JSVehicleEntity> entityType, Level level) {
        super(entityType, level);
        this.initializeSeats();
        this.driverSeat = this.seats.get(0);
        for (SeatEntity seat : this.seats) {
            level.m_7967_((Entity)seat);
            Vec3 relative = seat.getRelativePos();
            seat.m_6021_(relative.f_82479_, relative.f_82480_, relative.f_82481_);
        }
        this.module = new VehicleAnimations(this);
        if (!level.f_46443_) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(100.0f));
        }
    }

    public boolean m_6087_() {
        return true;
    }

    protected abstract void initializeSeats();

    protected void addSeat(double x, double y, double z) {
        this.seats.add(new SeatEntity(this.m_9236_(), new Vec3(x, y, z), true, this));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_20159_()) {
            if (this.driverSeat.m_146895_() != null && this.driverSeat.m_146895_() == player) {
                if (!this.m_9236_().f_46443_) {
                    this.honk();
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!this.hasRiders()) {
            if (player.m_6144_() && !this.m_9236_().f_46443_ && this.shiftInteraction(player, hand)) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_150930_((Item)JSV2Items.WRENCH.get())) {
                if (!this.m_9236_().f_46443_) {
                    return this.wrenchInteract(hand, WrenchItem.WrenchMode.fromStack(player.m_21120_(hand)), player);
                }
                return InteractionResult.SUCCESS;
            }
            SeatEntity closestSeat = null;
            double closestDistance = Double.MAX_VALUE;
            for (SeatEntity seat : this.seats) {
                double distance = player.m_20182_().m_82554_(seat.m_20182_());
                if (!(distance < closestDistance)) continue;
                closestSeat = seat;
                closestDistance = distance;
            }
            if (closestSeat != null && closestSeat.hasNoPassenger()) {
                player.m_20329_((Entity)closestSeat);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean hasRiders() {
        for (SeatEntity seat : this.seats) {
            if (seat.hasNoPassenger()) continue;
            return true;
        }
        return false;
    }

    void honk() {
        Entity passenger;
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)JSSounds.CAR_HONK.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
        Optional<SeatEntity> optionalSeatEntity = this.seats.stream().filter(seatEntity -> seatEntity.m_146895_() != null).findFirst();
        if (optionalSeatEntity.isPresent() && (passenger = optionalSeatEntity.get().m_146895_()) instanceof Player) {
            Player player = (Player)passenger;
            List animals = this.m_9236_().m_6443_(JSAnimalBase.class, this.m_20191_().m_82400_(10.0), a -> true);
            for (JSAnimalBase animal : animals) {
                if (animal.getModules().getMetabolismModule().canTarget(true, true, this)) {
                    animal.m_6710_((LivingEntity)player);
                    JSAnimalBase trueLeader = animal.getModules().getHerdModule().getTrueLeader();
                    if (trueLeader != null) {
                        for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                            if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                                follower.m_6710_((LivingEntity)player);
                                continue;
                            }
                            follower.setFleeTarget((Entity)player);
                        }
                        trueLeader.m_6710_((LivingEntity)player);
                    }
                    animal.setFleeTarget(null);
                    continue;
                }
                animal.setFleeTarget((Entity)player);
                animal.m_6710_(null);
            }
        }
    }

    protected InteractionResult wrenchInteract(InteractionHand hand, WrenchItem.WrenchMode wrenchMode, Player player) {
        return InteractionResult.SUCCESS;
    }

    protected boolean shiftInteraction(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand != null) {
            if (!itemInHand.m_41619_()) {
                if (((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() < 100.0f) {
                    boolean takeOne = false;
                    if (itemInHand.m_150930_(Items.f_42416_)) {
                        takeOne = true;
                        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Math.min(100.0f, ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() + 25.0f)));
                    } else if (itemInHand.m_150930_(Items.f_41913_)) {
                        takeOne = true;
                        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(100.0f));
                    } else if (itemInHand.m_150930_(Items.f_42749_)) {
                        takeOne = true;
                        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Math.min(100.0f, ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() + 2.0f)));
                    }
                    if (takeOne) {
                        if (itemInHand.m_41613_() > 1) {
                            itemInHand.m_41774_(1);
                        } else {
                            itemInHand = ItemStack.f_41583_;
                        }
                        player.m_21008_(hand, itemInHand);
                        player.m_5496_(SoundEvents.f_12009_, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (this.vehicleItem() != null) {
                ItemStack vehicleItem = this.vehicleItem().m_7968_();
                Float health = (Float)this.f_19804_.m_135370_(HEALTH);
                CompoundTag tag = vehicleItem.m_41784_();
                tag.m_128350_("health", health.floatValue());
                vehicleItem.m_41751_(tag);
                if (player.m_150109_().m_36054_(vehicleItem)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.onRemove();
                    return true;
                }
            }
        }
        return false;
    }

    protected void onRemove() {
    }

    protected abstract Item vehicleItem();

    public boolean m_142265_(Level level, BlockPos pos) {
        return true;
    }

    public boolean m_7313_(Entity entity) {
        return false;
    }

    public void disableDriver() {
        this.hasDriver = false;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        return super.m_7111_(player, vec, hand);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_7337_(Entity entity) {
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compoundTag.m_128457_("health")));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
    }

    public boolean m_271807_() {
        return true;
    }

    public boolean m_264410_() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(HAS_DRIVER, (Object)false);
        this.f_19804_.m_135372_(CAN_BE_DRIVEN, (Object)false);
    }

    public boolean m_142389_() {
        return true;
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.yHeadRotO = this.yHeadRot;
        this.yHeadRot = this.m_146908_();
        super.m_8119_();
        this.tickLerp();
        if (!this.m_9236_().f_46443_) {
            this.animateServer();
            if (this.hasDriver && this.driverSeat != null && !this.m_20069_()) {
                Player driver = (Player)this.driverSeat.m_146895_();
                if (driver == null) {
                    this.f_19804_.m_135381_(HAS_DRIVER, (Object)false);
                }
                this.updateDriver(driver);
            } else {
                this.updateNoDriver();
            }
            this.handleCollision();
            this.checkForClimbingBlocks();
            this.updateSeats(this.m_146908_());
        } else {
            float health = ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
            if (health < 80.0f) {
                int amount = Mth.m_14045_((int)((int)((80.0f - health) / 60.0f) + 1), (int)1, (int)2);
                float forwardOffset = 2.0f;
                float yawRad = this.m_146908_() * ((float)Math.PI / 180);
                double fx = Math.sin(-yawRad) * (double)forwardOffset;
                double fz = Math.cos(-yawRad) * (double)forwardOffset;
                for (int i = 0; i < amount; ++i) {
                    double px = this.f_19854_ + fx + (this.f_19796_.m_188500_() - 0.5) * 1.0;
                    double py = this.f_19855_ + 1.5 + this.f_19796_.m_188500_() * 0.1;
                    double pz = this.f_19856_ + fz + (this.f_19796_.m_188500_() - 0.5) * 1.0;
                    double vy = 0.05 + this.f_19796_.m_188500_() * 0.2;
                    SimpleParticleType smokeType = health < 60.0f ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_;
                    this.m_9236_().m_7106_((ParticleOptions)smokeType, px, py, pz, 0.0, vy, 0.0);
                    if (!(health < 10.0f) || !(this.f_19796_.m_188501_() < 0.3f)) continue;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, px, py, pz, 0.0, 0.1, 0.0);
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            if (((Boolean)this.f_19804_.m_135370_(HAS_DRIVER)).booleanValue()) {
                SoundRelayer.playCarLoop(this);
            } else if ((double)((Float)this.f_19804_.m_135370_(CURRENT_SPEED)).floatValue() == 0.0) {
                SoundRelayer.stopCarLoop(this);
            }
        }
    }

    protected void updateNoDriver() {
        if (((Boolean)this.f_19804_.m_135370_(HAS_DRIVER)).booleanValue()) {
            this.f_19804_.m_135381_(HAS_DRIVER, (Object)false);
        }
        float currentSpeed = this.getCurrentSpeed();
        if (Math.abs(currentSpeed *= 0.9f) < 1.0E-4f) {
            currentSpeed = 0.0f;
        }
        this.currentTurn *= 0.85f;
        if (Math.abs(this.currentTurn) < 1.0E-4f) {
            this.currentTurn = 0.0f;
        }
        this.m_146922_(this.m_146908_() + this.currentTurn);
        double dx = -Math.sin(Math.toRadians(this.m_146908_())) * (double)currentSpeed;
        double dz = Math.cos(Math.toRadians(this.m_146908_())) * (double)currentSpeed;
        Vec3 movementVec = this.applyGravityToVec(dx, dz);
        this.m_6478_(MoverType.SELF, movementVec);
        this.setCurrentSpeed(currentSpeed);
    }

    protected void updateDriver(Player driver) {
        float currentSpeed = this.getCurrentSpeed();
        this.f_19804_.m_135381_(HAS_DRIVER, (Object)(driver != null ? 1 : 0));
        if (driver instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)driver;
            if ((double)serverPlayer.f_20902_ > 0.0) {
                currentSpeed = Math.min(currentSpeed + this.acceleration, this.maxSpeed);
            } else if ((double)serverPlayer.f_20902_ < 0.0) {
                currentSpeed = Math.max(currentSpeed - this.acceleration, -this.maxSpeedBackwards);
            } else if (Math.abs(currentSpeed *= 0.7f) < 1.0E-4f) {
                currentSpeed = 0.0f;
            }
            this.currentTurn = (double)serverPlayer.f_20900_ < 0.0 ? this.maxTurnSpeed : ((double)serverPlayer.f_20900_ > 0.0 ? -this.maxTurnSpeed : 0.0f);
        } else {
            if (Math.abs(currentSpeed *= 0.7f) < 1.0E-4f) {
                currentSpeed = 0.0f;
            }
            this.currentTurn = 0.0f;
        }
        this.m_146922_(this.m_146908_() + this.currentTurn);
        double dx = -Math.sin(Math.toRadians(this.m_146908_())) * (double)currentSpeed;
        double dz = Math.cos(Math.toRadians(this.m_146908_())) * (double)currentSpeed;
        Vec3 movementVec = this.applyGravityToVec(dx, dz);
        this.m_6478_(MoverType.SELF, movementVec);
        this.setCurrentSpeed(currentSpeed);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Float health = (Float)this.f_19804_.m_135370_(HEALTH);
        if ((health = Float.valueOf(health.floatValue() - amount)).floatValue() <= 0.0f) {
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.BLOCK);
            }
            for (SeatEntity seat : this.seats) {
                seat.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_19804_.m_135381_(HEALTH, (Object)health);
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    protected void animateServer() {
        boolean isMoving = (double)this.getCurrentSpeed() != 0.0 && !this.m_20069_();
        boolean left = this.hasPlayerOnSide(false);
        boolean right = this.hasPlayerOnSide(true);
        this.module.playTransition(left && !isMoving, JSAnimations.VEHICLE_OPEN_DOOR_LEFT.wrap(10), JSAnimations.VEHICLE_OPENED_DOOR_LEFT.wrap(), JSAnimations.VEHICLE_CLOSE_DOOR_LEFT.wrap(10));
        this.module.playTransition(right && !isMoving, JSAnimations.VEHICLE_OPEN_DOOR_RIGHT.wrap(10), JSAnimations.VEHICLE_OPENED_DOOR_RIGHT.wrap(), JSAnimations.VEHICLE_CLOSE_DOOR_RIGHT.wrap(10));
    }

    public boolean m_20069_() {
        return !this.m_9236_().m_6425_(BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, 1.5, 0.0))).m_76178_();
    }

    private boolean hasPlayerOnSide(boolean right) {
        double range = 3.0;
        List players = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(range), p -> !p.m_5833_() && p.m_6084_() && !p.m_20159_());
        if (players.isEmpty()) {
            return false;
        }
        float bodyRot = this.m_146908_();
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)bodyRot);
        Vec3 rightVec = new Vec3(forward.f_82481_, 0.0, -forward.f_82479_);
        for (Player p2 : players) {
            Vec3 rel = p2.m_20182_().m_82546_(this.m_20182_());
            double side = rel.m_82526_(rightVec);
            if (!right && side > 0.0) {
                return true;
            }
            if (!right || !(side < 0.0)) continue;
            return true;
        }
        return false;
    }

    Vec3 applyGravityToVec(double dx, double dz) {
        return new Vec3(dx, -1.0, dz);
    }

    protected void checkForClimbingBlocks() {
        Vec3[] dirs;
        double checkDist = (double)this.m_20205_() + 0.1;
        double push = 0.55;
        double yaw = Math.toRadians(this.m_146908_());
        double sin = Math.sin(yaw);
        double cos = Math.cos(yaw);
        Vec3 forward = new Vec3(-sin, 0.0, cos);
        for (Vec3 d : dirs = new Vec3[]{forward, new Vec3(-sin + cos * 0.7, 0.0, cos + sin * 0.7), new Vec3(-sin - cos * 0.7, 0.0, cos - sin * 0.7)}) {
            boolean entitySpaceClear;
            Vec3 nd = d.m_82541_();
            double checkX = this.m_20185_() + nd.f_82479_ * checkDist;
            double checkZ = this.m_20189_() + nd.f_82481_ * checkDist;
            BlockPos pos = new BlockPos(Mth.m_14107_((double)checkX), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)checkZ));
            if (!this.m_9236_().m_8055_(pos).m_280296_()) continue;
            BlockState base = this.m_9236_().m_8055_(pos);
            BlockState step = this.m_9236_().m_8055_(pos.m_7494_());
            BlockState step2 = this.m_9236_().m_8055_(pos.m_6630_(2));
            boolean isStep = base.m_280296_() && step.m_60812_((BlockGetter)this.m_9236_(), pos.m_7494_()).m_83281_() && step2.m_60812_((BlockGetter)this.m_9236_(), pos.m_6630_(2)).m_83281_();
            BlockPos entUp = this.m_20183_().m_6630_((int)this.m_20206_());
            BlockPos entUp2 = entUp.m_7494_();
            boolean bl = entitySpaceClear = this.m_9236_().m_8055_(entUp).m_60812_((BlockGetter)this.m_9236_(), entUp).m_83281_() && this.m_9236_().m_8055_(entUp2).m_60812_((BlockGetter)this.m_9236_(), entUp2).m_83281_();
            if (isStep) {
                if (entitySpaceClear) {
                    Vec3 p = this.m_20182_();
                    Vec3 newPos = new Vec3(p.f_82479_ + nd.f_82479_ * 0.55, p.f_82480_ + 1.0, p.f_82481_ + nd.f_82481_ * 0.55);
                    if (!this.canMoveTo(newPos)) break;
                    this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                    break;
                }
            } else if (d == forward) {
                this.setCurrentSpeed(0.0f);
            }
            return;
        }
    }

    private boolean canMoveTo(Vec3 newPos) {
        AABB movedBox = this.m_20191_().m_82383_(newPos).m_82400_(0.1);
        return this.m_9236_().m_45756_((Entity)this, movedBox);
    }

    void handleCollision() {
        if ((double)Math.abs(this.getCurrentSpeed()) < 0.1) {
            return;
        }
        AABB boundingBox = this.m_20191_();
        Vec3 movementDirection = new Vec3(-Math.sin(Math.toRadians(this.m_146908_())), 0.0, Math.cos(Math.toRadians(this.m_146908_()))).m_82541_();
        List collidedEntities = this.m_9236_().m_6249_((Entity)this, boundingBox.m_82400_((double)0.1f).m_82383_(movementDirection.m_82542_(0.1, 1.0, 0.1)), entity -> {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (SeatEntity seat : this.seats) {
                if (seat.m_146895_() == null) continue;
                entities.add(seat.m_146895_());
            }
            return !entities.contains(entity) && this.m_7337_((Entity)entity);
        });
        for (Entity entity2 : collidedEntities) {
            Vec3 entityDirection;
            double dotProduct;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (entity2 == this.m_146895_() || !((dotProduct = movementDirection.m_82526_(entityDirection = entity2.m_20182_().m_82546_(this.m_20182_()).m_82541_())) > 0.5)) continue;
            this.setCurrentSpeed(this.getCurrentSpeed() - 1.0f);
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)JSSounds.CAR_BONK.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && this.m_9236_().f_46443_) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    protected void lerpPositionAndRotationStep(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d0 = 1.0 / (double)steps;
        double d1 = Mth.m_14139_((double)d0, (double)this.m_20185_(), (double)targetX);
        double d2 = Mth.m_14139_((double)d0, (double)this.m_20186_(), (double)targetY);
        double d3 = Mth.m_14139_((double)d0, (double)this.m_20189_(), (double)targetZ);
        float f = Mth.m_14189_((float)((float)d0), (float)this.m_146908_(), (float)((float)targetYRot));
        float f1 = (float)Mth.m_14139_((double)d0, (double)this.m_146909_(), (double)targetXRot);
        this.m_6034_(d1, d2, d3);
        this.m_19915_(f, f1);
    }

    public float getCurrentSpeed() {
        return ((Float)this.m_20088_().m_135370_(CURRENT_SPEED)).floatValue();
    }

    public void setCurrentSpeed(float speed) {
        this.m_20088_().m_135381_(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.m_20185_();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.m_20186_();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.m_20189_();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.m_146909_();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.m_146908_();
    }

    private float approachZero(float value, float step) {
        if (value > 0.0f) {
            return Math.max(value - step, 0.0f);
        }
        if (value < 0.0f) {
            return Math.min(value + step, 0.0f);
        }
        return 0.0f;
    }

    void updateSeats(float yRot) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double cosRot = Math.cos(Math.toRadians(yRot));
        double sinRot = Math.sin(Math.toRadians(yRot));
        for (SeatEntity seat : this.seats) {
            if (seat.getRelativePos() == null) continue;
            double relativeX = seat.getRelativePos().f_82479_;
            double relativeZ = seat.getRelativePos().f_82481_;
            double rotatedX = relativeX * cosRot - relativeZ * sinRot;
            double rotatedZ = relativeX * sinRot + relativeZ * cosRot;
            seat.m_146922_(yRot);
            seat.m_146884_(new Vec3(x + rotatedX, y + seat.getRelativePos().f_82480_, z + rotatedZ));
        }
    }

    public void initItem(ItemStack itemInHand, UseOnContext context) {
    }

    public void setHealth(float health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(health));
    }

    public boolean canTriggerNearbyDoors() {
        return false;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public float getMaxSpeedBackwards() {
        return this.maxSpeedBackwards;
    }

    public void setMaxSpeedBackwards(float maxSpeedBackwards) {
        this.maxSpeedBackwards = maxSpeedBackwards;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float acceleration) {
        this.acceleration = acceleration;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float turnSpeed) {
        this.turnSpeed = turnSpeed;
    }

    public float getMaxTurnSpeed() {
        return this.maxTurnSpeed;
    }

    public void setMaxTurnSpeed(float maxTurnSpeed) {
        this.maxTurnSpeed = maxTurnSpeed;
    }

    public float getCurrentTurn() {
        return this.currentTurn;
    }
}

