/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import jp.jurassicsaga.server.base.item.JSItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class JeepWranglerEntity
extends JSVehicleEntity {
    private static final EntityDataAccessor<Boolean> HAS_COVER = SynchedEntityData.m_135353_(JeepWranglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public JeepWranglerEntity(EntityType<? extends JSVehicleEntity> entityType, Level level) {
        super(entityType, level);
        this.setMaxSpeed(0.9f);
        this.setTurnSpeed(5.0f);
        this.setMaxTurnSpeed(5.0f);
        this.setAcceleration(0.03f);
        this.setMaxSpeedBackwards(0.4f);
    }

    @Override
    public boolean canTriggerNearbyDoors() {
        return true;
    }

    @Override
    protected Item vehicleItem() {
        return (Item)JSItems.JEEP_WRANGLER.get();
    }

    @Override
    protected boolean shiftInteraction(Player player, InteractionHand hand) {
        if (this.hasCover()) {
            if (player.m_150109_().m_36054_(((Item)JSItems.JEEP_WRANGLER_COVER.get()).m_7968_())) {
                this.setCover(false);
                return true;
            }
        } else {
            ItemStack itemInHand = player.m_21120_(hand);
            if (itemInHand.m_150930_((Item)JSItems.JEEP_WRANGLER_COVER.get())) {
                this.setCover(true);
                if (itemInHand.m_41613_() == 1) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    player.m_21120_(hand).m_41774_(1);
                }
                return true;
            }
        }
        return super.shiftInteraction(player, hand);
    }

    @Override
    protected void onRemove() {
        ItemEntity itemEntity;
        if (this.hasCover() && (itemEntity = (ItemEntity)EntityType.f_20461_.m_20615_(this.m_9236_())) != null) {
            itemEntity.m_32045_(((Item)JSItems.JEEP_WRANGLER_COVER.get()).m_7968_());
            itemEntity.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_COVER, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("js.vehicle.has_cover", this.hasCover());
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCover(compoundTag.m_128471_("js.vehicle.has_cover"));
    }

    private void setCover(boolean aBoolean) {
        this.f_19804_.m_135381_(HAS_COVER, (Object)aBoolean);
    }

    public boolean hasCover() {
        return (Boolean)this.f_19804_.m_135370_(HAS_COVER);
    }

    @Override
    protected void initializeSeats() {
        this.addSeat(0.5, 0.55, 0.2);
        this.addSeat(-0.5, 0.55, 0.2);
        this.addSeat(0.5, 0.5, -1.25);
        this.addSeat(-0.5, 0.5, -1.25);
    }
}

