/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.physics;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PhysicsEntity
extends Entity {
    private Vec3 angularVelocity = Vec3.f_82478_;
    private float zRot = 0.0f;
    private float zRotOld = 0.0f;
    public final float[] rawXRotHistory = new float[3];
    public final float[] rawYRotHistory = new float[3];
    public final float[] rawZRotHistory = new float[3];
    private float lastXRot;
    private float lastYRot;
    private float lastZRot;
    private float xAccum;
    private float yAccum;
    private float zAccum;

    public PhysicsEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        Vec3 horiz;
        super.m_8119_();
        double gravity = this.getPhysicsGravity();
        double bounciness = this.getBounciness();
        double friction = this.getFriction();
        double angularDrag = this.getAngularDrag();
        double smoothFactor = this.getPhysicsSmoothing();
        Vec3 velocity = this.m_20184_();
        Vec3 pushForce = Vec3.f_82478_;
        double pushStrength = 0.05;
        List nearby = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(3.0), e -> e != this);
        for (Entity other : nearby) {
            Vec3 diff = this.m_20182_().m_82546_(other.m_20182_());
            double dist = diff.m_82556_() * 2.0;
            if (!(dist > 0.0) || !(dist < 1.0)) continue;
            Vec3 dir = diff.m_82541_();
            double factor = 1.0 - dist;
            Vec3 relVel = this.m_20184_().m_82546_(other.m_20184_());
            double relSpeed = relVel.m_82526_(dir);
            double momentum = Mth.m_14008_((double)relSpeed, (double)-1.0, (double)1.0);
            pushForce = pushForce.m_82549_(dir.m_82490_(pushStrength * factor * (1.0 + momentum)));
        }
        velocity = velocity.m_82549_(pushForce);
        velocity = !this.m_9236_().m_6425_(this.m_20183_()).m_76178_() ? velocity.m_82520_(0.0, 0.01, 0.0) : velocity.m_82520_(0.0, -gravity, 0.0);
        this.m_6478_(MoverType.SELF, velocity);
        if (this.f_19862_ && (horiz = new Vec3(velocity.f_82479_, 0.0, velocity.f_82481_)).m_82556_() > 1.0E-4) {
            Vec3 normal = horiz.m_82541_();
            double impact = Mth.m_14008_((double)(Math.abs(velocity.m_82526_(normal)) * 2.0), (double)1.0, (double)10.0);
            double bounce = bounciness * impact;
            velocity = velocity.m_82546_(normal.m_82490_(2.0 * velocity.m_82526_(normal))).m_82490_(bounce);
        }
        if (this.f_19863_ && velocity.f_82480_ < 0.0) {
            double impactFactor = Mth.m_14008_((double)Math.abs(velocity.f_82480_), (double)0.5, (double)2.0);
            double bounce = bounciness * impactFactor;
            velocity = new Vec3(velocity.f_82479_, -velocity.f_82480_ * bounce, velocity.f_82481_);
            this.angularVelocity = this.angularVelocity.m_82520_((velocity.f_82481_ - velocity.f_82479_) * 10.0, this.f_19796_.m_188500_() * 15.0 - 7.5, (velocity.f_82479_ + velocity.f_82481_) * 10.0);
        }
        double angularSpeed = this.angularVelocity.m_82553_();
        double angularFriction = 1.0 - Mth.m_14008_((double)Math.pow(angularSpeed * 4.0, 2.0), (double)0.0, (double)1.0);
        angularFriction = Mth.m_14008_((double)angularFriction, (double)angularDrag, (double)0.98);
        this.angularVelocity = this.angularVelocity.m_82520_(velocity.f_82481_ * 5.0, 0.0, -velocity.f_82479_ * 5.0);
        this.angularVelocity = new Vec3(this.lerp(this.angularVelocity.f_82479_, this.angularVelocity.f_82479_, smoothFactor), this.lerp(this.angularVelocity.f_82480_, this.angularVelocity.f_82480_, smoothFactor), this.lerp(this.angularVelocity.f_82481_, this.angularVelocity.f_82481_, smoothFactor));
        boolean setYRot = true;
        if (this.f_19863_ && velocity.m_82556_() < 0.01) {
            this.angularVelocity = new Vec3(Mth.m_14139_((double)0.1f, (double)this.angularVelocity.f_82479_, (double)0.0), this.angularVelocity.f_82480_ * angularDrag, Mth.m_14139_((double)0.1f, (double)this.angularVelocity.f_82481_, (double)0.0));
            this.m_146926_(Mth.m_14179_((float)0.1f, (float)this.m_146909_(), (float)0.0f));
            this.setZRot(Mth.m_14179_((float)0.1f, (float)this.getZRot(), (float)0.0f));
            setYRot = false;
        } else {
            this.angularVelocity = this.angularVelocity.m_82542_(angularDrag, angularDrag, angularDrag);
        }
        this.angularVelocity = this.angularVelocity.m_82542_(angularFriction, angularFriction, angularFriction);
        velocity = velocity.m_82542_(friction, friction, friction);
        this.m_20256_(velocity);
        this.zRotOld = this.zRot;
        if (setYRot) {
            this.m_146926_(this.m_146909_() + (float)this.angularVelocity.f_82479_);
            this.m_146922_(this.m_146908_() + (float)this.angularVelocity.f_82480_);
            this.setZRot(this.getZRot() + (float)this.angularVelocity.f_82481_);
        }
        this.setParams();
    }

    public float m_274421_() {
        return 1.0f;
    }

    private void setParams() {
        this.xAccum += this.getWrappedDelta(this.m_146909_(), this.lastXRot);
        this.yAccum += this.getWrappedDelta(this.m_146908_(), this.lastYRot);
        this.zAccum += this.getWrappedDelta(this.getZRot(), this.lastZRot);
        this.lastXRot = this.m_146909_();
        this.lastYRot = this.m_146908_();
        this.lastZRot = this.getZRot();
        this.rawXRotHistory[2] = this.rawXRotHistory[1];
        this.rawXRotHistory[1] = this.rawXRotHistory[0];
        this.rawXRotHistory[0] = this.xAccum;
        this.rawYRotHistory[2] = this.rawYRotHistory[1];
        this.rawYRotHistory[1] = this.rawYRotHistory[0];
        this.rawYRotHistory[0] = this.yAccum;
        this.rawZRotHistory[2] = this.rawZRotHistory[1];
        this.rawZRotHistory[1] = this.rawZRotHistory[0];
        this.rawZRotHistory[0] = this.zAccum;
    }

    private float getWrappedDelta(float current, float last) {
        return Mth.m_14177_((float)(current - last));
    }

    protected double getPhysicsSmoothing() {
        return 0.2;
    }

    protected double getAngularDrag() {
        return 0.92;
    }

    protected double getFriction() {
        return 0.96;
    }

    protected double getBounciness() {
        return 0.8;
    }

    protected double getPhysicsGravity() {
        return 0.15;
    }

    private double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public void m_5844_() {
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
    }

    public void setAngularVelocity(Vec3 angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public void setZRot(float zRot) {
        this.zRot = zRot;
    }

    public float getZRot() {
        return this.zRot;
    }

    public float getZRotOld() {
        return this.zRotOld;
    }
}

