/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jurassicsaga.JSCommon;
import net.minecraft.resources.ResourceLocation;

public final class Versions {
    private static final Map<ResourceLocation, Version> REGISTRY = new LinkedHashMap<ResourceLocation, Version>();
    public static Version ALL;
    public static Version VERSION_1;
    public static Version VERSION_2;
    public static Version VERSION_2_5;
    public static Version VERSION_3;
    public static Version VERSION_4;
    public static Version VERSION_4_5;
    public static Version VERSION_5;
    public static Version VERSION_5_5;
    public static Version VERSION_6;

    public static void init() {
        ALL = Versions.register("all", -1.0f);
        VERSION_1 = Versions.register("1.0", 1.0f);
        VERSION_2 = Versions.register("2.0", 2.0f);
        if (!JSCommon.config.experimentalFeatures) {
            return;
        }
        VERSION_4 = Versions.register("4.0", 4.0f);
    }

    private static Version register(String path, float versionId) {
        return Versions.register(JSCommon.createId(path), versionId);
    }

    public static Version register(ResourceLocation path, float versionId) {
        Version version = new Version(versionId, path);
        REGISTRY.put(path, version);
        return version;
    }

    public static Version get(String path) {
        return Versions.get(JSCommon.createId(path));
    }

    public static Version get(ResourceLocation path) {
        return REGISTRY.get(path);
    }

    public static Collection<Version> values() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    private Versions() {
    }

    public static Map<ResourceLocation, Version> getREGISTRY() {
        return REGISTRY;
    }

    public record Version(float versionId, ResourceLocation resourceLocation) {
    }
}

