/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JSGeneUtil {
    public static JSGeneData fromCompound(@Nullable CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return new JSGeneData();
        }
        JSGeneData data = new JSGeneData();
        data.loadFromNbt(tag);
        return data;
    }

    public static JSGeneData readFromStack(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return new JSGeneData();
        }
        CompoundTag tag = stack.m_41784_().m_128469_("jsGeneData");
        return JSGeneUtil.fromCompound(tag);
    }

    public static ItemStack writeToStack(ItemStack stack, JSGeneData geneData) {
        if (stack == null || stack.m_41619_() || geneData == null) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        geneData.saveToNbt(tag);
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("jsGeneData", (Tag)tag);
        stack.m_41751_(stackTag);
        return stack;
    }

    public static ItemStack wipeStack(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128473_("jsGeneData");
            stack.m_41751_(stackTag);
        }
        return stack;
    }

    public static JSGeneData combineBreeding(RandomSource random, JSGeneData geneData, JSGeneData fatherGeneData) {
        List<JSGene> motherGenes = geneData.geneDataHolder.getGENE_SET();
        List<JSGene> fatherGenes = fatherGeneData.geneDataHolder.getGENE_SET();
        JSGeneData babyGenes = geneData.copy().resetGenes();
        ArrayList<JSGene> possible = new ArrayList<JSGene>();
        HashSet<JSGene> all = new HashSet<JSGene>();
        all.addAll(motherGenes);
        all.addAll(fatherGenes);
        for (JSGene gene : all) {
            if (gene == null) continue;
            double intChance = 0.5;
            if (!gene.canBeInherited()) continue;
            if (motherGenes.contains(gene) && fatherGenes.contains(gene)) {
                intChance = Mth.m_14008_((double)(intChance + 0.25), (double)0.0, (double)1.0);
            }
            if (intChance == 0.0 || intChance != 1.0 && !((double)random.m_188501_() <= intChance)) continue;
            possible.add(gene);
        }
        if (!possible.isEmpty()) {
            for (JSGene gene : possible) {
                if (gene == null) continue;
                babyGenes.addGene(gene);
            }
        }
        return babyGenes;
    }
}

