/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.networking.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.screen.JSScreens;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.server.packet.obj.TravelersBasePacket;

public final class OpenGuiPacket
extends TravelersBasePacket<OpenGuiPacket> {
    public static final TravelersPacketsHandler<OpenGuiPacket> handler = OpenGuiPacket.handler();
    private final ResourceLocation registryName;
    private final String guiName;
    private final int entityId;
    public static final ResourceLocation ID = JSCommon.createId("opengui");

    public OpenGuiPacket(ResourceLocation registryName, String guiName, int entityId) {
        this.registryName = registryName;
        this.guiName = guiName;
        this.entityId = entityId;
    }

    public OpenGuiPacket(FriendlyByteBuf buf) {
        this.registryName = buf.m_130281_();
        this.guiName = buf.m_130277_();
        this.entityId = buf.readInt();
    }

    public OpenGuiPacket() {
        this.registryName = null;
        this.guiName = null;
        this.entityId = 0;
    }

    public ResourceLocation registryName() {
        return this.registryName;
    }

    public String guiName() {
        return this.guiName;
    }

    public int entityId() {
        return this.entityId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.registryName);
        buf.m_130070_(this.guiName);
        buf.writeInt(this.entityId);
    }

    public OpenGuiPacket decode(FriendlyByteBuf buf) {
        return new OpenGuiPacket(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    private static TravelersPacketsHandler<OpenGuiPacket> handler() {
        return new TravelersPacketsHandler<OpenGuiPacket>(){

            public void handleClient(OpenGuiPacket packet) {
                JSScreens.syncGuis(packet);
            }

            public void handleServer(OpenGuiPacket packet, ServerPlayer sender) {
            }
        };
    }
}

