/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.networking.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AbstractFeederEntity;
import jp.jurassicsaga.server.v2.block.entity.obj.TriggerTourRailEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.util.helper.PlatformHelper;

public final class UpdateMachinePacket
extends TravelersBasePacket<UpdateMachinePacket> {
    public static final TravelersPacketsHandler<UpdateMachinePacket> handler = UpdateMachinePacket.handler();
    private final ResourceLocation level;
    private final BlockPos blockPos;
    private final String machineName;
    private final String dataType;
    private final String newData;
    public static final ResourceLocation ID = JSCommon.createId("updatemachine");

    public UpdateMachinePacket(ResourceLocation level, BlockPos blockPos, String machineName, String dataType, String newData) {
        this.level = level;
        this.blockPos = blockPos;
        this.machineName = machineName;
        this.dataType = dataType;
        this.newData = newData;
    }

    public UpdateMachinePacket(FriendlyByteBuf buf) {
        this.level = buf.m_130281_();
        this.blockPos = buf.m_130135_();
        this.machineName = buf.m_130277_();
        this.dataType = buf.m_130277_();
        this.newData = buf.m_130277_();
    }

    public UpdateMachinePacket() {
        this.level = null;
        this.blockPos = BlockPos.f_121853_;
        this.machineName = null;
        this.dataType = null;
        this.newData = null;
    }

    public ResourceLocation level() {
        return this.level;
    }

    public BlockPos blockPos() {
        return this.blockPos;
    }

    public String machineName() {
        return this.machineName;
    }

    public String dataType() {
        return this.dataType;
    }

    public String newData() {
        return this.newData;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.level);
        buf.m_130064_(this.blockPos);
        buf.m_130070_(this.machineName);
        buf.m_130070_(this.dataType);
        buf.m_130070_(this.newData);
    }

    public UpdateMachinePacket decode(FriendlyByteBuf buf) {
        return new UpdateMachinePacket(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    private static TravelersPacketsHandler<UpdateMachinePacket> handler() {
        return new TravelersPacketsHandler<UpdateMachinePacket>(){

            public void handleClient(UpdateMachinePacket packet) {
            }

            public void handleServer(UpdateMachinePacket packet, ServerPlayer sender) {
                ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)packet.level());
                try {
                    ServerLevel level = PlatformHelper.properties.getServer().m_129880_(type);
                    if (level != null) {
                        GenericMachineEntity blockEntity;
                        BlockEntity blockEntity2;
                        if (packet.machineName().equalsIgnoreCase("feeder") && (blockEntity2 = level.m_7702_(packet.blockPos())) instanceof AbstractFeederEntity) {
                            blockEntity = (AbstractFeederEntity)blockEntity2;
                            ((AbstractFeederEntity)blockEntity).setSliderPos(Integer.parseInt(packet.newData()));
                        }
                        if (packet.machineName().equalsIgnoreCase("trigger") && (blockEntity2 = level.m_7702_(packet.blockPos())) instanceof TriggerTourRailEntity) {
                            blockEntity = (TriggerTourRailEntity)blockEntity2;
                            if (packet.dataType.equalsIgnoreCase("stop_time")) {
                                ((TriggerTourRailEntity)blockEntity).setStopTicks(Integer.parseInt(packet.newData()));
                            } else if (packet.dataType.equalsIgnoreCase("speed")) {
                                ((TriggerTourRailEntity)blockEntity).setSpeed(Integer.parseInt(packet.newData()));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

